/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.plugin.weex;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.BindingXTouchHandler;
import com.alibaba.android.bindingx.plugin.weex.WXModuleUtils;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;

public class BindingXGestureHandler
extends BindingXTouchHandler {
    private boolean experimental = false;
    private WXGesture mWeexGestureHandler = null;

    public BindingXGestureHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
    }

    public void setGlobalConfig(@Nullable Map<String, Object> globalConfig) {
        super.setGlobalConfig(globalConfig);
        if (globalConfig != null) {
            this.experimental = WXUtils.getBoolean((Object)globalConfig.get("experimentalGestureFeatures"), (Boolean)false);
        }
    }

    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        if (!this.experimental) {
            return super.onCreate(sourceRef, eventType);
        }
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        WXComponent sourceComponent = WXModuleUtils.findComponentByRef(instanceId, sourceRef);
        if (sourceComponent == null) {
            return super.onCreate(sourceRef, eventType);
        }
        View view = sourceComponent.getHostView();
        if (!(view instanceof ViewGroup) || !(view instanceof WXGestureObservable)) {
            return super.onCreate(sourceRef, eventType);
        }
        try {
            WXGestureObservable gestureTarget = (WXGestureObservable)view;
            this.mWeexGestureHandler = gestureTarget.getGestureListener();
            if (this.mWeexGestureHandler != null) {
                this.mWeexGestureHandler.addOnTouchListener((View.OnTouchListener)this);
                LogProxy.d((String)("[ExpressionGestureHandler] onCreate success. {source:" + sourceRef + ",type:" + eventType + "}"));
                return true;
            }
            return super.onCreate(sourceRef, eventType);
        }
        catch (Throwable e) {
            LogProxy.e((String)("experimental gesture features open failed." + e.getMessage()));
            return super.onCreate(sourceRef, eventType);
        }
    }

    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        boolean result = super.onDisable(sourceRef, eventType);
        if (this.experimental && this.mWeexGestureHandler != null) {
            try {
                result |= this.mWeexGestureHandler.removeTouchListener((View.OnTouchListener)this);
            }
            catch (Throwable e) {
                LogProxy.e((String)("[ExpressionGestureHandler]  disabled failed." + e.getMessage()));
            }
        }
        return result;
    }
}

