/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.taobao.weex.ui.component.DCTextArea;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXEditText;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ISysEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ConfirmBar {
    private static ConfirmBar instance;
    private ViewGroup rootView;
    private RelativeLayout rtl;
    private List<WXComponent> editText = new ArrayList<WXComponent>();
    private int height;
    private AtomicReference<ISysEventListener> listener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ConfirmBar getInstance() {
        if (instance != null) return instance;
        Class<ConfirmBar> clazz = ConfirmBar.class;
        synchronized (ConfirmBar.class) {
            if (instance != null) return instance;
            instance = new ConfirmBar();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void showConfirm(boolean isShow, int margin) {
        try {
            if (this.rtl == null) {
                return;
            }
            View appView = null;
            if (this.rootView != null) {
                appView = this.rootView.findViewWithTag((Object)"AppRootView");
            }
            if (isShow) {
                if (this.rootView != null) {
                    FrameLayout.LayoutParams appParams = (FrameLayout.LayoutParams)appView.getLayoutParams();
                    appParams.bottomMargin = this.height;
                    appView.setLayoutParams((ViewGroup.LayoutParams)appParams);
                }
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.rtl.getLayoutParams();
                params.topMargin = margin;
                this.rtl.setLayoutParams((ViewGroup.LayoutParams)params);
                this.rtl.setVisibility(0);
                this.rtl.bringToFront();
            } else {
                this.rtl.setVisibility(4);
                if (appView != null) {
                    FrameLayout.LayoutParams appParams = (FrameLayout.LayoutParams)appView.getLayoutParams();
                    appParams.bottomMargin = 0;
                    appView.setLayoutParams((ViewGroup.LayoutParams)appParams);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addComponent(WXComponent component) {
        try {
            this.editText.add(component);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeComponent(WXComponent component) {
        try {
            this.editText.remove(component);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void createConfirmBar(final Context context, IApp mApp) {
        try {
            if (this.listener == null) {
                ISysEventListener listener1 = new ISysEventListener(){

                    public boolean onExecute(ISysEventListener.SysEventType pEventType, Object pArgs) {
                        if (pEventType == ISysEventListener.SysEventType.onSizeChanged) {
                            int[] values = (int[])pArgs;
                            int sh = context.getResources().getDisplayMetrics().heightPixels;
                            int imeh = context.getResources().getDisplayMetrics().heightPixels / 4;
                            if (Math.abs(values[1] - sh) > imeh || Math.abs(values[1] - values[3]) > imeh) {
                                if (values[1] > values[3] && Math.abs(values[1] - values[3]) > imeh) {
                                    ConfirmBar.getInstance().showConfirm(false, values[1]);
                                } else {
                                    for (WXComponent component : ConfirmBar.this.editText) {
                                        if (component.getHostView().hasFocus() && component instanceof DCTextArea && ((DCTextArea)component).isShowConfirm) {
                                            ConfirmBar.getInstance().showConfirm(true, values[1]);
                                            break;
                                        }
                                        ConfirmBar.getInstance().showConfirm(false, values[1]);
                                    }
                                }
                            }
                        } else if (pEventType == ISysEventListener.SysEventType.onWebAppStop) {
                            ConfirmBar.this.listener = null;
                            ConfirmBar.this.rtl = null;
                            ConfirmBar.this.rootView = null;
                        }
                        return false;
                    }
                };
                this.listener = new AtomicReference<1>(listener1);
                mApp.registerSysEventListener(this.listener.get(), ISysEventListener.SysEventType.onSizeChanged);
                mApp.registerSysEventListener(this.listener.get(), ISysEventListener.SysEventType.onWebAppStop);
            }
            this.height = (int)TypedValue.applyDimension((int)1, (float)44.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            if (this.rtl == null) {
                this.rtl = new RelativeLayout(context);
                this.rootView = (ViewGroup)mApp.obtainWebAppRootView().obtainMainView().getParent();
                if (this.rootView != null) {
                    FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, this.height);
                    this.rootView.addView((View)this.rtl, (ViewGroup.LayoutParams)params);
                }
                Button btn = new Button(context);
                btn.setText(17039370);
                btn.setGravity(17);
                btn.setTextColor(Color.argb((int)255, (int)50, (int)205, (int)50));
                btn.setTextSize(TypedValue.applyDimension((int)2, (float)6.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
                btn.setBackground(null);
                btn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ConfirmBar.this.editText.size() > 0) {
                            WXComponent focusComponent = null;
                            for (WXComponent component : ConfirmBar.this.editText) {
                                if (!(component.getHostView() instanceof WXEditText) || !component.getHostView().hasFocus()) continue;
                                focusComponent = component;
                                break;
                            }
                            if (focusComponent != null) {
                                HashMap<String, Object> detail = new HashMap<String, Object>(1);
                                HashMap<String, String> par = new HashMap<String, String>(1);
                                par.put("value", ((WXEditText)focusComponent.getHostView()).getText().toString());
                                detail.put("detail", par);
                                focusComponent.fireEvent("confirm", detail);
                                if (focusComponent.getParent() != null) {
                                    focusComponent.getParent().interceptFocus();
                                }
                                focusComponent.getHostView().clearFocus();
                                ((DCTextArea)focusComponent).hideSoftKeyboard();
                            }
                        }
                    }
                });
                this.rtl.addView((View)btn, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -1));
                this.rtl.setBackgroundColor(Color.argb((int)255, (int)220, (int)220, (int)220));
                this.rtl.setTag((Object)"ConfirmBar");
                this.rtl.setVisibility(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

