/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.plugin.soundEffect;

import cn.rongcloud.rtc.plugin.soundEffect.IPreSoundEffectOperation;
import cn.rongcloud.rtc.plugin.soundEffect.ISounEffectOperation;
import cn.rongcloud.rtc.plugin.soundEffect.SoundEffect;
import java.nio.ByteBuffer;

public abstract class SoundEffectOperation
implements ISounEffectOperation,
SoundEffect {
    private ISounEffectOperation nextOperation;
    private IPreSoundEffectOperation preAudioSourceOperation;
    private int channel;
    private int sampleRate;
    private int audioFormat;

    public SoundEffectOperation(IPreSoundEffectOperation preAudioSourceOperation) {
        this.preAudioSourceOperation = preAudioSourceOperation;
        if (this.preAudioSourceOperation != null) {
            this.preAudioSourceOperation.addNext(this);
        }
    }

    @Override
    public void initParams(int sampleRate, int channel, int audioFormat) {
        this.sampleRate = sampleRate;
        this.channel = channel;
        this.audioFormat = audioFormat;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public void addNext(ISounEffectOperation next) {
        this.nextOperation = next;
    }

    @Override
    public void process(ByteBuffer buffer, int dataLength) {
        int operatedSize = this.operate(buffer, dataLength);
        if (this.nextOperation != null) {
            this.nextOperation.process(buffer, operatedSize);
        }
    }

    @Override
    public void operated(ByteBuffer buffer, int dataLength) {
        if (this.preAudioSourceOperation != null) {
            this.preAudioSourceOperation.operated(buffer, dataLength);
        }
    }

    @Override
    public void linkPreOperation(IPreSoundEffectOperation operation) {
        this.preAudioSourceOperation = operation;
        this.preAudioSourceOperation.addNext(this);
    }

    @Override
    public abstract int operate(ByteBuffer var1, int var2);

    protected void processNextOperation(ByteBuffer buffer, int dataLength) {
        if (this.nextOperation != null) {
            this.nextOperation.process(buffer, dataLength);
        }
    }
}

