/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.sheetmusic;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.jinmingyunle.midiplaylib.listener.ScrollAnimationListener;
import com.jinmingyunle.midiplaylib.midifile.MidiEvent;
import com.jinmingyunle.midiplaylib.midifile.MidiFile;
import com.jinmingyunle.midiplaylib.midifile.MidiNote;
import com.jinmingyunle.midiplaylib.midifile.MidiOptions;
import com.jinmingyunle.midiplaylib.midifile.MidiPlayer;
import com.jinmingyunle.midiplaylib.midifile.MidiTrack;
import com.jinmingyunle.midiplaylib.musictools.NoteDuration;
import com.jinmingyunle.midiplaylib.musictools.TimeSignature;
import com.jinmingyunle.midiplaylib.sheetmusic.BoxedInt;
import com.jinmingyunle.midiplaylib.sheetmusic.KeySignature;
import com.jinmingyunle.midiplaylib.sheetmusic.Staff;
import com.jinmingyunle.midiplaylib.symbol.AccidSymbol;
import com.jinmingyunle.midiplaylib.symbol.BarSymbol;
import com.jinmingyunle.midiplaylib.symbol.BlankSymbol;
import com.jinmingyunle.midiplaylib.symbol.ChordSymbol;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.symbol.ClefSymbol;
import com.jinmingyunle.midiplaylib.symbol.LyricSymbol;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;
import com.jinmingyunle.midiplaylib.symbol.RestSymbol;
import com.jinmingyunle.midiplaylib.symbol.TimeSigSymbol;
import com.jinmingyunle.midiplaylib.utils.ListInt;
import com.jinmingyunle.midiplaylib.utils.NoteScale;
import com.jinmingyunle.midiplaylib.view.ClefMeasures;
import com.jinmingyunle.midiplaylib.view.ScrollAnimation;
import com.jinmingyunle.midiplaylib.view.SymbolWidths;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class SheetMusic
extends SurfaceView
implements SurfaceHolder.Callback,
ScrollAnimationListener {
    public static final int LineWidth = 2;
    public static final int LeftMargin = 6;
    public static final int LineSpace = 7;
    public static final int StaffHeight = 38;
    public static final int NoteHeight = 9;
    public static final int NoteWidth = 10;
    public static final int PageWidth = 800;
    public static final int PageHeight = 1050;
    public static final int TitleHeight = 14;
    public static final int ImmediateScroll = 1;
    public static final int GradualScroll = 2;
    public static final int DontScroll = 3;
    private ArrayList<Staff> staffs;
    private KeySignature mainkey;
    private String filename;
    private int numtracks;
    private float zoom;
    private boolean scrollVert;
    private int showNoteLetters;
    private int[] NoteColors;
    private int shade1;
    private int shade2;
    private Paint paint;
    private boolean surfaceReady;
    private Bitmap bufferBitmap;
    private Canvas bufferCanvas;
    private MidiPlayer player;
    private int playerHeight;
    private int screenwidth;
    private int screenheight;
    private int sheetwidth;
    private int sheetheight;
    private int viewwidth;
    private int viewheight;
    private int bufferX;
    private int bufferY;
    private int scrollX;
    private int scrollY;
    private ScrollAnimation scrollAnimation;

    public SheetMusic(Context context) {
        super(context);
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        this.scrollY = 0;
        this.scrollX = 0;
        this.bufferY = 0;
        this.bufferX = 0;
        Activity activity = (Activity)context;
        this.screenwidth = activity.getWindowManager().getDefaultDisplay().getWidth();
        this.screenheight = activity.getWindowManager().getDefaultDisplay().getHeight();
        this.playerHeight = MidiPlayer.getPreferredSize((int)this.screenwidth, (int)this.screenheight).y;
    }

    public void init(MidiFile file, MidiOptions options) {
        if (options == null) {
            options = new MidiOptions(file);
        }
        this.zoom = 1.0f;
        this.filename = file.getFileName();
        this.SetColors(null, options.shade1Color, options.shade2Color);
        this.paint = new Paint();
        this.paint.setTextSize(12.0f);
        Typeface typeface = Typeface.create((Typeface)this.paint.getTypeface(), (int)0);
        this.paint.setTypeface(typeface);
        this.paint.setColor(-65536);
        ArrayList<MidiTrack> tracks = file.ChangeMidiNotes(options);
        this.scrollVert = options.scrollVert;
        this.showNoteLetters = options.showNoteLetters;
        TimeSignature time = file.getTime();
        if (options.time != null) {
            time = options.time;
        }
        this.mainkey = options.key == -1 ? this.GetKeySignature(tracks) : new KeySignature(options.key);
        this.numtracks = tracks.size();
        int lastStart = file.EndTime() + options.shifttime;
        ArrayList<ArrayList<MusicSymbol>> allsymbols = new ArrayList<ArrayList<MusicSymbol>>(this.numtracks);
        for (int tracknum = 0; tracknum < this.numtracks; ++tracknum) {
            MidiTrack track = tracks.get(tracknum);
            ClefMeasures clefs = new ClefMeasures(track.getNotes(), time.getMeasure());
            ArrayList<ChordSymbol> chords = this.CreateChords(track.getNotes(), this.mainkey, time, clefs);
            allsymbols.add(this.CreateSymbols(chords, clefs, time, lastStart));
        }
        ArrayList<ArrayList<LyricSymbol>> lyrics = null;
        if (options.showLyrics) {
            lyrics = SheetMusic.GetLyrics(tracks);
        }
        SymbolWidths widths = new SymbolWidths(allsymbols, lyrics);
        this.AlignSymbols(allsymbols, widths, options);
        this.staffs = this.CreateStaffs(allsymbols, this.mainkey, options, time.getMeasure());
        SheetMusic.CreateAllBeamedChords(allsymbols, time);
        if (lyrics != null) {
            SheetMusic.AddLyricsToStaffs(this.staffs, lyrics);
        }
        for (Staff staff : this.staffs) {
            staff.CalculateHeight();
        }
        this.zoom = 1.0f;
        this.scrollAnimation = new ScrollAnimation(this, this.scrollVert);
    }

    private void calculateSize() {
        this.sheetwidth = 0;
        this.sheetheight = 0;
        for (Staff staff : this.staffs) {
            this.sheetwidth = Math.max(this.sheetwidth, staff.getWidth());
            this.sheetheight += staff.getHeight();
        }
        this.sheetwidth += 2;
        this.sheetheight += 6;
    }

    protected void onMeasure(int widthspec, int heightspec) {
        int specwidth = View.MeasureSpec.getSize((int)widthspec);
        int specheight = View.MeasureSpec.getSize((int)heightspec);
        if (specwidth == 0 && specheight == 0) {
            this.setMeasuredDimension(this.screenwidth, this.screenheight);
        } else if (specwidth == 0) {
            this.setMeasuredDimension(this.screenwidth, specheight);
        } else if (specheight == 0) {
            this.setMeasuredDimension(specwidth, this.screenheight);
        } else {
            this.setMeasuredDimension(specwidth, specheight);
        }
    }

    protected void onSizeChanged(int newwidth, int newheight, int oldwidth, int oldheight) {
        this.viewwidth = newwidth;
        this.viewheight = newheight;
        if (this.bufferCanvas != null) {
            this.callOnDraw();
            return;
        }
        this.calculateSize();
        if (this.scrollVert) {
            this.zoom = (float)((double)(newwidth - 2) * 1.0 / 800.0);
        } else {
            this.zoom = (float)((double)(newheight + this.playerHeight) * 1.0 / (double)this.sheetheight);
            if ((double)this.zoom < 0.9) {
                this.zoom = 0.9f;
            }
            if ((double)this.zoom > 1.1) {
                this.zoom = 1.1f;
            }
        }
        if (this.bufferCanvas == null) {
            this.createBufferCanvas();
        }
        this.callOnDraw();
    }

    private KeySignature GetKeySignature(ArrayList<MidiTrack> tracks) {
        ListInt notenums = new ListInt();
        for (MidiTrack track : tracks) {
            for (MidiNote note : track.getNotes()) {
                notenums.add(note.getNumber());
            }
        }
        return KeySignature.Guess(notenums);
    }

    private ArrayList<ChordSymbol> CreateChords(ArrayList<MidiNote> midinotes, KeySignature key, TimeSignature time, ClefMeasures clefs) {
        int i = 0;
        ArrayList<ChordSymbol> chords = new ArrayList<ChordSymbol>();
        ArrayList<MidiNote> notegroup = new ArrayList<MidiNote>(12);
        int len = midinotes.size();
        while (i < len) {
            int starttime = midinotes.get(i).getStartTime();
            Clef clef = clefs.GetClef(starttime);
            notegroup.clear();
            notegroup.add(midinotes.get(i));
            ++i;
            while (i < len && midinotes.get(i).getStartTime() == starttime) {
                notegroup.add(midinotes.get(i));
                ++i;
            }
            ChordSymbol chord = new ChordSymbol(notegroup, key, time, clef, this);
            chords.add(chord);
        }
        return chords;
    }

    private ArrayList<MusicSymbol> CreateSymbols(ArrayList<ChordSymbol> chords, ClefMeasures clefs, TimeSignature time, int lastStart) {
        ArrayList<MusicSymbol> symbols = new ArrayList();
        symbols = this.AddBars(chords, time, lastStart);
        symbols = this.AddRests(symbols, time);
        symbols = this.AddClefChanges(symbols, clefs, time);
        return symbols;
    }

    private ArrayList<MusicSymbol> AddBars(ArrayList<ChordSymbol> chords, TimeSignature time, int lastStart) {
        ArrayList<MusicSymbol> symbols = new ArrayList<MusicSymbol>();
        TimeSigSymbol timesig = new TimeSigSymbol(time.getNumerator(), time.getDenominator());
        symbols.add(timesig);
        int measuretime = 0;
        int i = 0;
        while (i < chords.size()) {
            if (measuretime <= chords.get(i).getStartTime()) {
                symbols.add(new BarSymbol(measuretime));
                measuretime += time.getMeasure();
                continue;
            }
            symbols.add(chords.get(i));
            ++i;
        }
        while (measuretime < lastStart) {
            symbols.add(new BarSymbol(measuretime));
            measuretime += time.getMeasure();
        }
        symbols.add(new BarSymbol(measuretime));
        return symbols;
    }

    private ArrayList<MusicSymbol> AddRests(ArrayList<MusicSymbol> symbols, TimeSignature time) {
        int prevtime = 0;
        ArrayList<MusicSymbol> result = new ArrayList<MusicSymbol>(symbols.size());
        for (MusicSymbol symbol : symbols) {
            int starttime = symbol.getStartTime();
            RestSymbol[] rests = this.GetRests(time, prevtime, starttime);
            if (rests != null) {
                for (RestSymbol r : rests) {
                    result.add(r);
                }
            }
            result.add(symbol);
            if (symbol instanceof ChordSymbol) {
                ChordSymbol chord = (ChordSymbol)symbol;
                prevtime = Math.max(chord.getEndTime(), prevtime);
                continue;
            }
            prevtime = Math.max(starttime, prevtime);
        }
        return result;
    }

    private RestSymbol[] GetRests(TimeSignature time, int start, int end) {
        if (end - start < 0) {
            return null;
        }
        NoteDuration dur = time.GetNoteDuration(end - start);
        switch (dur) {
            case Whole: 
            case Half: 
            case Quarter: 
            case Eighth: {
                RestSymbol r1 = new RestSymbol(start, dur);
                RestSymbol[] result = new RestSymbol[]{r1};
                return result;
            }
            case DottedHalf: {
                RestSymbol r1 = new RestSymbol(start, NoteDuration.Half);
                RestSymbol r2 = new RestSymbol(start + time.getQuarter() * 2, NoteDuration.Quarter);
                RestSymbol[] result = new RestSymbol[]{r1, r2};
                return result;
            }
            case DottedQuarter: {
                RestSymbol r1 = new RestSymbol(start, NoteDuration.Quarter);
                RestSymbol r2 = new RestSymbol(start + time.getQuarter(), NoteDuration.Eighth);
                RestSymbol[] result = new RestSymbol[]{r1, r2};
                return result;
            }
            case DottedEighth: {
                RestSymbol r1 = new RestSymbol(start, NoteDuration.Eighth);
                RestSymbol r2 = new RestSymbol(start + time.getQuarter() / 2, NoteDuration.Sixteenth);
                RestSymbol[] result = new RestSymbol[]{r1, r2};
                return result;
            }
        }
        return null;
    }

    private ArrayList<MusicSymbol> AddClefChanges(ArrayList<MusicSymbol> symbols, ClefMeasures clefs, TimeSignature time) {
        ArrayList<MusicSymbol> result = new ArrayList<MusicSymbol>(symbols.size());
        Clef prevclef = clefs.GetClef(0);
        for (MusicSymbol symbol : symbols) {
            if (symbol instanceof BarSymbol) {
                Clef clef = clefs.GetClef(symbol.getStartTime());
                if (clef != prevclef) {
                    result.add(new ClefSymbol(clef, symbol.getStartTime() - 1, true));
                }
                prevclef = clef;
            }
            result.add(symbol);
        }
        return result;
    }

    private void AlignSymbols(ArrayList<ArrayList<MusicSymbol>> allsymbols, SymbolWidths widths, MidiOptions options) {
        ArrayList<MusicSymbol> symbols;
        int track;
        if (options.showMeasures) {
            for (track = 0; track < allsymbols.size(); ++track) {
                symbols = allsymbols.get(track);
                for (MusicSymbol sym : symbols) {
                    if (!(sym instanceof BarSymbol)) continue;
                    sym.setWidth(sym.getWidth() + 10);
                }
            }
        }
        for (track = 0; track < allsymbols.size(); ++track) {
            symbols = allsymbols.get(track);
            ArrayList<MusicSymbol> result = new ArrayList<MusicSymbol>();
            int i = 0;
            for (int start : widths.getStartTimes()) {
                while (i < symbols.size() && symbols.get(i) instanceof BarSymbol && symbols.get(i).getStartTime() <= start) {
                    result.add(symbols.get(i));
                    ++i;
                }
                if (i < symbols.size() && symbols.get(i).getStartTime() == start) {
                    while (i < symbols.size() && symbols.get(i).getStartTime() == start) {
                        result.add(symbols.get(i));
                        ++i;
                    }
                    continue;
                }
                result.add(new BlankSymbol(start, 0));
            }
            i = 0;
            while (i < result.size()) {
                if (result.get(i) instanceof BarSymbol) {
                    ++i;
                    continue;
                }
                int start = ((MusicSymbol)result.get(i)).getStartTime();
                int extra = widths.GetExtraWidth(track, start);
                int newwidth = ((MusicSymbol)result.get(i)).getWidth() + extra;
                ((MusicSymbol)result.get(i)).setWidth(newwidth);
                while (i < result.size() && ((MusicSymbol)result.get(i)).getStartTime() == start) {
                    ++i;
                }
            }
            allsymbols.set(track, result);
        }
    }

    private static boolean FindConsecutiveChords(ArrayList<MusicSymbol> symbols, TimeSignature time, int startIndex, int[] chordIndexes, BoxedInt horizDistance) {
        boolean foundChords;
        int i = startIndex;
        int numChords = chordIndexes.length;
        block0: do {
            ChordSymbol c;
            horizDistance.value = 0;
            while (!(i >= symbols.size() - numChords || symbols.get(i) instanceof ChordSymbol && (c = (ChordSymbol)symbols.get(i)).getStem() != null)) {
                ++i;
            }
            if (i >= symbols.size() - numChords) {
                chordIndexes[0] = -1;
                return false;
            }
            chordIndexes[0] = i;
            foundChords = true;
            for (int chordIndex = 1; chordIndex < numChords; ++chordIndex) {
                ++i;
                int remaining = numChords - 1 - chordIndex;
                while (i < symbols.size() - remaining && symbols.get(i) instanceof BlankSymbol) {
                    horizDistance.value += symbols.get(i).getWidth();
                    ++i;
                }
                if (i >= symbols.size() - remaining) {
                    return false;
                }
                if (!(symbols.get(i) instanceof ChordSymbol)) {
                    foundChords = false;
                    continue block0;
                }
                chordIndexes[chordIndex] = i;
                horizDistance.value += symbols.get(i).getWidth();
            }
        } while (!foundChords);
        return true;
    }

    private static void CreateBeamedChords(ArrayList<ArrayList<MusicSymbol>> allsymbols, TimeSignature time, int numChords, boolean startBeat) {
        int[] chordIndexes = new int[numChords];
        ChordSymbol[] chords = new ChordSymbol[numChords];
        block0: for (ArrayList<MusicSymbol> symbols : allsymbols) {
            int startIndex = 0;
            while (true) {
                BoxedInt horizDistance = new BoxedInt();
                horizDistance.value = 0;
                boolean found = SheetMusic.FindConsecutiveChords(symbols, time, startIndex, chordIndexes, horizDistance);
                if (!found) continue block0;
                for (int i = 0; i < numChords; ++i) {
                    chords[i] = (ChordSymbol)symbols.get(chordIndexes[i]);
                }
                if (ChordSymbol.CanCreateBeam(chords, time, startBeat)) {
                    ChordSymbol.CreateBeam(chords, horizDistance.value);
                    startIndex = chordIndexes[numChords - 1] + 1;
                    continue;
                }
                startIndex = chordIndexes[0] + 1;
            }
        }
    }

    private static void CreateAllBeamedChords(ArrayList<ArrayList<MusicSymbol>> allsymbols, TimeSignature time) {
        if (time.getNumerator() == 3 && time.getDenominator() == 4 || time.getNumerator() == 6 && time.getDenominator() == 8 || time.getNumerator() == 6 && time.getDenominator() == 4) {
            SheetMusic.CreateBeamedChords(allsymbols, time, 6, true);
        }
        SheetMusic.CreateBeamedChords(allsymbols, time, 3, true);
        SheetMusic.CreateBeamedChords(allsymbols, time, 4, true);
        SheetMusic.CreateBeamedChords(allsymbols, time, 2, true);
        SheetMusic.CreateBeamedChords(allsymbols, time, 2, false);
    }

    public static int KeySignatureWidth(KeySignature key) {
        AccidSymbol[] keys;
        ClefSymbol clefsym = new ClefSymbol(Clef.Treble, 0, false);
        int result = clefsym.getMinWidth();
        for (AccidSymbol symbol : keys = key.GetSymbols(Clef.Treble)) {
            result += symbol.getMinWidth();
        }
        return result + 6 + 5;
    }

    private ArrayList<Staff> CreateStaffsForTrack(ArrayList<MusicSymbol> symbols, int measurelen, KeySignature key, MidiOptions options, int track, int totaltracks) {
        int keysigWidth = SheetMusic.KeySignatureWidth(key);
        int startindex = 0;
        ArrayList<Staff> thestaffs = new ArrayList<Staff>(symbols.size() / 50);
        while (startindex < symbols.size()) {
            int endindex;
            int width = keysigWidth;
            int maxwidth = this.scrollVert ? 800 : 2000000;
            for (endindex = startindex; endindex < symbols.size() && width + symbols.get(endindex).getWidth() < maxwidth; ++endindex) {
                width += symbols.get(endindex).getWidth();
            }
            if (--endindex != symbols.size() - 1 && symbols.get(startindex).getStartTime() / measurelen != symbols.get(endindex).getStartTime() / measurelen) {
                int endmeasure = symbols.get(endindex + 1).getStartTime() / measurelen;
                while (symbols.get(endindex).getStartTime() / measurelen == endmeasure) {
                    --endindex;
                }
            }
            if (this.scrollVert) {
                width = 800;
            }
            ArrayList<MusicSymbol> staffSymbols = new ArrayList<MusicSymbol>();
            for (int i = startindex; i <= endindex; ++i) {
                staffSymbols.add(symbols.get(i));
            }
            Staff staff = new Staff(staffSymbols, key, options, track, totaltracks);
            thestaffs.add(staff);
            startindex = endindex + 1;
        }
        return thestaffs;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Staff> CreateStaffs(ArrayList<ArrayList<MusicSymbol>> allsymbols, KeySignature key, MidiOptions options, int measurelen) {
        void var8_14;
        int i;
        ArrayList<ArrayList<Staff>> trackstaffs = new ArrayList<ArrayList<Staff>>(allsymbols.size());
        int totaltracks = allsymbols.size();
        for (int track = 0; track < totaltracks; ++track) {
            ArrayList<MusicSymbol> arrayList = allsymbols.get(track);
            trackstaffs.add(this.CreateStaffsForTrack(arrayList, measurelen, key, options, track, totaltracks));
        }
        for (ArrayList arrayList : trackstaffs) {
            for (i = 0; i < arrayList.size() - 1; ++i) {
                ((Staff)arrayList.get(i)).setEndTime(((Staff)arrayList.get(i + 1)).getStartTime());
            }
        }
        int maxstaffs = 0;
        boolean bl = false;
        while (var8_14 < trackstaffs.size()) {
            if (maxstaffs < ((ArrayList)trackstaffs.get((int)var8_14)).size()) {
                maxstaffs = ((ArrayList)trackstaffs.get((int)var8_14)).size();
            }
            ++var8_14;
        }
        ArrayList<Staff> arrayList = new ArrayList<Staff>(maxstaffs * trackstaffs.size());
        for (i = 0; i < maxstaffs; ++i) {
            for (ArrayList arrayList2 : trackstaffs) {
                if (i >= arrayList2.size()) continue;
                arrayList.add((Staff)arrayList2.get(i));
            }
        }
        return arrayList;
    }

    public void SetColors(int[] newcolors, int newshade1, int newshade2) {
        int i;
        if (this.NoteColors == null) {
            this.NoteColors = new int[12];
            for (i = 0; i < 12; ++i) {
                this.NoteColors[i] = -16711936;
            }
        }
        if (newcolors != null) {
            for (i = 0; i < 12; ++i) {
                this.NoteColors[i] = newcolors[i];
            }
        }
        this.shade1 = newshade1;
        this.shade2 = newshade2;
    }

    public int NoteColor(int number) {
        return this.NoteColors[NoteScale.FromNumber(number)];
    }

    public int getShade1() {
        return this.shade1;
    }

    public int getShade2() {
        return this.shade2;
    }

    public int getShowNoteLetters() {
        return this.showNoteLetters;
    }

    public KeySignature getMainKey() {
        return this.mainkey;
    }

    private static ArrayList<ArrayList<LyricSymbol>> GetLyrics(ArrayList<MidiTrack> tracks) {
        boolean hasLyrics = false;
        ArrayList<ArrayList<LyricSymbol>> result = new ArrayList<ArrayList<LyricSymbol>>();
        for (int tracknum = 0; tracknum < tracks.size(); ++tracknum) {
            ArrayList<LyricSymbol> lyrics = new ArrayList<LyricSymbol>();
            result.add(lyrics);
            MidiTrack track = tracks.get(tracknum);
            if (track.getLyrics() == null) continue;
            hasLyrics = true;
            for (MidiEvent ev : track.getLyrics()) {
                try {
                    String text = new String(ev.Value, 0, ev.Value.length, "UTF-8");
                    LyricSymbol sym = new LyricSymbol(ev.StartTime, text);
                    lyrics.add(sym);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        if (!hasLyrics) {
            return null;
        }
        return result;
    }

    static void AddLyricsToStaffs(ArrayList<Staff> staffs, ArrayList<ArrayList<LyricSymbol>> tracklyrics) {
        for (Staff staff : staffs) {
            ArrayList<LyricSymbol> lyrics = tracklyrics.get(staff.getTrack());
            staff.AddLyrics(lyrics);
        }
    }

    void createBufferCanvas() {
        if (this.bufferBitmap != null) {
            this.bufferCanvas = null;
            this.bufferBitmap.recycle();
            this.bufferBitmap = null;
        }
        this.bufferBitmap = this.scrollVert ? Bitmap.createBitmap((int)this.viewwidth, (int)((this.viewheight + this.playerHeight) * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)(this.viewwidth * 2), (int)((this.viewheight + this.playerHeight) * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.bufferCanvas = new Canvas(this.bufferBitmap);
        this.drawToBuffer(this.scrollX, this.scrollY);
    }

    public void callOnDraw() {
        if (!this.surfaceReady) {
            return;
        }
        SurfaceHolder holder = this.getHolder();
        Canvas canvas = holder.lockCanvas();
        if (canvas == null) {
            return;
        }
        this.onDraw(canvas);
        holder.unlockCanvasAndPost(canvas);
    }

    protected void onDraw(Canvas canvas) {
        if (this.bufferBitmap == null) {
            this.createBufferCanvas();
        }
        if (!this.isScrollPositionInBuffer()) {
            this.drawToBuffer(this.scrollX, this.scrollY);
        }
        canvas.translate((float)(-(this.scrollX - this.bufferX)), (float)(-(this.scrollY - this.bufferY)));
        canvas.drawBitmap(this.bufferBitmap, 0.0f, 0.0f, this.paint);
        canvas.translate((float)(this.scrollX - this.bufferX), (float)(this.scrollY - this.bufferY));
    }

    private boolean isScrollPositionInBuffer() {
        return this.scrollY >= this.bufferY && this.scrollX >= this.bufferX && this.scrollY <= this.bufferY + this.bufferBitmap.getHeight() / 3 && this.scrollX <= this.bufferX + this.bufferBitmap.getWidth() / 3;
    }

    private void drawToBuffer(int left, int top) {
        if (this.staffs == null) {
            return;
        }
        this.bufferX = left;
        this.bufferY = top;
        this.bufferCanvas.translate((float)(-this.bufferX), (float)(-this.bufferY));
        Rect clip = new Rect(this.bufferX, this.bufferY, this.bufferX + this.bufferBitmap.getWidth(), this.bufferY + this.bufferBitmap.getHeight());
        clip.left = (int)((float)clip.left / this.zoom);
        clip.top = (int)((float)clip.top / this.zoom);
        clip.right = (int)((float)clip.right / this.zoom);
        clip.bottom = (int)((float)clip.bottom / this.zoom);
        this.bufferCanvas.scale(this.zoom, this.zoom);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-1);
        this.bufferCanvas.drawRect((float)clip.left, (float)clip.top, (float)clip.right, (float)clip.bottom, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(-16711936);
        int ypos = 0;
        for (Staff staff : this.staffs) {
            if (ypos + staff.getHeight() >= clip.top && ypos <= clip.bottom) {
                this.bufferCanvas.translate(0.0f, (float)ypos);
                staff.Draw(this.bufferCanvas, clip, this.paint);
                this.bufferCanvas.translate(0.0f, (float)(-ypos));
            }
            ypos += staff.getHeight();
        }
        this.bufferCanvas.scale(1.0f / this.zoom, 1.0f / this.zoom);
        this.bufferCanvas.translate((float)this.bufferX, (float)this.bufferY);
    }

    private void DrawTitle(Canvas canvas) {
        int leftmargin = 20;
        int topmargin = 20;
        String title = this.filename;
        title = title.replace(".mid", "").replace("_", " ");
        canvas.translate((float)leftmargin, (float)topmargin);
        canvas.drawText(title, 0.0f, 0.0f, this.paint);
        canvas.translate((float)(-leftmargin), (float)(-topmargin));
    }

    public int GetTotalPages() {
        int num = 1;
        int currheight = 14;
        if (this.numtracks == 2 && this.staffs.size() % 2 == 0) {
            for (int i = 0; i < this.staffs.size(); i += 2) {
                int heights = this.staffs.get(i).getHeight() + this.staffs.get(i + 1).getHeight();
                if (currheight + heights > 1050) {
                    ++num;
                    currheight = heights;
                    continue;
                }
                currheight += heights;
            }
        } else {
            for (Staff staff : this.staffs) {
                if (currheight + staff.getHeight() > 1050) {
                    ++num;
                    currheight = staff.getHeight();
                    continue;
                }
                currheight += staff.getHeight();
            }
        }
        return num;
    }

    public void DrawPage(Canvas canvas, int pagenumber) {
        int leftmargin = 20;
        int topmargin = 20;
        Rect clip = new Rect(0, 0, 840, 1090);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-1);
        canvas.drawRect((float)clip.left, (float)clip.top, (float)clip.right, (float)clip.bottom, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(-16776961);
        int ypos = 14;
        int pagenum = 1;
        int staffnum = 0;
        if (this.numtracks == 2 && this.staffs.size() % 2 == 0) {
            int heights;
            while (staffnum + 1 < this.staffs.size() && pagenum < pagenumber) {
                heights = this.staffs.get(staffnum).getHeight() + this.staffs.get(staffnum + 1).getHeight();
                if (ypos + heights >= 1050) {
                    ++pagenum;
                    ypos = 0;
                    continue;
                }
                ypos += heights;
                staffnum += 2;
            }
            if (pagenum == 1) {
                this.DrawTitle(canvas);
                ypos = 14;
            } else {
                ypos = 0;
            }
            while (staffnum + 1 < this.staffs.size() && ypos + (heights = this.staffs.get(staffnum).getHeight() + this.staffs.get(staffnum + 1).getHeight()) < 1050) {
                canvas.translate((float)leftmargin, (float)(topmargin + ypos));
                this.staffs.get(staffnum).Draw(canvas, clip, this.paint);
                canvas.translate((float)(-leftmargin), (float)(-(topmargin + ypos)));
                canvas.translate((float)leftmargin, (float)(topmargin + (ypos += this.staffs.get(staffnum).getHeight())));
                this.staffs.get(staffnum + 1).Draw(canvas, clip, this.paint);
                canvas.translate((float)(-leftmargin), (float)(-(topmargin + ypos)));
                ypos += this.staffs.get(staffnum + 1).getHeight();
                staffnum += 2;
            }
        } else {
            while (staffnum < this.staffs.size() && pagenum < pagenumber) {
                if (ypos + this.staffs.get(staffnum).getHeight() >= 1050) {
                    ++pagenum;
                    ypos = 0;
                    continue;
                }
                ypos += this.staffs.get(staffnum).getHeight();
                ++staffnum;
            }
            if (pagenum == 1) {
                this.DrawTitle(canvas);
                ypos = 14;
            } else {
                ypos = 0;
            }
            while (staffnum < this.staffs.size() && ypos + this.staffs.get(staffnum).getHeight() < 1050) {
                canvas.translate((float)leftmargin, (float)(topmargin + ypos));
                this.staffs.get(staffnum).Draw(canvas, clip, this.paint);
                canvas.translate((float)(-leftmargin), (float)(-(topmargin + ypos)));
                ypos += this.staffs.get(staffnum).getHeight();
                ++staffnum;
            }
        }
        canvas.drawText("" + pagenumber, (float)(800 - leftmargin), (float)(topmargin + 1050 - 12), this.paint);
    }

    public void ShadeNotes(int currentPulseTime, int prevPulseTime, int scrollType) {
        if (!this.surfaceReady || this.staffs == null) {
            return;
        }
        if (this.bufferCanvas == null) {
            this.createBufferCanvas();
        }
        if (!this.isScrollPositionInBuffer()) {
            this.drawToBuffer(this.scrollX, this.scrollY);
        }
        this.bufferCanvas.translate((float)(-this.bufferX), (float)(-this.bufferY));
        int x_shade = 0;
        int y_shade = 0;
        this.paint.setAntiAlias(true);
        this.bufferCanvas.scale(this.zoom, this.zoom);
        int ypos = 0;
        for (Staff staff : this.staffs) {
            this.bufferCanvas.translate(0.0f, (float)ypos);
            x_shade = staff.ShadeNotes(this.bufferCanvas, this.paint, this.shade1, currentPulseTime, prevPulseTime, x_shade);
            this.bufferCanvas.translate(0.0f, (float)(-ypos));
            ypos += staff.getHeight();
            if (currentPulseTime < staff.getEndTime()) continue;
            y_shade += staff.getHeight();
        }
        this.bufferCanvas.scale(1.0f / this.zoom, 1.0f / this.zoom);
        this.bufferCanvas.translate((float)this.bufferX, (float)this.bufferY);
        if (currentPulseTime >= 0) {
            x_shade = (int)((float)x_shade * this.zoom);
            y_shade -= 9;
            y_shade = (int)((float)y_shade * this.zoom);
            if (scrollType == 1) {
                this.ScrollToShadedNotes(x_shade, y_shade, false);
            } else if (scrollType == 2) {
                this.ScrollToShadedNotes(x_shade, y_shade, true);
            } else if (scrollType == 3) {
                // empty if block
            }
        }
        if (this.scrollX < this.bufferX || this.scrollY < this.bufferY) {
            this.ShadeNotes(currentPulseTime, prevPulseTime, scrollType);
            return;
        }
        SurfaceHolder holder = this.getHolder();
        Canvas canvas = holder.lockCanvas();
        if (canvas == null) {
            return;
        }
        canvas.translate((float)(-(this.scrollX - this.bufferX)), (float)(-(this.scrollY - this.bufferY)));
        canvas.drawBitmap(this.bufferBitmap, 0.0f, 0.0f, this.paint);
        canvas.translate((float)(this.scrollX - this.bufferX), (float)(this.scrollY - this.bufferY));
        holder.unlockCanvasAndPost(canvas);
    }

    void ScrollToShadedNotes(int x_shade, int y_shade, boolean scrollGradually) {
        if (this.scrollVert) {
            int scrollDist = y_shade - this.scrollY;
            if (scrollGradually) {
                if ((float)scrollDist > this.zoom * 38.0f * 8.0f) {
                    scrollDist /= 2;
                } else if ((float)scrollDist > 36.0f * this.zoom) {
                    scrollDist = (int)(36.0f * this.zoom);
                }
            }
            this.scrollY += scrollDist;
        } else {
            int x_view = this.scrollX + this.viewwidth * 40 / 100;
            int xmax = this.scrollX + this.viewwidth * 65 / 100;
            int scrollDist = x_shade - x_view;
            if (scrollGradually) {
                if (x_shade > xmax) {
                    scrollDist = (x_shade - x_view) / 3;
                } else if (x_shade > x_view) {
                    scrollDist = (x_shade - x_view) / 6;
                }
            }
            this.scrollX += scrollDist;
        }
        this.checkScrollBounds();
    }

    public int PulseTimeForPoint(Point point) {
        Point scaledPoint = new Point((int)((float)point.x / this.zoom), (int)((float)point.y / this.zoom));
        int y = 0;
        for (Staff staff : this.staffs) {
            if (scaledPoint.y >= y && scaledPoint.y <= y + staff.getHeight()) {
                return staff.PulseTimeForPoint(scaledPoint);
            }
            y += staff.getHeight();
        }
        return -1;
    }

    private void checkScrollBounds() {
        int scrollwidth = (int)((float)this.sheetwidth * this.zoom);
        int scrollheight = (int)((float)this.sheetheight * this.zoom);
        if (this.scrollX < 0) {
            this.scrollX = 0;
        }
        if (this.scrollX > scrollwidth - this.viewwidth / 2) {
            this.scrollX = scrollwidth - this.viewwidth / 2;
        }
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        if (this.scrollY > scrollheight - this.viewheight / 2) {
            this.scrollY = scrollheight - this.viewheight / 2;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        boolean result = this.scrollAnimation.onTouchEvent(event);
        switch (action) {
            case 0: {
                if (this.player != null && this.player.getVisibility() == 8) {
                    this.player.Pause();
                    this.scrollAnimation.stopMotion();
                }
                return result;
            }
            case 2: {
                return result;
            }
            case 1: {
                return result;
            }
        }
        return false;
    }

    @Override
    public void scrollUpdate(int deltaX, int deltaY) {
        this.scrollX += deltaX;
        this.scrollY += deltaY;
        this.checkScrollBounds();
        this.callOnDraw();
    }

    @Override
    public void scrollTapped(int x, int y) {
        if (this.player != null) {
            this.player.MoveToClicked(this.scrollX + x, this.scrollY + y);
        }
    }

    public void setPlayer(MidiPlayer p) {
        this.player = p;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.callOnDraw();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.surfaceReady = true;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.surfaceReady = false;
    }

    public String toString() {
        String result = "SheetMusic staffs=" + this.staffs.size() + "\n";
        for (Staff staff : this.staffs) {
            result = result + staff.toString();
        }
        result = result + "End SheetMusic\n";
        return result;
    }
}

