/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.notification;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.notification.BaseNotificationItem;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;

public abstract class FileDownloadNotificationListener
extends FileDownloadListener {
    private final FileDownloadNotificationHelper helper;

    public FileDownloadNotificationListener(FileDownloadNotificationHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException("helper must not be null!");
        }
        this.helper = helper;
    }

    public FileDownloadNotificationHelper getHelper() {
        return this.helper;
    }

    public void addNotificationItem(int downloadId) {
        if (downloadId == 0) {
            return;
        }
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(downloadId);
        if (task != null) {
            this.addNotificationItem(task.getOrigin());
        }
    }

    public void addNotificationItem(BaseDownloadTask task) {
        if (this.disableNotification(task)) {
            return;
        }
        BaseNotificationItem n = this.create(task);
        if (n != null) {
            this.helper.add(n);
        }
    }

    public void destroyNotification(BaseDownloadTask task) {
        if (this.disableNotification(task)) {
            return;
        }
        this.helper.showIndeterminate(task.getId(), task.getStatus());
        Object n = this.helper.remove(task.getId());
        if (!this.interceptCancel(task, (BaseNotificationItem)n) && n != null) {
            ((BaseNotificationItem)n).cancel();
        }
    }

    public void showIndeterminate(BaseDownloadTask task) {
        if (this.disableNotification(task)) {
            return;
        }
        this.helper.showIndeterminate(task.getId(), task.getStatus());
    }

    public void showProgress(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        if (this.disableNotification(task)) {
            return;
        }
        this.helper.showProgress(task.getId(), task.getSmallFileSoFarBytes(), task.getSmallFileTotalBytes());
    }

    protected abstract BaseNotificationItem create(BaseDownloadTask var1);

    protected boolean interceptCancel(BaseDownloadTask task, BaseNotificationItem notificationItem) {
        return false;
    }

    protected boolean disableNotification(BaseDownloadTask task) {
        return false;
    }

    @Override
    protected void pending(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        this.addNotificationItem(task);
        this.showIndeterminate(task);
    }

    @Override
    protected void started(BaseDownloadTask task) {
        super.started(task);
        this.showIndeterminate(task);
    }

    @Override
    protected void progress(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        this.showProgress(task, soFarBytes, totalBytes);
    }

    @Override
    protected void retry(BaseDownloadTask task, Throwable ex, int retryingTimes, int soFarBytes) {
        super.retry(task, ex, retryingTimes, soFarBytes);
        this.showIndeterminate(task);
    }

    @Override
    protected void blockComplete(BaseDownloadTask task) {
    }

    @Override
    protected void completed(BaseDownloadTask task) {
        this.destroyNotification(task);
    }

    @Override
    protected void paused(BaseDownloadTask task, int soFarBytes, int totalBytes) {
        this.destroyNotification(task);
    }

    @Override
    protected void error(BaseDownloadTask task, Throwable e) {
        this.destroyNotification(task);
    }

    @Override
    protected void warn(BaseDownloadTask task) {
    }
}

