/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.report.RCRTCLiveAudioState;
import cn.rongcloud.rtc.api.report.StatusReport;
import java.util.HashMap;
import java.util.List;

public class RCStatusReportListenerWrapper
extends IRCRTCStatusReportListener {
    private IRCRTCStatusReportListener mReportListener;
    private Handler mCallBackHandler;

    public RCStatusReportListenerWrapper(Handler callBackHandler, IRCRTCStatusReportListener reportListener) {
        this.mReportListener = reportListener;
        this.mCallBackHandler = callBackHandler;
    }

    private void postCallbackThread(Runnable runnable) {
        if (this.mReportListener != null) {
            this.mCallBackHandler.post(runnable);
        }
    }

    @Override
    public void onAudioReceivedLevel(final HashMap<String, String> audioLevel) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RCStatusReportListenerWrapper.this.mReportListener.onAudioReceivedLevel(audioLevel);
            }
        });
    }

    @Override
    public void onAudioInputLevel(final String audioLevel) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RCStatusReportListenerWrapper.this.mReportListener.onAudioInputLevel(audioLevel);
            }
        });
    }

    @Override
    public void onConnectionStats(final StatusReport statusReport) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RCStatusReportListenerWrapper.this.mReportListener.onConnectionStats(statusReport);
            }
        });
    }

    @Override
    public void reportLiveAudioStates(final List<RCRTCLiveAudioState> audioStates) {
        this.postCallbackThread(new Runnable(){

            @Override
            public void run() {
                RCStatusReportListenerWrapper.this.mReportListener.reportLiveAudioStates(audioStates);
            }
        });
    }
}

