/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.graphics.Bitmap;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoOutputFrameListener;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoSource;
import cn.rongcloud.rtc.api.callback.RCRTCVideoOutputStreamEventListener;
import cn.rongcloud.rtc.api.stream.RCRTCSurfaceTextureHelper;
import cn.rongcloud.rtc.api.stream.RCRTCVideoOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRect;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RCRTCVideoFrame;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCVideoConfigImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.core.CapturerObserver;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.NV21Buffer;
import cn.rongcloud.rtc.core.OesToRgbFilter;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.VideoSource;
import cn.rongcloud.rtc.core.VideoSourceObserver;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.BitmapUtil;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import io.rong.common.RLog;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class RCVideoOutStreamImpl
extends RCOutputStreamImpl
implements RCRTCVideoOutputStream,
IRCRTCVideoSource.IRCVideoConsumer,
ILocalVideoStreamResource,
CapturerObserver {
    private static final String TAG = "RCVideoOutStreamImpl";
    protected RCRTCBaseView mVideoView;
    protected RCRTCStreamType mStreamType = RCRTCStreamType.NORMAL;
    protected RCRTCVideoStreamConfig videoStreamConfig = RCRTCVideoStreamConfig.Builder.create().build();
    private VideoSource mVideoSource;
    private IRCRTCVideoSource source;
    protected VideoSourceObserver mVideoObserver;
    private RCRTCSurfaceTextureHelper textureHelper;
    private IRCRTCVideoOutputFrameListener frameListener;
    private RCRTCVideoOutputStreamEventListener eventListener;
    private OesToRgbFilter rgbFilter;
    private String mWaterPath;
    private RCRTCRect mWaterRect;
    private int mWaterWidth;
    private int mWaterHeight;

    public RCVideoOutStreamImpl(String tag, String userId) {
        super(tag, RCRTCMediaType.VIDEO, RCVideoOutStreamImpl.makeStreamId(userId, tag));
        this.setUserId(userId);
    }

    @Override
    public synchronized void setSource(IRCRTCVideoSource source) {
        this.source = source;
        if (source != null) {
            source.onInit(this);
        }
    }

    @Override
    public synchronized void setVideoView(RCRTCBaseView videoView) {
        ReportUtil.libStatus(ReportUtil.TAG.SETVIDEOVIEW, "streamId|view", this.streamId, RongRTCUtils.getObjectHashCode(videoView));
        this.onUnbindingSink(true);
        this.mVideoView = videoView;
        this.onBindingSink();
    }

    @Override
    public synchronized RCRTCBaseView getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void setTextureView(RCRTCBaseView textureView) {
        this.setVideoView(textureView);
    }

    @Override
    public RCRTCBaseView getTextureView() {
        return this.mVideoView;
    }

    @Override
    public void setStreamEventListener(RCRTCVideoOutputStreamEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public RCRTCVideoOutputStreamEventListener getStreamEventListener() {
        return this.eventListener;
    }

    private boolean validateWatermarkParams(RCRTCRect rect) {
        boolean ret = false;
        if (rect != null) {
            ret = rect.x >= 0.0f && rect.x <= 1.0f && rect.y >= 0.0f && rect.y <= 1.0f && rect.width >= 0.0f && rect.width <= 1.0f;
        }
        return ret;
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        this.onUnbindingSink(false);
        super.setTrack(track);
        if (track != null && track instanceof VideoTrack) {
            this.mVideoSource = ((VideoTrack)track).getVideoSource();
            if (this.validateWatermarkParams(this.mWaterRect)) {
                this.mVideoSource.initWatermarkEnv(this.mWaterPath, this.mWaterRect, this.mWaterWidth, this.mWaterHeight);
            }
            this.mVideoObserver = this.mVideoSource.getCapturerObserver();
        }
        this.onBindingSink();
    }

    private synchronized void onUnbindingSink(boolean release) {
        final RCRTCBaseView videoView = this.mVideoView;
        MediaStreamTrack track = this.track;
        if (track == null || !(track instanceof VideoTrack) || videoView == null) {
            return;
        }
        ReportUtil.libTask(ReportUtil.TAG.UNBINDINGSINK, "streamId|trackId|videoView", this.streamId, this.getTrackId(), RongRTCUtils.getObjectHashCode(videoView));
        this.onRemoveSink(videoView);
        if (release) {
            RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                @Override
                public void run() {
                    if (videoView != null) {
                        videoView.release();
                    }
                }
            });
        }
    }

    private void onRemoveSink(VideoSink sink) {
        MediaStreamTrack track = this.track;
        if (track == null || sink == null) {
            FinLog.e(TAG, "onRemoveSink: VideoTrack or VideoSink is Null");
            return;
        }
        try {
            ((VideoTrack)track).removeSink(sink);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private synchronized void onBindingSink() {
        RCRTCBaseView videoView = this.mVideoView;
        MediaStreamTrack track = this.track;
        if (track == null || !(track instanceof VideoTrack) || videoView == null) {
            return;
        }
        ReportUtil.libTask(ReportUtil.TAG.SETLOCALRENDERVIEW, "trackId|viewIdentity", track.id(), videoView.hashCode());
        RTCEngineImpl.getInstance().postUIThread(new Runnable(){

            @Override
            public void run() {
                MediaStreamTrack track = RCVideoOutStreamImpl.this.track;
                RCRTCBaseView videoView = RCVideoOutStreamImpl.this.mVideoView;
                if (track == null || videoView == null) {
                    ReportUtil.appError(ReportUtil.TAG.SETLOCALRENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), "RCRTCVideoView or MediaStreamTrack is Null");
                    return;
                }
                videoView.init(RTCEngineImpl.getInstance().getEglBaseContext(), RCVideoOutStreamImpl.this);
                try {
                    ((VideoTrack)track).addSink(videoView);
                    ReportUtil.libRes(ReportUtil.TAG.SETLOCALRENDERVIEW, "trackId|viewIdentity", track.id(), videoView.hashCode());
                }
                catch (Exception e) {
                    ReportUtil.libError(ReportUtil.TAG.SETLOCALRENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public RCRTCSurfaceTextureHelper getTextureHelper() {
        if (this.textureHelper == null) {
            this.textureHelper = RCRTCSurfaceTextureHelper.create("TextureHelperThread", RTCEngineImpl.getInstance().getEglBaseContext());
        }
        return this.textureHelper;
    }

    @Override
    public void writeFrame(VideoFrame frame) {
        if (this.mVideoObserver == null) {
            return;
        }
        this.onFrameCaptured(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTexture(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestamp) {
        if (null == this.getUri()) {
            return;
        }
        if (this.mVideoObserver == null) {
            FinLog.e(TAG, "videoObserver is null");
            return;
        }
        RCVideoOutStreamImpl rCVideoOutStreamImpl = this;
        synchronized (rCVideoOutStreamImpl) {
            TextureBufferImpl frameBuffer = null;
            long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
            if (this.frameListener != null) {
                if (this.rgbFilter == null) {
                    this.rgbFilter = new OesToRgbFilter();
                    this.rgbFilter.init();
                }
                this.rgbFilter.onSizeChanged(width, height);
                int rgbId = this.rgbFilter.drawTexture(oesTextureId, transformMatrix);
                RCRTCVideoFrame tempFrame = this.frameListener.processVideoFrame(new RCRTCVideoFrame(width, height, rotation, captureTimeNs, rgbId, RCRTCVideoFrame.Type.RGB));
                frameBuffer = new TextureBufferImpl(tempFrame.getWidth(), tempFrame.getHeight(), VideoFrame.TextureBuffer.Type.RGB, tempFrame.getTextureId(), RendererCommon.convertMatrixToAndroidGraphicsMatrix(tempFrame.getTransformMatrix()), this.textureHelper.getHandler(), this.textureHelper.getYuvConverter(), null);
                rotation = tempFrame.getRotation();
            } else {
                frameBuffer = new TextureBufferImpl(width, height, VideoFrame.TextureBuffer.Type.OES, oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.textureHelper.getHandler(), this.textureHelper.getYuvConverter(), null);
            }
            VideoFrame frame = new VideoFrame(frameBuffer, rotation, captureTimeNs);
            this.onFrameCaptured(frame);
        }
    }

    @Override
    public synchronized void writeYuvData(byte[] data, int width, int height, int rotation) {
        if (this.mVideoObserver == null) {
            FinLog.e(TAG, "videoObserver is null");
            return;
        }
        NV21Buffer frameBuffer = null;
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.frameListener != null) {
            RCRTCVideoFrame tempFrame = this.frameListener.processVideoFrame(new RCRTCVideoFrame(width, height, rotation, captureTimeNs, data));
            frameBuffer = new NV21Buffer(tempFrame.getData(), tempFrame.getWidth(), tempFrame.getHeight(), null);
            rotation = tempFrame.getRotation();
        } else {
            frameBuffer = new NV21Buffer(data, width, height, null);
        }
        VideoFrame frame = new VideoFrame(frameBuffer, rotation, captureTimeNs);
        this.onFrameCaptured(frame);
    }

    @Override
    public void setVideoConfig(RCRTCVideoStreamConfig config) {
        ReportUtil.appStatus(ReportUtil.TAG.SETVIDEOCONFIG, "streamTag|config", this.getTag(), config == null ? "null" : ((RCVideoConfigImpl)config).formatLogString());
        if (config == null) {
            return;
        }
        this.videoStreamConfig = config;
        this.adaptVideoSize();
    }

    private void adaptVideoSize() {
        VideoTrack videoTrack = (VideoTrack)this.track;
        if (videoTrack == null) {
            return;
        }
        videoTrack.getVideoSource().adaptOutputFormat(this.videoStreamConfig.getVideoResolution().getHeight(), this.videoStreamConfig.getVideoResolution().getWidth(), this.videoStreamConfig.getVideoFps().getFps());
    }

    @Override
    public RCRTCVideoStreamConfig getVideoConfig() {
        return this.videoStreamConfig;
    }

    @Override
    public int getWidth() {
        return this.videoStreamConfig.getVideoResolution().getWidth();
    }

    @Override
    public int getHeight() {
        return this.videoStreamConfig.getVideoResolution().getHeight();
    }

    @Override
    public int getMaxBitrate() {
        return (int)(this.getVideoFps().getMultiplier() * (float)this.videoStreamConfig.getMaxRate());
    }

    @Override
    public int getMinBitrate() {
        return (int)(this.getVideoFps().getMultiplier() * (float)this.videoStreamConfig.getMinRate());
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        return this.videoStreamConfig.getVideoFps();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    @Override
    public RCRTCStreamType getStreamType() {
        return this.mStreamType;
    }

    @Override
    public boolean isPreserved() {
        return false;
    }

    @Override
    public synchronized void start() {
        if (this.source != null) {
            this.source.onStart();
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.source != null) {
            this.source.onStop();
        }
    }

    @Override
    public void setVideoFrameListener(IRCRTCVideoOutputFrameListener videoFrameListener) {
        this.frameListener = videoFrameListener;
    }

    @Override
    public boolean setWatermark(Bitmap logoIcon, RCRTCRect rect) {
        boolean ret = this.validateWatermarkParams(rect);
        if (!ret) {
            if (logoIcon != null) {
                RLog.d((String)TAG, (String)"- setWatermark: ret:false, logoIcon != null");
                return false;
            }
            this.mWaterPath = "";
            this.mWaterWidth = 0;
            this.mWaterHeight = 0;
        } else if (logoIcon != null && RTCEngineImpl.getInstance().getContext() != null) {
            String logoPath;
            File cachePath = RTCEngineImpl.getInstance().getContext().getExternalCacheDir();
            if (!cachePath.exists()) {
                cachePath.mkdirs();
            }
            if (ret = BitmapUtil.writeBitmapToFile(logoIcon, Bitmap.CompressFormat.PNG, 100, new File(logoPath = String.format("%s/%s_rc_wm_logo.png", cachePath.getAbsolutePath(), this.getTag())))) {
                this.mWaterPath = logoPath;
                RLog.d((String)TAG, (String)("- setWatermark(): logoIcon.width:" + logoIcon.getWidth() + ", logoIcon.height:" + logoIcon.getHeight()));
            }
            this.mWaterRect = rect;
            this.mWaterWidth = logoIcon.getWidth();
            this.mWaterHeight = logoIcon.getHeight();
        } else {
            this.mWaterPath = "";
            this.mWaterWidth = 0;
            this.mWaterHeight = 0;
        }
        if (this.mVideoSource != null) {
            this.mVideoSource.initWatermarkEnv(this.mWaterPath, rect, this.mWaterWidth, this.mWaterHeight);
        }
        String desc = String.format("waterPath:%s, waterWidth:%d, waterHeight:%d", this.mWaterPath, this.mWaterWidth, this.mWaterHeight);
        Log.d((String)TAG, (String)String.format("- setWatermark: ret:%b, desc:%s", ret, desc));
        ReportUtil.appStatus(ReportUtil.TAG.SETWATERMARK, "status|result|desc", "- setWatermark", ret, desc);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        File file;
        this.onUnbindingSink(false);
        super.release();
        this.mVideoObserver = null;
        if (this.textureHelper != null) {
            this.textureHelper.dispose();
        }
        this.textureHelper = null;
        if (this.mVideoView != null) {
            this.mVideoView.release();
        }
        this.mVideoView = null;
        if (this.source != null) {
            this.source.onDispose();
        }
        RCVideoOutStreamImpl rCVideoOutStreamImpl = this;
        synchronized (rCVideoOutStreamImpl) {
            if (this.rgbFilter != null) {
                this.rgbFilter.destroy();
                this.rgbFilter = null;
            }
        }
        this.source = null;
        if (this.mVideoSource != null) {
            this.mVideoSource.destroyWatermarkEnv();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mWaterPath) && (file = new File(this.mWaterPath)).isFile() && file.exists()) {
            file.delete();
        }
    }

    @Override
    public void onCapturerStarted(boolean success) {
        VideoSourceObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onCapturerStarted(success);
        }
    }

    @Override
    public void onCapturerStopped() {
        VideoSourceObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onCapturerStopped();
        }
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        VideoSourceObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onFrameCaptured(frame);
        }
    }
}

