/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.utils.ReportUtil;

class RTCResultDataCallbackWrapper<T>
extends IRCRTCResultDataCallback<T> {
    IRCRTCResultDataCallback callback;
    ReportUtil.TAG tag;
    String roomId = null;
    String keys = null;
    Object[] values = null;
    private boolean enable = true;

    public RTCResultDataCallbackWrapper(IRCRTCResultDataCallback callback, ReportUtil.TAG tag) {
        this.callback = callback;
        this.tag = tag;
    }

    public RTCResultDataCallbackWrapper(IRCRTCResultDataCallback callback, ReportUtil.TAG tag, String roomId) {
        this.callback = callback;
        this.tag = tag;
        this.roomId = roomId;
    }

    public RTCResultDataCallbackWrapper(IRCRTCResultDataCallback callback, ReportUtil.TAG tag, String keys, Object ... values) {
        this.callback = callback;
        this.tag = tag;
        this.keys = keys;
        this.values = values;
    }

    public RTCResultDataCallbackWrapper(IRCRTCResultDataCallback callback, boolean enable) {
        this.callback = callback;
        this.enable = enable;
    }

    @Override
    public void onSuccess(T data) {
        if (this.enable) {
            this.onExSuccess(data);
        }
        if (this.callback != null) {
            this.callback.onSuccess(data);
        }
    }

    protected void onExSuccess(T data) {
        if (!TextUtils.isEmpty((CharSequence)this.keys)) {
            ReportUtil.appRes(this.tag, this.keys, this.values);
        } else if (null != this.roomId) {
            ReportUtil.appRes(this.tag, this.roomId);
        } else {
            ReportUtil.appRes(this.tag, "code", 0);
        }
    }

    @Override
    public void onFailed(RTCErrorCode errorCode) {
        if (this.enable) {
            this.onExFailed(errorCode);
        }
        if (this.callback != null) {
            this.callback.onFailed(errorCode);
        }
    }

    protected void onExFailed(RTCErrorCode errorCode) {
        if (!TextUtils.isEmpty((CharSequence)this.keys)) {
            ReportUtil.appError(this.tag, errorCode, this.keys, this.values);
        } else if (null != this.roomId) {
            ReportUtil.appError(this.tag, errorCode, "roomId", this.roomId);
        } else {
            ReportUtil.appError(this.tag, errorCode);
        }
    }
}

