/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2.preprocessor;

import android.graphics.Bitmap;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videoproducer.preprocessor.BeautyProcessor;
import com.tencent.liteav.videoproducer2.preprocessor.VideoPreprocessor2;
import com.tencent.liteav.videoproducer2.preprocessor.VideoPreprocessor2Proxy;

@JNINamespace(value="liteav::video")
public class VideoEffectManager {
    private final VideoPreprocessor2 mPreprocessor;
    private final BeautyProcessor mBeautyProcessor;
    private float mLookupMixLevel = 0.5f;

    @CalledByNative
    public VideoEffectManager(VideoPreprocessor2Proxy preprocessor) {
        this.mPreprocessor = preprocessor.getPreprocessor();
        this.mBeautyProcessor = this.mPreprocessor.b.d;
    }

    @CalledByNative
    public void setBeautyStyle(int beautyStyle) {
        this.mBeautyProcessor.setBeautyStyle(beautyStyle);
    }

    @CalledByNative
    public void setBeautyLevel(float beautyLevel) {
        this.mBeautyProcessor.setBeautyLevel(beautyLevel);
    }

    @CalledByNative
    public void setWhitenessLevel(float whitenessLevel) {
        this.mBeautyProcessor.setWhitenessLevel(whitenessLevel);
    }

    @CalledByNative
    public void setRuddyLevel(float ruddyLevel) {
        this.mBeautyProcessor.setRuddyLevel(ruddyLevel);
    }

    @CalledByNative
    public void setSharpenLevel(float sharpnessLevel) {
        this.mBeautyProcessor.setSharpenLevel(sharpnessLevel);
    }

    @CalledByNative
    public void setFilterStrength(float mixLevel) {
        VideoPreprocessor2 videoPreprocessor2 = this.mPreprocessor;
        LiteavLog.i(videoPreprocessor2.a, "setFilterMixLevel: ".concat(String.valueOf(mixLevel)));
        videoPreprocessor2.e = mixLevel;
        videoPreprocessor2.b.a(mixLevel);
    }

    @CalledByNative
    public void setFilter(Bitmap bitmap) {
        float f2 = this.mLookupMixLevel;
        Bitmap bitmap2 = bitmap;
        this.mPreprocessor.b.a(1.0f, bitmap2, f2, null, 0.0f);
    }

    @CalledByNative
    public void setWatermark(Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        Bitmap bitmap = watermark;
        this.mPreprocessor.b.a(bitmap, xOffsetRatio, yOffsetRatio, widthRatio);
    }

    @CalledByNative
    public void setGreenScreenFile(String path) {
        String string = path;
        VideoPreprocessor2 videoPreprocessor2 = this.mPreprocessor;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            LiteavLog.i(videoPreprocessor2.a, "setGreenScreenFile: path=" + string + ", isLoop=false");
            videoPreprocessor2.b.a(string, false);
        }
    }
}

