/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.api;

import android.util.SparseArray;
import com.tencent.thumbplayer.adapter.a.c;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TPPlayerState {
    public static final int INDEX = 0;
    public static final int IDLE = 1;
    public static final int INITIALIZED = 2;
    public static final int PREPARING = 3;
    public static final int PREPARED = 4;
    public static final int START = 5;
    public static final int PAUSE = 6;
    public static final int COMPLETE = 7;
    public static final int STOPPING = 8;
    public static final int STOPPED = 9;
    public static final int ERROR = 10;
    public static final int RELEASED = 11;
    private static final SparseArray<String> NS_STATES = new SparseArray();
    private c.k mStateChangeListener;
    private int mCurState = 1;
    private int mPreState = 1;
    private int mLastState = 1;
    private int mInnerPlayState = 1;

    public synchronized void changeState(int n2) {
        if (this.mCurState != n2) {
            this.mPreState = this.mCurState;
            this.mCurState = n2;
            if (this.mStateChangeListener != null) {
                this.mStateChangeListener.b(this.mPreState, this.mCurState);
            }
        }
    }

    public synchronized void setLastState(int n2) {
        if (this.mLastState != n2) {
            this.mLastState = n2;
        }
    }

    public synchronized void setInnerPlayStateState(int n2) {
        if (this.mInnerPlayState != n2) {
            this.mInnerPlayState = n2;
        }
    }

    public synchronized int state() {
        return this.mCurState;
    }

    public synchronized int lastState() {
        return this.mLastState;
    }

    public synchronized int preState() {
        return this.mPreState;
    }

    public synchronized int innerPlayState() {
        return this.mInnerPlayState;
    }

    public synchronized boolean is(int n2) {
        return this.mCurState == n2;
    }

    public void setOnPlayerStateChangeListener(c.k k2) {
        this.mStateChangeListener = k2;
    }

    public synchronized String toString() {
        String string = (String)NS_STATES.get(this.mCurState);
        String string2 = (String)NS_STATES.get(this.mPreState);
        String string3 = (String)NS_STATES.get(this.mLastState);
        String string4 = (String)NS_STATES.get(this.mInnerPlayState);
        return "state[ cur : " + string + " , pre : " + string2 + " , last : " + string3 + " , inner play : " + string4 + " ]";
    }

    static {
        NS_STATES.put(1, (Object)"IDLE");
        NS_STATES.put(2, (Object)"INITIALIZED");
        NS_STATES.put(3, (Object)"PREPARING");
        NS_STATES.put(4, (Object)"PREPARED");
        NS_STATES.put(5, (Object)"START");
        NS_STATES.put(6, (Object)"PAUSE");
        NS_STATES.put(7, (Object)"COMPLETE");
        NS_STATES.put(8, (Object)"STOPPING");
        NS_STATES.put(9, (Object)"STOPPED");
        NS_STATES.put(10, (Object)"ERROR");
        NS_STATES.put(11, (Object)"RELEASED");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface STATE {
    }
}

