/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.os.Looper;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.ugc.Clip;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCPixelFrameProvider;
import com.tencent.ugc.UGCSingleFilePixelFrameProvider;
import com.tencent.ugc.ej;
import com.tencent.ugc.ek;
import com.tencent.ugc.el;
import com.tencent.ugc.em;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UGCMultiFilePixelFrameProvider
implements UGCFrameQueue.UGCFrameQueueListener,
UGCPixelFrameProvider {
    private static final String TAG = "UGCMultiFileVideoFrameProvider";
    private final UGCPixelFrameProvider[] mProviderList;
    private final PixelFrame[] mPixelFrameStash;
    private final UGCFrameQueue<List<PixelFrame>> mPixelFrameListQueue = new UGCFrameQueue();
    private final List<Clip> mClipList;
    private final CustomHandler mSingleFileProviderHandler;
    private final CustomHandler mWorkHandler;
    private int mClipIndexOfMaxFps;
    private long mCurrentTimestamp = 0L;
    private long mFrameDuration = 0L;

    public UGCMultiFilePixelFrameProvider(List<Clip> clipList, CustomHandler handler) {
        this.mProviderList = new UGCPixelFrameProvider[clipList.size()];
        this.mPixelFrameStash = new PixelFrame[clipList.size()];
        this.mClipList = clipList;
        this.mSingleFileProviderHandler = handler;
        this.mWorkHandler = new CustomHandler(Looper.myLooper());
        this.mPixelFrameListQueue.setUGCFrameQueueListener(this);
    }

    @Override
    public void initialize() {
        LiteavLog.i(TAG, "initialize");
    }

    @Override
    public void uninitialize() {
        this.stop();
    }

    @Override
    public void start() {
        this.mWorkHandler.runOrPost(ej.a(this));
    }

    @Override
    public void stop() {
        this.mWorkHandler.runOrPost(ek.a(this));
    }

    @Override
    public void seekTo(long timeMs, boolean isPreciseSeek) {
        this.mWorkHandler.runOrPost(el.a(this, timeMs, isPreciseSeek));
    }

    @Override
    public UGCFrameQueue<List<PixelFrame>> getFrameQueue() {
        return this.mPixelFrameListQueue;
    }

    private void readFrameToQueue() {
        if (this.mPixelFrameListQueue.size() > 1) {
            return;
        }
        this.getCurrentTimestampWithFpsInfo();
        this.readFrameToCache();
        LinkedList<PixelFrame> linkedList = new LinkedList<PixelFrame>();
        PixelFrame[] pixelFrameArray = this.mPixelFrameStash;
        int n2 = this.mPixelFrameStash.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PixelFrame pixelFrame = pixelFrameArray[i2];
            this.putOneFrameToList(pixelFrame, linkedList);
        }
        if (linkedList.isEmpty() || this.isAllProviderEndOfStream()) {
            this.mPixelFrameListQueue.queue(UGCPixelFrameProvider.END_OF_STREAM);
            return;
        }
        this.mPixelFrameListQueue.queue(linkedList);
    }

    private void putOneFrameToList(PixelFrame pixelFrame, List<PixelFrame> frameList) {
        if (pixelFrame == null) {
            return;
        }
        if (pixelFrame.getTimestamp() == this.mCurrentTimestamp) {
            frameList.add(pixelFrame);
            pixelFrame.retain();
            return;
        }
        PixelFrame pixelFrame2 = this.copyPixelFrame(pixelFrame);
        if (pixelFrame2 != null) {
            pixelFrame2.setTimestamp(this.mCurrentTimestamp);
        } else {
            pixelFrame2 = pixelFrame;
            pixelFrame.retain();
        }
        frameList.add(pixelFrame2);
    }

    private PixelFrame copyPixelFrame(PixelFrame pixelFrame) {
        PixelFrame pixelFrame2 = null;
        if (pixelFrame instanceof e.b) {
            e.b b2 = (e.b)pixelFrame;
            pixelFrame2 = b2.a.a(b2.getGLContext());
        }
        return pixelFrame2;
    }

    private void getCurrentTimestampWithFpsInfo() {
        float f2 = -1.0f;
        for (int i2 = 0; i2 < this.mClipList.size(); ++i2) {
            if (!(f2 < this.mClipList.get((int)i2).fps) || this.mProviderList[i2] == null) continue;
            f2 = this.mClipList.get((int)i2).fps;
            this.mClipIndexOfMaxFps = i2;
        }
        this.mFrameDuration = (long)(f2 > 0.0f ? 1000.0f / f2 : 40.0f);
        this.mCurrentTimestamp += this.mFrameDuration;
    }

    private boolean isAllProviderEndOfStream() {
        for (int i2 = 0; i2 < this.mProviderList.length; ++i2) {
            if (this.mProviderList[i2] == null) continue;
            return false;
        }
        return true;
    }

    private PixelFrame getFrameFromProvider(int index) {
        UGCPixelFrameProvider uGCPixelFrameProvider = this.mProviderList[index];
        if (uGCPixelFrameProvider == null) {
            return null;
        }
        List<PixelFrame> list = uGCPixelFrameProvider.getFrameQueue().dequeue();
        if (list == UGCPixelFrameProvider.END_OF_STREAM) {
            uGCPixelFrameProvider.stop();
            uGCPixelFrameProvider.uninitialize();
            this.mProviderList[index] = null;
            return null;
        }
        return list.get(0);
    }

    private void readFrameToCache() {
        for (int i2 = 0; i2 < this.mProviderList.length; ++i2) {
            PixelFrame pixelFrame = this.mPixelFrameStash[i2];
            if (pixelFrame != null && this.mCurrentTimestamp - pixelFrame.getTimestamp() <= this.mFrameDuration / 2L) continue;
            PixelFrame pixelFrame2 = this.getFrameFromProvider(i2);
            if (pixelFrame2 != null) {
                this.mPixelFrameStash[i2] = pixelFrame2;
                if (pixelFrame != null) {
                    pixelFrame.release();
                }
            }
            if (this.mClipIndexOfMaxFps != i2) continue;
            this.mCurrentTimestamp = this.mPixelFrameStash[i2].getTimestamp();
        }
    }

    @Override
    public void setReverse(boolean isReverse) {
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
    }

    private void clearFrameQueue() {
        Iterator<List<PixelFrame>> iterator = this.mPixelFrameListQueue.dequeueAll().iterator();
        while (iterator.hasNext()) {
            PixelFrame.releasePixelFrames(iterator.next());
        }
    }

    private void clearFrameCache() {
        for (int i2 = 0; i2 < this.mPixelFrameStash.length; ++i2) {
            if (this.mPixelFrameStash[i2] == null) continue;
            this.mPixelFrameStash[i2].release();
            this.mPixelFrameStash[i2] = null;
        }
    }

    @Override
    public void onFrameDequeued() {
        this.mWorkHandler.runOrPost(em.a(this));
    }

    static /* synthetic */ void lambda$seekTo$2(UGCMultiFilePixelFrameProvider this_, long timeMs, boolean isPreciseSeek) {
        UGCPixelFrameProvider[] uGCPixelFrameProviderArray = this_.mProviderList;
        int n2 = this_.mProviderList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UGCPixelFrameProvider uGCPixelFrameProvider = uGCPixelFrameProviderArray[i2];
            if (uGCPixelFrameProvider == null) continue;
            uGCPixelFrameProvider.seekTo(timeMs, isPreciseSeek);
        }
        this_.mCurrentTimestamp = timeMs;
        this_.clearFrameCache();
        this_.clearFrameQueue();
        this_.readFrameToQueue();
    }

    static /* synthetic */ void lambda$stop$1(UGCMultiFilePixelFrameProvider this_) {
        for (int i2 = 0; i2 < this_.mProviderList.length; ++i2) {
            if (this_.mProviderList[i2] != null) {
                this_.mProviderList[i2].stop();
                this_.mProviderList[i2].uninitialize();
            }
            this_.mProviderList[i2] = null;
        }
        this_.clearFrameCache();
        this_.clearFrameQueue();
    }

    static /* synthetic */ void lambda$start$0(UGCMultiFilePixelFrameProvider this_) {
        for (int i2 = 0; i2 < this_.mClipList.size(); ++i2) {
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = new UGCSingleFilePixelFrameProvider(this_.mClipList.get(i2), this_.mSingleFileProviderHandler);
            uGCSingleFilePixelFrameProvider.initialize();
            uGCSingleFilePixelFrameProvider.start();
            this_.mProviderList[i2] = uGCSingleFilePixelFrameProvider;
        }
        this_.readFrameToQueue();
    }

    static /* synthetic */ void access$lambda$0(UGCMultiFilePixelFrameProvider uGCMultiFilePixelFrameProvider) {
        uGCMultiFilePixelFrameProvider.readFrameToQueue();
    }
}

