/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.media.MediaFormat;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.utils.c;
import com.tencent.ugc.AudioEncodeParams;
import java.util.ArrayList;
import java.util.List;

public class UGCTranscodeAudioEncodeParamsDecider {
    private static final String TAG = "UGCTranscodeAudioEncodeParamsDecider";
    private static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int DEFAULT_CHANNEL_COUNT = 1;
    private static final int DEFAULT_BITRATE = 98304;
    private static final int DEFAULT_BIT_PER_CHANNEL = 16;
    private List<MediaFormat> mAudioMediaFormatList;
    private MediaFormat mBGMMediaFormat;
    private int mEncodeBitrate = 0;

    public void setEncodeBitrate(int bitrate) {
        if (this.mEncodeBitrate == bitrate) {
            return;
        }
        LiteavLog.i(TAG, "setAudioBitrate ".concat(String.valueOf(bitrate)));
        this.mEncodeBitrate = bitrate;
    }

    public void setInputAudioMediaFormat(List<MediaFormat> audioMediaFormatList) {
        this.mAudioMediaFormatList = audioMediaFormatList;
    }

    public void setBGMMediaFormat(MediaFormat bgmMediaFormat) {
        this.mBGMMediaFormat = bgmMediaFormat;
    }

    public AudioEncodeParams getDecidedEncodeParams() {
        AudioEncodeParams audioEncodeParams = new AudioEncodeParams();
        audioEncodeParams.setSampleRate(this.getDecidedSampleRate());
        audioEncodeParams.setChannels(this.getDecidedChannels());
        audioEncodeParams.setBitsPerChannel(16);
        audioEncodeParams.setBitrate(this.getDecidedBitRate());
        return audioEncodeParams;
    }

    private int getDecidedSampleRate() {
        if (this.mBGMMediaFormat == null) {
            MediaFormat mediaFormat = null;
            if (!c.a(this.mAudioMediaFormatList)) {
                mediaFormat = this.getFirstValidMediaFormat();
            }
            return this.getIntValueFromFormat(mediaFormat, "sample-rate", 48000);
        }
        UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = this;
        return uGCTranscodeAudioEncodeParamsDecider.getIntValueFromFormat(uGCTranscodeAudioEncodeParamsDecider.mBGMMediaFormat, "sample-rate", 48000);
    }

    private MediaFormat getFirstValidMediaFormat() {
        for (MediaFormat mediaFormat : this.mAudioMediaFormatList) {
            if (mediaFormat == null) continue;
            return mediaFormat;
        }
        return null;
    }

    private int getDecidedChannels() {
        MediaFormat mediaFormat = null;
        if (!c.a(this.mAudioMediaFormatList)) {
            mediaFormat = this.getFirstValidMediaFormat();
        }
        if (this.mBGMMediaFormat == null) {
            int n2 = this.getIntValueFromFormat(mediaFormat, "channel-count", 1);
            if (n2 > 2) {
                return 2;
            }
            return n2;
        }
        if (mediaFormat == null) {
            UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = this;
            int n3 = uGCTranscodeAudioEncodeParamsDecider.getIntValueFromFormat(uGCTranscodeAudioEncodeParamsDecider.mBGMMediaFormat, "channel-count", 1);
            if (n3 > 2) {
                return 2;
            }
            return n3;
        }
        int n4 = this.getIntValueFromFormat(mediaFormat, "channel-count", 1);
        UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = this;
        int n5 = uGCTranscodeAudioEncodeParamsDecider.getIntValueFromFormat(uGCTranscodeAudioEncodeParamsDecider.mBGMMediaFormat, "channel-count", 1);
        int n6 = Math.max(n4, n5);
        if (n6 > 2) {
            return 2;
        }
        return n6;
    }

    private int getDecidedBitRate() {
        if (this.mEncodeBitrate != 0) {
            return this.mEncodeBitrate;
        }
        if (this.mBGMMediaFormat == null) {
            UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = this;
            int n2 = uGCTranscodeAudioEncodeParamsDecider.getMaxAudioBitRate(uGCTranscodeAudioEncodeParamsDecider.mAudioMediaFormatList);
            if (n2 != -1) {
                return n2;
            }
            return 98304;
        }
        if (c.a(this.mAudioMediaFormatList)) {
            UGCTranscodeAudioEncodeParamsDecider uGCTranscodeAudioEncodeParamsDecider = this;
            return uGCTranscodeAudioEncodeParamsDecider.getIntValueFromFormat(uGCTranscodeAudioEncodeParamsDecider.mBGMMediaFormat, "bitrate", 98304);
        }
        ArrayList<MediaFormat> arrayList = new ArrayList<MediaFormat>(this.mAudioMediaFormatList);
        arrayList.add(this.mBGMMediaFormat);
        int n3 = this.getMaxAudioBitRate(arrayList);
        if (n3 != -1) {
            return n3;
        }
        return 98304;
    }

    private int getIntValueFromFormat(MediaFormat format, String key, int defaultValue) {
        int n2 = defaultValue;
        if (format == null) {
            return defaultValue;
        }
        try {
            n2 = format.getInteger(key);
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, String.valueOf(exception));
        }
        return n2;
    }

    private int getMaxAudioBitRate(List<MediaFormat> mediaFormatList) {
        if (mediaFormatList == null) {
            return -1;
        }
        int n2 = -1;
        for (MediaFormat mediaFormat : mediaFormatList) {
            if (!mediaFormat.containsKey("bitrate")) continue;
            n2 = Math.max(n2, mediaFormat.getInteger("bitrate"));
        }
        return n2;
    }
}

