/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.tracing;

import android.os.Looper;
import android.util.SparseArray;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.ITracingAdapter;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WXTracing {
    private static final AtomicInteger sIdGenerator = new AtomicInteger(0);

    public static int nextId() {
        return sIdGenerator.getAndIncrement();
    }

    public static boolean isAvailable() {
        return WXEnvironment.isApkDebugable();
    }

    public static synchronized void submit(TraceEvent event) {
        ITracingAdapter tracingAdapter = WXSDKManager.getInstance().getTracingAdapter();
        if (tracingAdapter != null) {
            tracingAdapter.submitTracingEvent(event);
        }
    }

    public static String currentThreadName() {
        Thread thread = Thread.currentThread();
        String name = thread.getName();
        if ("WeexJSBridgeThread".equals(name)) {
            return "JSThread";
        }
        if ("WeeXDomThread".equals(name)) {
            return "DOMThread";
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            return "UIThread";
        }
        return name;
    }

    public static TraceEvent newEvent(String fname, String instanceId, int parentId) {
        TraceEvent traceEvent = new TraceEvent();
        traceEvent.fname = fname;
        traceEvent.iid = instanceId;
        traceEvent.traceId = WXTracing.nextId();
        traceEvent.parentId = parentId;
        return traceEvent;
    }

    public static class TraceInfo {
        public int rootEventId;
        public long domQueueTime;
        public long uiQueueTime;
        public long domThreadStart = -1L;
        public long domThreadNanos;
        public long uiThreadStart = -1L;
        public long uiThreadNanos;
    }

    public static class TraceEvent {
        public String fname;
        public String tname;
        public String ph;
        public int traceId;
        public long ts = System.currentTimeMillis();
        public String iid;
        public String ref;
        public String parentRef;
        public String name;
        public String classname;
        public int parentId = -1;
        public double duration;
        public SparseArray<TraceEvent> subEvents;
        public String payload;
        public double parseJsonTime;
        public boolean isSegment;
        public Map<String, Object> extParams;
        public boolean firstScreenFinish;
        private boolean submitted;

        public TraceEvent() {
            this.traceId = WXTracing.nextId();
            this.tname = WXTracing.currentThreadName();
        }

        public void submit() {
            if (!this.submitted) {
                this.submitted = true;
                WXTracing.submit(this);
            } else {
                WXLogUtils.w("WXTracing", "Event " + this.traceId + " has been submitted.");
            }
        }
    }
}

