/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.symbol;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.jinmingyunle.midiplaylib.musictools.NoteDuration;
import com.jinmingyunle.midiplaylib.view.WhiteNote;

public class Stem {
    public static final int Up = 1;
    public static final int Down = 2;
    public static final int LeftSide = 1;
    public static final int RightSide = 2;
    private NoteDuration duration;
    private int direction;
    private WhiteNote top;
    private WhiteNote bottom;
    private WhiteNote end;
    private boolean notesoverlap;
    private int side;
    private Stem pair;
    private int width_to_pair;
    private boolean receiver_in_pair;

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int value) {
        this.ChangeDirection(value);
    }

    public NoteDuration getDuration() {
        return this.duration;
    }

    public WhiteNote getTop() {
        return this.top;
    }

    public WhiteNote getBottom() {
        return this.bottom;
    }

    public WhiteNote getEnd() {
        return this.end;
    }

    public void setEnd(WhiteNote value) {
        this.end = value;
    }

    public boolean getReceiver() {
        return this.receiver_in_pair;
    }

    public void setReceiver(boolean value) {
        this.receiver_in_pair = value;
    }

    public Stem(WhiteNote bottom, WhiteNote top, NoteDuration duration, int direction, boolean overlap) {
        this.top = top;
        this.bottom = bottom;
        this.duration = duration;
        this.direction = direction;
        this.notesoverlap = overlap;
        this.side = direction == 1 || this.notesoverlap ? 2 : 1;
        this.end = this.CalculateEnd();
        this.pair = null;
        this.width_to_pair = 0;
        this.receiver_in_pair = false;
    }

    public WhiteNote CalculateEnd() {
        if (this.direction == 1) {
            WhiteNote w = this.top;
            w = w.Add(6);
            if (this.duration == NoteDuration.Sixteenth) {
                w = w.Add(2);
            } else if (this.duration == NoteDuration.ThirtySecond) {
                w = w.Add(4);
            }
            return w;
        }
        if (this.direction == 2) {
            WhiteNote w = this.bottom;
            w = w.Add(-6);
            if (this.duration == NoteDuration.Sixteenth) {
                w = w.Add(-2);
            } else if (this.duration == NoteDuration.ThirtySecond) {
                w = w.Add(-4);
            }
            return w;
        }
        return null;
    }

    public void ChangeDirection(int newdirection) {
        this.direction = newdirection;
        this.side = this.direction == 1 || this.notesoverlap ? 2 : 1;
        this.end = this.CalculateEnd();
    }

    public void SetPair(Stem pair, int width_to_pair) {
        this.pair = pair;
        this.width_to_pair = width_to_pair;
    }

    public boolean IsBeam() {
        return this.receiver_in_pair || this.pair != null;
    }

    public void Draw(Canvas canvas, Paint paint, int ytop, WhiteNote topstaff) {
        if (this.duration == NoteDuration.Whole) {
            return;
        }
        this.DrawVerticalLine(canvas, paint, ytop, topstaff);
        if (this.duration == NoteDuration.Quarter || this.duration == NoteDuration.DottedQuarter || this.duration == NoteDuration.Half || this.duration == NoteDuration.DottedHalf || this.receiver_in_pair) {
            return;
        }
        if (this.pair != null) {
            this.DrawHorizBarStem(canvas, paint, ytop, topstaff);
        } else {
            this.DrawCurvyStem(canvas, paint, ytop, topstaff);
        }
    }

    private void DrawVerticalLine(Canvas canvas, Paint paint, int ytop, WhiteNote topstaff) {
        int xstart = this.side == 1 ? 2 : 11;
        if (this.direction == 1) {
            int y1 = ytop + topstaff.Dist(this.bottom) * 9 / 2 + 2;
            int ystem = ytop + topstaff.Dist(this.end) * 9 / 2;
            canvas.drawLine((float)xstart, (float)y1, (float)xstart, (float)ystem, paint);
        } else if (this.direction == 2) {
            int y1 = ytop + topstaff.Dist(this.top) * 9 / 2 + 9;
            y1 = this.side == 1 ? (y1 -= 2) : (y1 -= 4);
            int ystem = ytop + topstaff.Dist(this.end) * 9 / 2 + 9;
            canvas.drawLine((float)xstart, (float)y1, (float)xstart, (float)ystem, paint);
        }
    }

    private void DrawCurvyStem(Canvas canvas, Paint paint, int ytop, WhiteNote topstaff) {
        paint.setStrokeWidth(2.0f);
        int xstart = 0;
        xstart = this.side == 1 ? 2 : 11;
        if (this.direction == 1) {
            Path bezierPath;
            int ystem = ytop + topstaff.Dist(this.end) * 9 / 2;
            if (this.duration == NoteDuration.Eighth || this.duration == NoteDuration.DottedEighth || this.duration == NoteDuration.Triplet || this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                bezierPath = new Path();
                bezierPath.moveTo((float)xstart, (float)ystem);
                bezierPath.cubicTo((float)xstart, (float)(ystem + 10), (float)(xstart + 14), (float)(ystem + 18), (float)(xstart + 3), (float)(ystem + 27));
                canvas.drawPath(bezierPath, paint);
            }
            ystem += 9;
            if (this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                bezierPath = new Path();
                bezierPath.moveTo((float)xstart, (float)ystem);
                bezierPath.cubicTo((float)xstart, (float)(ystem + 10), (float)(xstart + 14), (float)(ystem + 18), (float)(xstart + 3), (float)(ystem + 27));
                canvas.drawPath(bezierPath, paint);
            }
            ystem += 9;
            if (this.duration == NoteDuration.ThirtySecond) {
                bezierPath = new Path();
                bezierPath.moveTo((float)xstart, (float)ystem);
                bezierPath.cubicTo((float)xstart, (float)(ystem + 10), (float)(xstart + 14), (float)(ystem + 18), (float)(xstart + 3), (float)(ystem + 27));
                canvas.drawPath(bezierPath, paint);
            }
        } else if (this.direction == 2) {
            Path bezierPath;
            int ystem = ytop + topstaff.Dist(this.end) * 9 / 2 + 9;
            if (this.duration == NoteDuration.Eighth || this.duration == NoteDuration.DottedEighth || this.duration == NoteDuration.Triplet || this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                bezierPath = new Path();
                bezierPath.moveTo((float)xstart, (float)ystem);
                bezierPath.cubicTo((float)xstart, (float)(ystem - 7), (float)(xstart + 14), (float)(ystem - 18), (float)(xstart + 7), (float)(ystem - 18 - 3));
                canvas.drawPath(bezierPath, paint);
            }
            ystem -= 9;
            if (this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                bezierPath = new Path();
                bezierPath.moveTo((float)xstart, (float)ystem);
                bezierPath.cubicTo((float)xstart, (float)(ystem - 7), (float)(xstart + 14), (float)(ystem - 18), (float)(xstart + 7), (float)(ystem - 18 - 3));
                canvas.drawPath(bezierPath, paint);
            }
            ystem -= 9;
            if (this.duration == NoteDuration.ThirtySecond) {
                bezierPath = new Path();
                bezierPath.moveTo((float)xstart, (float)ystem);
                bezierPath.cubicTo((float)xstart, (float)(ystem - 7), (float)(xstart + 14), (float)(ystem - 18), (float)(xstart + 7), (float)(ystem - 18 - 3));
                canvas.drawPath(bezierPath, paint);
            }
        }
        paint.setStrokeWidth(1.0f);
    }

    private void DrawHorizBarStem(Canvas canvas, Paint paint, int ytop, WhiteNote topstaff) {
        paint.setStrokeWidth(4.0f);
        paint.setStrokeCap(Paint.Cap.BUTT);
        int xstart = 0;
        int xstart2 = 0;
        if (this.side == 1) {
            xstart = 2;
        } else if (this.side == 2) {
            xstart = 11;
        }
        if (this.pair.side == 1) {
            xstart2 = 2;
        } else if (this.pair.side == 2) {
            xstart2 = 11;
        }
        if (this.direction == 1) {
            int xend = this.width_to_pair + xstart2;
            int ystart = ytop + topstaff.Dist(this.end) * 9 / 2;
            int yend = ytop + topstaff.Dist(this.pair.end) * 9 / 2;
            if (this.duration == NoteDuration.Eighth || this.duration == NoteDuration.DottedEighth || this.duration == NoteDuration.Triplet || this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
            }
            ystart += 9;
            yend += 9;
            if (this.duration == NoteDuration.DottedEighth) {
                int x = xend - 9;
                double slope = (double)(yend - ystart) * 1.0 / (double)(xend - xstart);
                int y = (int)(slope * (double)(x - xend) + (double)yend);
                canvas.drawLine((float)x, (float)y, (float)xend, (float)yend, paint);
            }
            if (this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
            }
            ystart += 9;
            yend += 9;
            if (this.duration == NoteDuration.ThirtySecond) {
                canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
            }
        } else {
            int xend = this.width_to_pair + xstart2;
            int ystart = ytop + topstaff.Dist(this.end) * 9 / 2 + 9;
            int yend = ytop + topstaff.Dist(this.pair.end) * 9 / 2 + 9;
            if (this.duration == NoteDuration.Eighth || this.duration == NoteDuration.DottedEighth || this.duration == NoteDuration.Triplet || this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
            }
            ystart -= 9;
            yend -= 9;
            if (this.duration == NoteDuration.DottedEighth) {
                int x = xend - 9;
                double slope = (double)(yend - ystart) * 1.0 / (double)(xend - xstart);
                int y = (int)(slope * (double)(x - xend) + (double)yend);
                canvas.drawLine((float)x, (float)y, (float)xend, (float)yend, paint);
            }
            if (this.duration == NoteDuration.Sixteenth || this.duration == NoteDuration.ThirtySecond) {
                canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
            }
            ystart -= 9;
            yend -= 9;
            if (this.duration == NoteDuration.ThirtySecond) {
                canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
            }
        }
        paint.setStrokeWidth(1.0f);
    }

    public String toString() {
        return String.format("Stem duration=%1$s direction=%2$s top=%3$s bottom=%4$s end=%5$s overlap=%6$s side=%7$s width_to_pair=%8$s receiver_in_pair=%9$s", new Object[]{this.duration, this.direction, this.top.toString(), this.bottom.toString(), this.end.toString(), this.notesoverlap, this.side, this.width_to_pair, this.receiver_in_pair});
    }
}

