/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import com.tencent.liteav.beauty.b.n;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.ugc.gs;
import com.tencent.ugc.gt;
import java.nio.Buffer;

public class UGCWatermarkAlphaTextureFilter
extends n {
    private static final String WATERMARK_ALPHA_FRAG = "varying lowp vec2 textureCoordinate;\n   \n  uniform sampler2D inputImageTexture;\n  uniform mediump float alphaBlend;\n  \n  void main()\n  {\n      mediump vec4 color = texture2D(inputImageTexture, textureCoordinate);\n       if (0.0 == color.a){\n            gl_FragColor = color;\n       }else{\n            gl_FragColor = vec4(color.rgb, alphaBlend);\n       } \n  }\n";
    private int mAlphaUniform = -1;
    private boolean mIsShowBackImageMoment = false;

    public UGCWatermarkAlphaTextureFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", WATERMARK_ALPHA_FRAG);
    }

    @Override
    public void onInit(e texturePool) {
        this.mAlphaUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"alphaBlend");
        this.mSrcBlendMode = 770;
        this.setAlpha(1.0f);
    }

    public void setAlpha(float alpha) {
        UGCWatermarkAlphaTextureFilter uGCWatermarkAlphaTextureFilter = this;
        uGCWatermarkAlphaTextureFilter.setFloatOnDraw(uGCWatermarkAlphaTextureFilter.mAlphaUniform, alpha);
    }

    public void setShowBackImageMoment(boolean isShowBackImageMoment) {
        UGCWatermarkAlphaTextureFilter uGCWatermarkAlphaTextureFilter = this;
        uGCWatermarkAlphaTextureFilter.runOnDraw(gs.a(uGCWatermarkAlphaTextureFilter, isShowBackImageMoment));
    }

    @Override
    public void onUninit() {
        this.mRenderObjects = null;
    }

    public void setTextureWatermark(int textureId, int textureWidth, int textureHeight, float x2, float y2, float width) {
        UGCWatermarkAlphaTextureFilter uGCWatermarkAlphaTextureFilter = this;
        uGCWatermarkAlphaTextureFilter.runOnDraw(gt.a(uGCWatermarkAlphaTextureFilter, textureId, textureWidth, textureHeight, x2, y2, width));
    }

    @Override
    public void afterDrawArrays() {
        if (!this.mDrawWaterMarkEnabled) {
            return;
        }
        GLES20.glEnable((int)3042);
        if (this.mIsShowBackImageMoment) {
            GLES20.glBlendFunc((int)773, (int)772);
        } else {
            GLES20.glBlendFunc((int)770, (int)771);
        }
        GLES20.glActiveTexture((int)33984);
        for (int i2 = 0; i2 < this.mRenderObjects.length; ++i2) {
            if (this.mRenderObjects[i2] == null) continue;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mRenderObjects[i2].c);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
            GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mRenderObjects[i2].a);
            GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
            GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoord, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)TEXTURE_COORDS_BUFFER);
            GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoord);
            GLES20.glDrawElements((int)4, (int)DRAW_ORDER.length, (int)5123, (Buffer)DRAW_ORDER_BUFFER);
            GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
            GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoord);
        }
        GLES20.glDisable((int)3042);
    }

    static /* synthetic */ void lambda$setTextureWatermark$1(UGCWatermarkAlphaTextureFilter this_, int textureId, int textureWidth, int textureHeight, float x2, float y2, float width) {
        if (this_.mRenderObjects == null) {
            this_.mRenderObjects = new n.a[1];
        }
        if (null == this_.mRenderObjects[0]) {
            this_.mRenderObjects[0] = new n.a();
        }
        if (textureId == -1) {
            this_.mRenderObjects[0].a();
            this_.mRenderObjects[0] = null;
            return;
        }
        this_.mRenderObjects[0].c = textureId;
        this_.calculateOffsetMatrix(textureWidth, textureHeight, x2, y2, width, 0);
    }

    static /* synthetic */ void lambda$setShowBackImageMoment$0(UGCWatermarkAlphaTextureFilter this_, boolean isShowBackImageMoment) {
        this_.mIsShowBackImageMoment = isShowBackImageMoment;
    }
}

