/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.media.MediaExtractor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;

public class MediaExtractorBuilder {
    private static final String TAG = "MediaExtractorBuilder";
    private static final String CONTENT_URL_SCHEME = "content://";
    private String mFilePath = "";
    private String mMimeType = "";

    public MediaExtractorBuilder setPath(String path) {
        this.mFilePath = path;
        return this;
    }

    public MediaExtractorBuilder setMimeType(String mimeType) {
        this.mMimeType = mimeType;
        return this;
    }

    public MediaExtractor build() {
        MediaExtractor mediaExtractor = new MediaExtractor();
        try {
            if (MediaExtractorBuilder.isContentUri(this.mFilePath)) {
                Uri uri = Uri.parse((String)this.mFilePath);
                ParcelFileDescriptor parcelFileDescriptor = ContextUtils.getApplicationContext().getContentResolver().openFileDescriptor(uri, "r");
                mediaExtractor.setDataSource(parcelFileDescriptor.getFileDescriptor());
            } else {
                if (!f.a(this.mFilePath)) {
                    mediaExtractor.release();
                    return null;
                }
                mediaExtractor.setDataSource(this.mFilePath);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mMimeType)) {
                this.selectMimeType(mediaExtractor);
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "setDataSource: ".concat(String.valueOf(exception)));
            mediaExtractor.release();
            mediaExtractor = null;
        }
        return mediaExtractor;
    }

    private void selectMimeType(MediaExtractor extractor) {
        int n2 = extractor.getTrackCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!extractor.getTrackFormat(i2).getString("mime").startsWith(this.mMimeType)) continue;
            extractor.selectTrack(i2);
            return;
        }
    }

    public static boolean isContentUri(String pathOrUri) {
        return pathOrUri != null && pathOrUri.startsWith(CONTENT_URL_SCHEME);
    }
}

