/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;
import com.tencent.ugc.common.MediaExtractorBuilder;

public class MediaRetrieverBuilder {
    private final String TAG = "MediaRetrieverBuilder";
    private String mFilePath = "";

    public MediaRetrieverBuilder setPath(String path) {
        this.mFilePath = path;
        return this;
    }

    public MediaMetadataRetriever build() {
        Context context = ContextUtils.getApplicationContext();
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            if (MediaExtractorBuilder.isContentUri(this.mFilePath)) {
                Uri uri = Uri.parse((String)this.mFilePath);
                mediaMetadataRetriever.setDataSource(context, uri);
            } else {
                if (!f.a(this.mFilePath)) {
                    mediaMetadataRetriever.release();
                    return null;
                }
                mediaMetadataRetriever.setDataSource(this.mFilePath);
            }
        }
        catch (Exception exception) {
            LiteavLog.e("MediaRetrieverBuilder", String.valueOf(exception));
            mediaMetadataRetriever.release();
            mediaMetadataRetriever = null;
        }
        return mediaMetadataRetriever;
    }
}

