/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.watermark;

import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.videoprocessor.watermark.PasterBase;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PasterFilterChain
extends PasterBase {
    private List<TXVideoEditConstants.TXPaster> mPasterList;
    private CopyOnWriteArrayList<TXVideoEditConstants.TXPaster> mNormalizedList = new CopyOnWriteArrayList();

    public void setPasterList(List<TXVideoEditConstants.TXPaster> pasterList, Size renderSize) {
        this.mRenderSize = renderSize;
        this.mPasterList = pasterList;
        PasterFilterChain pasterFilterChain = this;
        pasterFilterChain.clearPasterList(pasterFilterChain.mNormalizedList);
    }

    public List<TXVideoEditConstants.TXPaster> getPasterList() {
        return this.mNormalizedList;
    }

    @Override
    public void normalized(int frameW, int frameH, int renderMode) {
        if (this.mPasterList == null || this.mPasterList.size() == 0) {
            return;
        }
        for (TXVideoEditConstants.TXPaster tXPaster : this.mPasterList) {
            if (tXPaster == null) continue;
            TXVideoEditConstants.TXRect tXRect = this.calculateRect(frameW, frameH, renderMode, tXPaster.frame);
            if (tXRect == null) {
                return;
            }
            TXVideoEditConstants.TXPaster tXPaster2 = this.construct(tXPaster, tXRect);
            this.mNormalizedList.add(tXPaster2);
        }
    }

    private TXVideoEditConstants.TXPaster construct(TXVideoEditConstants.TXPaster paster, TXVideoEditConstants.TXRect rect) {
        TXVideoEditConstants.TXPaster tXPaster = new TXVideoEditConstants.TXPaster();
        new TXVideoEditConstants.TXPaster().frame = rect;
        tXPaster.pasterImage = paster.pasterImage;
        tXPaster.startTime = paster.startTime;
        tXPaster.endTime = paster.endTime;
        return tXPaster;
    }

    @Override
    public void clear() {
        super.clear();
        PasterFilterChain pasterFilterChain = this;
        pasterFilterChain.clearPasterList(pasterFilterChain.mNormalizedList);
        PasterFilterChain pasterFilterChain2 = this;
        pasterFilterChain2.clearPasterList(pasterFilterChain2.mPasterList);
        this.mPasterList = null;
    }

    private void clearPasterList(List<TXVideoEditConstants.TXPaster> list) {
        if (list != null) {
            for (TXVideoEditConstants.TXPaster tXPaster : list) {
                if (tXPaster == null || tXPaster.pasterImage == null || tXPaster.pasterImage.isRecycled()) continue;
                tXPaster.pasterImage.recycle();
                tXPaster.pasterImage = null;
            }
            list.clear();
        }
    }
}

