/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.api16;

import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.text.TextBlock;
import com.wonderkiln.camerakit.CameraKit;
import com.wonderkiln.camerakit.CameraProperties;
import com.wonderkiln.camerakit.api16.ConstantMapper;
import com.wonderkiln.camerakit.base.CameraImpl;
import com.wonderkiln.camerakit.base.PreviewImpl;
import com.wonderkiln.camerakit.events.CameraKitError;
import com.wonderkiln.camerakit.events.CameraKitEvent;
import com.wonderkiln.camerakit.events.EventDispatcher;
import com.wonderkiln.camerakit.utils.AspectRatio;
import com.wonderkiln.camerakit.utils.Size;
import com.wonderkiln.camerakit.utils.YuvOperator;
import com.wonderkiln.camerakit.vision.FrameProcessingRunnable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Camera1
extends CameraImpl {
    private static final String TAG = Camera1.class.getSimpleName();
    private static final int FOCUS_AREA_SIZE_DEFAULT = 300;
    private static final int FOCUS_METERING_AREA_WEIGHT_DEFAULT = 1000;
    private static final int DELAY_MILLIS_BEFORE_RESETTING_FOCUS = 3000;
    private int mCameraId;
    private Camera mCamera;
    private Camera.Parameters mCameraParameters;
    private CameraProperties mCameraProperties;
    private Camera.CameraInfo mCameraInfo;
    private Size mCaptureSize;
    private Size mVideoSize;
    private Size mPreviewSize;
    private MediaRecorder mMediaRecorder;
    private Camera.AutoFocusCallback mAutofocusCallback;
    private boolean capturingImage = false;
    private boolean mShowingPreview;
    private boolean mRecording;
    private int mDisplayOrientation;
    private int mDeviceOrientation;
    private int mFacing;
    private int mFlash;
    private int mFocus;
    private int mMethod;
    private int mVideoQuality;
    private Detector<TextBlock> mTextDetector;
    private int mVideoBitRate;
    private boolean mLockVideoAspectRatio;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private Handler mHandler = new Handler();
    private FrameProcessingRunnable mFrameProcessor;
    private float mZoom = 1.0f;
    private CameraImpl.VideoCapturedCallback mVideoCallback;
    private final Object mCameraLock = new Object();
    private File mMediaRecorderOutputFile;
    private int orientation;

    public Camera1(EventDispatcher eventDispatcher, PreviewImpl preview) {
        super(eventDispatcher, preview);
        preview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
                if (Camera1.this.mCamera != null) {
                    if (Camera1.this.mShowingPreview) {
                        Camera1.this.mCamera.stopPreview();
                        Camera1.this.mShowingPreview = false;
                    }
                    Camera1.this.setDisplayAndDeviceOrientation();
                    Camera1.this.setupPreview();
                    if (!Camera1.this.mShowingPreview) {
                        Camera1.this.mCamera.startPreview();
                        Camera1.this.mShowingPreview = true;
                    }
                }
            }
        });
        this.mCameraInfo = new Camera.CameraInfo();
    }

    @Override
    public void start() {
        this.setFacing(this.mFacing);
        this.openCamera();
        if (this.mPreview.isReady()) {
            this.setDisplayAndDeviceOrientation();
            this.setupPreview();
            this.mCamera.startPreview();
            this.mShowingPreview = true;
        }
    }

    @Override
    public void stop() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mCamera != null) {
            try {
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                this.notifyErrorListener(e);
            }
        }
        this.mShowingPreview = false;
        this.releaseMediaRecorder();
        this.releaseCamera();
        if (this.mFrameProcessor != null) {
            this.mFrameProcessor.cleanup();
        }
    }

    public void setDisplayAndDeviceOrientation() {
        this.setDisplayAndDeviceOrientation(this.mDisplayOrientation, this.mDeviceOrientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayAndDeviceOrientation(int displayOrientation, int deviceOrientation) {
        this.mDisplayOrientation = displayOrientation;
        this.mDeviceOrientation = deviceOrientation;
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.isCameraOpened()) {
                try {
                    this.mCamera.setDisplayOrientation(this.calculatePreviewRotation());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFacing(int facing) {
        Object object = this.mCameraLock;
        synchronized (object) {
            int internalFacing = new ConstantMapper.Facing(facing).map();
            if (internalFacing == -1) {
                return;
            }
            int count = Camera.getNumberOfCameras();
            for (int i = 0; i < count; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mCameraInfo);
                if (this.mCameraInfo.facing != internalFacing) continue;
                this.mCameraId = i;
                this.mFacing = facing;
                break;
            }
            if (this.mFacing == facing && this.isCameraOpened()) {
                this.stop();
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlash(int flash) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCameraParameters != null) {
                List flashes = this.mCameraParameters.getSupportedFlashModes();
                String internalFlash = new ConstantMapper.Flash(flash).map();
                if (flashes != null && flashes.contains(internalFlash)) {
                    this.mCameraParameters.setFlashMode(internalFlash);
                    this.mFlash = flash;
                } else {
                    String currentFlash = new ConstantMapper.Flash(this.mFlash).map();
                    if (flashes == null || !flashes.contains(currentFlash)) {
                        this.mCameraParameters.setFlashMode("off");
                        this.mFlash = 0;
                    }
                }
                this.mCamera.setParameters(this.mCameraParameters);
            } else {
                this.mFlash = flash;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocus(int focus) {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mFocus = focus;
            switch (focus) {
                case 1: {
                    if (this.mCameraParameters == null) break;
                    List modes = this.mCameraParameters.getSupportedFocusModes();
                    if (modes.contains("continuous-picture")) {
                        this.mCameraParameters.setFocusMode("continuous-picture");
                        break;
                    }
                    this.setFocus(0);
                    break;
                }
                case 2: {
                    List modes;
                    if (this.mCameraParameters == null || !(modes = this.mCameraParameters.getSupportedFocusModes()).contains("continuous-picture")) break;
                    this.mCameraParameters.setFocusMode("continuous-picture");
                    break;
                }
                case 0: {
                    if (this.mCameraParameters == null) break;
                    List modes = this.mCameraParameters.getSupportedFocusModes();
                    if (modes.contains("fixed")) {
                        this.mCameraParameters.setFocusMode("fixed");
                        break;
                    }
                    if (modes.contains("infinity")) {
                        this.mCameraParameters.setFocusMode("infinity");
                        break;
                    }
                    this.mCameraParameters.setFocusMode("auto");
                }
            }
        }
    }

    @Override
    public void setMethod(int method) {
        this.mMethod = method;
    }

    @Override
    public void setTextDetector(Detector<TextBlock> detector) {
        this.mTextDetector = detector;
    }

    @Override
    public void setVideoQuality(int videoQuality) {
        this.mVideoQuality = videoQuality;
    }

    @Override
    public void setVideoBitRate(int videoBitRate) {
        this.mVideoBitRate = videoBitRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZoom(float zoomFactor) {
        Object object = this.mCameraLock;
        synchronized (object) {
            try {
                this.mZoom = zoomFactor;
                this.mZoom = zoomFactor <= 1.0f ? 1.0f : zoomFactor;
                if (this.mCameraParameters != null && this.mCameraParameters.isZoomSupported()) {
                    int zoomPercent = (int)(this.mZoom * 100.0f);
                    this.mCameraParameters.setZoom(this.getZoomForPercent(zoomPercent));
                    this.mCamera.setParameters(this.mCameraParameters);
                    float maxZoom = (float)((Integer)this.mCameraParameters.getZoomRatios().get(this.mCameraParameters.getZoomRatios().size() - 1)).intValue() / 100.0f;
                    if (this.mZoom > maxZoom) {
                        this.mZoom = maxZoom;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyZoom(float modifier) {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.setZoom(this.mZoom * modifier);
        }
    }

    private int getZoomForPercent(int zoomPercent) {
        List zoomRatios = this.mCameraParameters.getZoomRatios();
        int lowerIndex = -1;
        int upperIndex = -1;
        for (int i = 0; i < zoomRatios.size(); ++i) {
            if ((Integer)zoomRatios.get(i) < zoomPercent) {
                lowerIndex = i;
                continue;
            }
            if ((Integer)zoomRatios.get(i) <= zoomPercent) continue;
            upperIndex = i;
            break;
        }
        if (lowerIndex < 0) {
            return 0;
        }
        if (lowerIndex + 1 == upperIndex) {
            return lowerIndex;
        }
        if (upperIndex >= 0) {
            return upperIndex;
        }
        return zoomRatios.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusArea(float x, float y) {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                Camera.Parameters parameters = this.getCameraParameters();
                if (parameters == null) {
                    return;
                }
                String focusMode = parameters.getFocusMode();
                Rect rect = this.calculateFocusArea(x, y);
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(rect, this.getFocusMeteringAreaWeight()));
                if (parameters.getMaxNumFocusAreas() != 0 && focusMode != null && (focusMode.equals("auto") || focusMode.equals("macro") || focusMode.equals("continuous-picture") || focusMode.equals("continuous-video"))) {
                    parameters.setFocusMode("auto");
                    parameters.setFocusAreas(meteringAreas);
                    if (parameters.getMaxNumMeteringAreas() > 0) {
                        parameters.setMeteringAreas(meteringAreas);
                    }
                    if (!parameters.getSupportedFocusModes().contains("auto")) {
                        return;
                    }
                    this.mCamera.setParameters(parameters);
                    this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            Camera1.this.resetFocus(success, camera);
                        }
                    });
                } else if (parameters.getMaxNumMeteringAreas() > 0) {
                    if (!parameters.getSupportedFocusModes().contains("auto")) {
                        return;
                    }
                    parameters.setFocusMode("auto");
                    parameters.setFocusAreas(meteringAreas);
                    parameters.setMeteringAreas(meteringAreas);
                    this.mCamera.setParameters(parameters);
                    this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            Camera1.this.resetFocus(success, camera);
                        }
                    });
                } else {
                    this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            if (Camera1.this.mAutofocusCallback != null) {
                                Camera1.this.mAutofocusCallback.onAutoFocus(success, camera);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public void setLockVideoAspectRatio(boolean lockVideoAspectRatio) {
        this.mLockVideoAspectRatio = lockVideoAspectRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureImage(final CameraImpl.ImageCapturedCallback callback) {
        switch (this.mMethod) {
            case 0: {
                Object object = this.mCameraLock;
                synchronized (object) {
                    if (!this.capturingImage && this.mCamera != null) {
                        this.capturingImage = true;
                        int captureRotation = this.calculateCaptureRotation();
                        this.mCameraParameters.setRotation(captureRotation);
                        this.mCamera.setParameters(this.mCameraParameters);
                        this.mCamera.takePicture(null, null, null, new Camera.PictureCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onPictureTaken(byte[] data, Camera camera) {
                                callback.imageCaptured(data);
                                Camera1.this.capturingImage = false;
                                Object object = Camera1.this.mCameraLock;
                                synchronized (object) {
                                    if (Camera1.this.isCameraOpened()) {
                                        try {
                                            Camera1.this.stop();
                                            Camera1.this.start();
                                        }
                                        catch (Exception e) {
                                            Camera1.this.notifyErrorListener(e);
                                        }
                                    }
                                }
                            }
                        });
                    } else {
                        Log.w((String)TAG, (String)"Unable, waiting for picture to be taken");
                    }
                    break;
                }
            }
            case 1: {
                Object object = this.mCameraLock;
                synchronized (object) {
                    this.mCamera.setOneShotPreviewCallback(new Camera.PreviewCallback(){

                        public void onPreviewFrame(byte[] data, Camera camera) {
                            Camera.Parameters parameters = camera.getParameters();
                            int width = parameters.getPreviewSize().width;
                            int height = parameters.getPreviewSize().height;
                            int rotation = Camera1.this.calculateCaptureRotation();
                            YuvOperator yuvOperator = new YuvOperator(data, width, height);
                            yuvOperator.rotate(rotation);
                            data = yuvOperator.getYuvData();
                            int yuvOutputWidth = width;
                            int yuvOutputHeight = height;
                            if (rotation == 90 || rotation == 270) {
                                yuvOutputWidth = height;
                                yuvOutputHeight = width;
                            }
                            YuvImage yuvImage = new YuvImage(data, parameters.getPreviewFormat(), yuvOutputWidth, yuvOutputHeight, null);
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            yuvImage.compressToJpeg(new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight()), 100, (OutputStream)out);
                            callback.imageCaptured(out.toByteArray());
                        }
                    });
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureVideo(File videoFile, int maxDuration, CameraImpl.VideoCapturedCallback callback) {
        Object object = this.mCameraLock;
        synchronized (object) {
            try {
                if (this.prepareMediaRecorder(videoFile, maxDuration)) {
                    this.mMediaRecorder.start();
                    this.mRecording = true;
                    this.mVideoCallback = callback;
                    long l = System.currentTimeMillis();
                    if (this.mVideoCallback != null) {
                        this.mVideoCallback.onStart(l);
                    }
                } else {
                    this.releaseMediaRecorder();
                }
            }
            catch (IOException e) {
                this.releaseMediaRecorder();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.releaseMediaRecorder();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopVideo() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mRecording) {
                try {
                    if (this.mMediaRecorder != null) {
                        this.mMediaRecorder.stop();
                    }
                    if (this.mVideoCallback != null) {
                        this.mVideoCallback.videoCaptured(this.mMediaRecorderOutputFile);
                        this.mVideoCallback = null;
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    this.mMediaRecorderOutputFile.delete();
                }
                this.releaseMediaRecorder();
                this.mRecording = false;
            }
            this.stop();
            this.start();
        }
    }

    @Override
    public Size getCaptureResolution() {
        if (this.mCaptureSize == null && this.mCameraParameters != null) {
            TreeSet<Size> sizes = new TreeSet<Size>();
            for (Camera.Size size : this.mCameraParameters.getSupportedPictureSizes()) {
                sizes.add(new Size(size.width, size.height));
            }
            TreeSet<AspectRatio> aspectRatios = this.findCommonAspectRatios(this.mCameraParameters.getSupportedPreviewSizes(), this.mCameraParameters.getSupportedPictureSizes());
            AspectRatio targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mCaptureSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mCaptureSize = size;
                break;
            }
        }
        return this.mCaptureSize;
    }

    @Override
    public Size getVideoResolution() {
        if (this.mVideoSize == null && this.mCameraParameters != null) {
            if (this.mCameraParameters.getSupportedVideoSizes() == null) {
                this.mVideoSize = this.getCaptureResolution();
                return this.mVideoSize;
            }
            TreeSet<Size> sizes = new TreeSet<Size>();
            for (Camera.Size size : this.mCameraParameters.getSupportedVideoSizes()) {
                sizes.add(new Size(size.width, size.height));
            }
            TreeSet<AspectRatio> aspectRatios = this.findCommonAspectRatios(this.mCameraParameters.getSupportedPreviewSizes(), this.mCameraParameters.getSupportedVideoSizes());
            AspectRatio targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mVideoSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mVideoSize = size;
                break;
            }
        }
        return this.mVideoSize;
    }

    @Override
    public void setDeviceOrientation(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public Size getPreviewResolution() {
        Size cameraPreviewResolution = this.getCameraPreviewResolution();
        if (cameraPreviewResolution == null) {
            return new Size(480, 640);
        }
        int mWidth = cameraPreviewResolution.getHeight();
        int mHeight = cameraPreviewResolution.getWidth();
        if (this.orientation == 180) {
            mWidth = cameraPreviewResolution.getWidth();
            mHeight = cameraPreviewResolution.getHeight();
        }
        return new Size(mWidth, mHeight);
    }

    public Size getCameraPreviewResolution() {
        if (this.mPreviewSize == null && this.mCameraParameters != null) {
            TreeSet<Size> sizes = new TreeSet<Size>();
            for (Camera.Size size : this.mCameraParameters.getSupportedPreviewSizes()) {
                sizes.add(new Size(size.width, size.height));
            }
            TreeSet<AspectRatio> aspectRatios = this.findCommonAspectRatios(this.mCameraParameters.getSupportedPreviewSizes(), this.mCameraParameters.getSupportedPictureSizes());
            AspectRatio targetRatio = null;
            if (this.mLockVideoAspectRatio) {
                TreeSet<AspectRatio> videoAspectRatios = this.findCommonAspectRatios(this.mCameraParameters.getSupportedPreviewSizes(), this.mCameraParameters.getSupportedPictureSizes());
                Iterator<AspectRatio> descendingIterator = aspectRatios.descendingIterator();
                while (targetRatio == null && descendingIterator.hasNext()) {
                    AspectRatio ratio = descendingIterator.next();
                    if (!videoAspectRatios.contains(ratio)) continue;
                    targetRatio = ratio;
                }
            }
            if (targetRatio == null) {
                targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            }
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mPreviewSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mPreviewSize = size;
                break;
            }
        }
        return this.mPreviewSize;
    }

    @Override
    public boolean isCameraOpened() {
        return this.mCamera != null;
    }

    @Override
    public boolean frontCameraOnly() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
        boolean isFrontCameraOnly = Camera.getNumberOfCameras() == 1 && cameraInfo.facing == 1;
        return isFrontCameraOnly;
    }

    @Override
    @Nullable
    public CameraProperties getCameraProperties() {
        return this.mCameraProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                this.releaseCamera();
            }
            this.mCamera = Camera.open((int)this.mCameraId);
            this.mCameraParameters = this.mCamera.getParameters();
            this.collectCameraProperties();
            this.adjustCameraParameters();
            if (Build.VERSION.SDK_INT >= 16) {
                this.mCamera.setAutoFocusMoveCallback(new Camera.AutoFocusMoveCallback(){

                    public void onAutoFocusMoving(boolean b, Camera camera) {
                        CameraKitEvent event = new CameraKitEvent("CKFocusMovedEvent");
                        event.getData().putBoolean("started", b);
                        Camera1.this.mEventDispatcher.dispatch(event);
                    }
                });
            }
            this.mEventDispatcher.dispatch(new CameraKitEvent("CKCameraOpenedEvent"));
            if (this.mTextDetector != null) {
                this.mFrameProcessor = new FrameProcessingRunnable(this.mTextDetector, this.mPreviewSize, this.mCamera);
                this.mFrameProcessor.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPreview() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                try {
                    this.mCamera.reconnect();
                    this.mCamera.setPreviewDisplay(this.mPreview.getSurfaceHolder());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera != null) {
                this.mCamera.lock();
                this.mCamera.release();
                this.mCamera = null;
                this.mCameraParameters = null;
                this.mPreviewSize = null;
                this.mCaptureSize = null;
                this.mVideoSize = null;
                this.mEventDispatcher.dispatch(new CameraKitEvent("CKCameraStoppedEvent"));
                if (this.mFrameProcessor != null) {
                    this.mFrameProcessor.release();
                }
            }
        }
    }

    private int calculatePreviewRotation() {
        if (this.mCameraInfo.facing == 1) {
            return (360 - (this.mCameraInfo.orientation + this.mDisplayOrientation) % 360) % 360;
        }
        return (this.mCameraInfo.orientation - this.mDisplayOrientation + 360) % 360;
    }

    private int calculateCaptureRotation() {
        int captureRotation = 0;
        captureRotation = this.mCameraInfo.facing == 1 ? (this.mCameraInfo.orientation + this.mDisplayOrientation) % 360 : (this.mCameraInfo.orientation - this.mDisplayOrientation + 360) % 360;
        captureRotation = this.mCameraInfo.facing == 1 ? (captureRotation - (this.mDisplayOrientation - this.mDeviceOrientation) + 360) % 360 : (captureRotation + (this.mDisplayOrientation - this.mDeviceOrientation) + 360) % 360;
        return captureRotation;
    }

    private void notifyErrorListener(@NonNull String details) {
        CameraKitError error = new CameraKitError();
        error.setMessage(details);
        this.mEventDispatcher.dispatch(error);
    }

    private void notifyErrorListener(@NonNull Exception e) {
        CameraKitError error = new CameraKitError(e);
        this.mEventDispatcher.dispatch(error);
    }

    private Camera.Parameters getCameraParameters() {
        if (this.mCamera != null) {
            try {
                return this.mCamera.getParameters();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCameraParameters() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mShowingPreview) {
                this.mCamera.stopPreview();
            }
            this.adjustCameraParameters(0);
            if (this.mShowingPreview) {
                this.mCamera.startPreview();
            }
        }
    }

    private void adjustCameraParameters(int currentTry) {
        boolean haveToReadjust = false;
        Camera.Parameters resolutionLess = this.mCamera.getParameters();
        if (this.getPreviewResolution() != null) {
            this.mPreview.setPreviewParameters(this.getPreviewResolution().getWidth(), this.getPreviewResolution().getHeight(), this.mCameraParameters.getPreviewFormat());
            this.mCameraParameters.setPreviewSize(this.getCameraPreviewResolution().getWidth(), this.getCameraPreviewResolution().getHeight());
            try {
                this.mCamera.setParameters(this.mCameraParameters);
                resolutionLess = this.mCameraParameters;
            }
            catch (Exception e) {
                this.notifyErrorListener(e);
                this.mCameraParameters = resolutionLess;
            }
        } else {
            haveToReadjust = true;
        }
        if (this.getCaptureResolution() != null) {
            this.mCameraParameters.setPictureSize(this.getCaptureResolution().getWidth(), this.getCaptureResolution().getHeight());
            try {
                this.mCamera.setParameters(this.mCameraParameters);
                resolutionLess = this.mCameraParameters;
            }
            catch (Exception e) {
                this.notifyErrorListener(e);
                this.mCameraParameters = resolutionLess;
            }
        } else {
            haveToReadjust = true;
        }
        int rotation = this.calculateCaptureRotation();
        this.mCameraParameters.setRotation(rotation);
        this.setFocus(this.mFocus);
        try {
            this.setFlash(this.mFlash);
        }
        catch (Exception e) {
            this.notifyErrorListener(e);
        }
        if (this.mCameraParameters.isZoomSupported()) {
            this.setZoom(this.mZoom);
        }
        this.mCamera.setParameters(this.mCameraParameters);
        if (haveToReadjust && currentTry < 100) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.notifyErrorListener(String.format("retryAdjustParam Failed, attempt #: %d", currentTry));
            this.adjustCameraParameters(currentTry + 1);
        }
    }

    private void collectCameraProperties() {
        this.mCameraProperties = new CameraProperties(this.mCameraParameters.getVerticalViewAngle(), this.mCameraParameters.getHorizontalViewAngle());
    }

    private TreeSet<AspectRatio> findCommonAspectRatios(List<Camera.Size> previewSizes, List<Camera.Size> pictureSizes) {
        HashSet<AspectRatio> previewAspectRatios = new HashSet<AspectRatio>();
        for (Camera.Size size : previewSizes) {
            AspectRatio previewRatio;
            CamcorderProfile camcorderProfile = this.getCamcorderProfile(this.mVideoQuality);
            AspectRatio deviceRatio = camcorderProfile == null ? AspectRatio.of(CameraKit.Internal.screenHeight, CameraKit.Internal.screenWidth) : AspectRatio.of(camcorderProfile.videoFrameWidth, camcorderProfile.videoFrameHeight);
            if (!deviceRatio.equals(previewRatio = AspectRatio.of(size.width, size.height))) continue;
            previewAspectRatios.add(previewRatio);
        }
        HashSet<AspectRatio> captureAspectRatios = new HashSet<AspectRatio>();
        for (Camera.Size size : pictureSizes) {
            captureAspectRatios.add(AspectRatio.of(size.width, size.height));
        }
        TreeSet<AspectRatio> treeSet = new TreeSet<AspectRatio>();
        if (previewAspectRatios.size() == 0) {
            Camera.Size maxSize = previewSizes.get(0);
            AspectRatio maxPreviewAspectRatio = AspectRatio.of(maxSize.width, maxSize.height);
            for (AspectRatio aspectRatio : captureAspectRatios) {
                if (!aspectRatio.equals(maxPreviewAspectRatio)) continue;
                treeSet.add(aspectRatio);
            }
        } else {
            for (AspectRatio aspectRatio : previewAspectRatios) {
                if (!captureAspectRatios.contains(aspectRatio)) continue;
                treeSet.add(aspectRatio);
            }
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareMediaRecorder(File videoFile, int maxDuration) throws IOException {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mCamera.unlock();
            this.mMediaRecorder = new MediaRecorder();
            this.mMediaRecorder.setCamera(this.mCamera);
            this.mMediaRecorder.setAudioSource(1);
            this.mMediaRecorder.setVideoSource(1);
            this.mMediaRecorder.setVideoEncodingBitRate(921600);
            CamcorderProfile profile = this.getCamcorderProfile(this.mVideoQuality);
            profile.videoBitRate = 921600;
            this.mMediaRecorder.setProfile(profile);
            this.mMediaRecorder.setAudioChannels(2);
            this.mMediaRecorder.setAudioEncodingBitRate(128000);
            this.mMediaRecorder.setAudioSamplingRate(44100);
            if (videoFile == null) {
                videoFile = this.getVideoFile();
            }
            if (videoFile == null) {
                return false;
            }
            this.mMediaRecorderOutputFile = videoFile;
            this.mMediaRecorder.setOutputFile(videoFile.getPath());
            this.mMediaRecorder.setPreviewDisplay(this.mPreview.getSurface());
            this.mMediaRecorder.setOrientationHint(this.calculatePreviewRotation());
            if (maxDuration > 0) {
                this.mMediaRecorder.setMaxDuration(maxDuration);
                this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

                    public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                        if (what == 800) {
                            Camera1.this.stopVideo();
                        }
                    }
                });
            }
            try {
                this.mMediaRecorder.prepare();
            }
            catch (IllegalStateException e) {
                this.releaseMediaRecorder();
                return false;
            }
            catch (IOException e) {
                this.releaseMediaRecorder();
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMediaRecorder() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.reset();
                this.mMediaRecorder.release();
                this.mMediaRecorder = null;
                this.mCamera.lock();
            }
        }
    }

    private File getVideoFile() {
        if (!Environment.getExternalStorageState().equalsIgnoreCase("mounted")) {
            return null;
        }
        File mediaStorageDir = new File(Environment.getExternalStorageDirectory(), "Camera");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        return new File(mediaStorageDir.getPath() + File.separator + "video.mp4");
    }

    private CamcorderProfile getCamcorderProfile(int videoQuality) {
        CamcorderProfile camcorderProfile = null;
        switch (videoQuality) {
            case 6: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)7)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)7);
                    break;
                }
                camcorderProfile = this.getCamcorderProfile(5);
                break;
            }
            case 0: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)4)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)4);
                    break;
                }
                camcorderProfile = this.getCamcorderProfile(6);
                break;
            }
            case 1: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)5)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)5);
                    break;
                }
                camcorderProfile = this.getCamcorderProfile(0);
                break;
            }
            case 2: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)6)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)6);
                    break;
                }
                camcorderProfile = this.getCamcorderProfile(1);
                break;
            }
            case 3: {
                try {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)8);
                }
                catch (Exception e) {
                    camcorderProfile = this.getCamcorderProfile(4);
                }
                break;
            }
            case 4: {
                camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)1);
                break;
            }
            case 5: {
                camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)0);
            }
        }
        if (camcorderProfile != null && this.mVideoBitRate != 0) {
            camcorderProfile.videoBitRate = this.mVideoBitRate;
        }
        return camcorderProfile;
    }

    void setTapToAutofocusListener(Camera.AutoFocusCallback callback) {
        if (this.mFocus != 2) {
            throw new IllegalArgumentException("Please set the camera to FOCUS_TAP.");
        }
        this.mAutofocusCallback = callback;
    }

    private int getFocusAreaSize() {
        return 300;
    }

    private int getFocusMeteringAreaWeight() {
        return 1000;
    }

    private void resetFocus(final boolean success, Camera camera) {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Camera1.this.mCameraLock;
                synchronized (object) {
                    if (Camera1.this.mCamera != null) {
                        Camera1.this.mCamera.cancelAutoFocus();
                        Camera.Parameters parameters = Camera1.this.getCameraParameters();
                        if (parameters == null) {
                            return;
                        }
                        if (parameters.getFocusMode() != "continuous-picture") {
                            parameters.setFocusMode("continuous-picture");
                            parameters.setFocusAreas(null);
                            parameters.setMeteringAreas(null);
                            Camera1.this.mCamera.setParameters(parameters);
                        }
                        if (Camera1.this.mAutofocusCallback != null) {
                            Camera1.this.mAutofocusCallback.onAutoFocus(success, Camera1.this.mCamera);
                        }
                    }
                }
            }
        }, 3000L);
    }

    private Rect calculateFocusArea(float x, float y) {
        int padding = this.getFocusAreaSize() / 2;
        int centerX = (int)(x * 2000.0f);
        int centerY = (int)(y * 2000.0f);
        int left = centerX - padding;
        int top = centerY - padding;
        int right = centerX + padding;
        int bottom = centerY + padding;
        if (left < 0) {
            left = 0;
        }
        if (right > 2000) {
            right = 2000;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom > 2000) {
            bottom = 2000;
        }
        return new Rect(left - 1000, top - 1000, right - 1000, bottom - 1000);
    }
}

