/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.vision;

import android.annotation.SuppressLint;
import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.wonderkiln.camerakit.utils.Size;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class FrameProcessingRunnable
implements Runnable {
    private static final String TAG = FrameProcessingRunnable.class.getSimpleName();
    private Detector<?> mDetector;
    private long mStartTimeMillis = SystemClock.elapsedRealtime();
    private final Object mLock = new Object();
    private boolean mActive = true;
    private long mPendingTimeMillis;
    private int mPendingFrameId = 0;
    private ByteBuffer mPendingFrameData;
    private Thread mProcessingThread;
    private Map<byte[], ByteBuffer> mBytesToByteBuffer = new HashMap<byte[], ByteBuffer>();
    private Size mPreviewSize;
    private Camera mCamera;

    public FrameProcessingRunnable(Detector<?> detector, Size mPreviewSize, Camera mCamera) {
        this.mDetector = detector;
        this.mPreviewSize = mPreviewSize;
        this.mCamera = mCamera;
        this.mProcessingThread = new Thread(this);
    }

    @SuppressLint(value={"Assert"})
    public void release() {
        assert (this.mProcessingThread.getState() == Thread.State.TERMINATED);
        this.mDetector.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ByteBuffer data;
            Frame outputFrame;
            Object object = this.mLock;
            synchronized (object) {
                while (this.mActive && this.mPendingFrameData == null) {
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (!this.mActive) {
                    return;
                }
                if (this.mPreviewSize == null) {
                    Log.d((String)"WHAT", (String)"waitin for preview size to not be null");
                    continue;
                }
                outputFrame = new Frame.Builder().setImageData(this.mPendingFrameData, this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight(), 17).setId(this.mPendingFrameId).setTimestampMillis(this.mPendingTimeMillis).setRotation(0).build();
                data = this.mPendingFrameData;
                this.mPendingFrameData = null;
            }
            try {
                this.mDetector.receiveFrame(outputFrame);
                continue;
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Exception thrown from receiver.", (Throwable)t);
                continue;
            }
            finally {
                this.mCamera.addCallbackBuffer(data.array());
                continue;
            }
            break;
        }
    }

    public void cleanup() {
        if (this.mProcessingThread != null) {
            try {
                this.mProcessingThread.join();
            }
            catch (InterruptedException e) {
                Log.d((String)TAG, (String)"Frame processing thread interrupted on release.");
            }
            this.mProcessingThread = null;
        }
        this.setActive(false);
        this.mBytesToByteBuffer.clear();
    }

    public void start() {
        this.mProcessingThread = new Thread(this);
        this.setActive(true);
        this.mProcessingThread.start();
        this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] bytes, Camera camera) {
                FrameProcessingRunnable.this.setNextFrame(bytes, camera);
            }
        });
        this.mCamera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        this.mCamera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        this.mCamera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
        this.mCamera.addCallbackBuffer(this.createPreviewBuffer(this.mPreviewSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActive(boolean active) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActive = active;
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNextFrame(byte[] data, Camera camera) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingFrameData != null) {
                camera.addCallbackBuffer(this.mPendingFrameData.array());
                this.mPendingFrameData = null;
            }
            if (!this.mBytesToByteBuffer.containsKey(data)) {
                Log.d((String)TAG, (String)"Skipping frame.  Could not find ByteBuffer associated with the image data from the camera.");
                return;
            }
            this.mPendingTimeMillis = SystemClock.elapsedRealtime() - this.mStartTimeMillis;
            ++this.mPendingFrameId;
            this.mPendingFrameData = this.mBytesToByteBuffer.get(data);
            this.mLock.notifyAll();
        }
    }

    private void addBuffer(byte[] byteArray, ByteBuffer buffer) {
        this.mBytesToByteBuffer.put(byteArray, buffer);
    }

    private byte[] createPreviewBuffer(Size previewSize) {
        int bitsPerPixel = ImageFormat.getBitsPerPixel((int)17);
        long sizeInBits = previewSize.getHeight() * previewSize.getWidth() * bitsPerPixel;
        int bufferSize = (int)Math.ceil((double)sizeInBits / 8.0) + 1;
        byte[] byteArray = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        if (!buffer.hasArray() || buffer.array() != byteArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.addBuffer(byteArray, buffer);
        return byteArray;
    }
}

