/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.RequiresApi;
import com.tencent.liteav.base.util.LiteavLog;

public class TXSubtitleView
extends RelativeLayout {
    private static final String TAG = "TXSubtitleView";
    private ImageView mSubtitleIV;
    private Handler mMainHandler;

    public TXSubtitleView(Context context) {
        super(context);
        this.init();
    }

    public TXSubtitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TXSubtitleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public TXSubtitleView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mSubtitleIV = new ImageView(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13);
        TXSubtitleView tXSubtitleView = this;
        tXSubtitleView.addView((View)tXSubtitleView.mSubtitleIV, (ViewGroup.LayoutParams)layoutParams);
    }

    public void show(final Bitmap subtitleBitmap) {
        LiteavLog.i(TAG, "[show] subtitleBitmap =".concat(String.valueOf(subtitleBitmap)));
        this.runOnUIThread(new Runnable(){

            @Override
            public final void run() {
                TXSubtitleView.this.mSubtitleIV.setImageBitmap(subtitleBitmap);
            }
        });
    }

    private void runOnUIThread(Runnable runnable) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            this.mMainHandler.post(runnable);
            return;
        }
        runnable.run();
    }
}

