/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.player;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import com.daya.orchestra.accompany.utils.ALOG;
import java.io.IOException;

public class CustomPlayer
implements MediaPlayer.OnErrorListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener {
    public static final String TAG = "CustomPlayer";
    private Context mContext;
    MediaPlayer mPlayer;
    private boolean hasPrepared;
    private boolean isStoped = false;
    private boolean isNeedMute = false;
    private int prepareSeekPosition = -1;

    public CustomPlayer() {
        this.initPlayer();
    }

    private void initPlayer() {
        if (null == this.mPlayer) {
            this.mPlayer = new MediaPlayer();
            this.mPlayer.setAudioStreamType(3);
            this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        }
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        if (this.mPlayer != null) {
            this.mPlayer.setOnCompletionListener(listener);
        }
    }

    public void play(Context context, Uri dataSource) {
        this.hasPrepared = false;
        this.isStoped = false;
        this.initPlayer();
        try {
            this.mPlayer.reset();
            this.mPlayer.setDataSource(context, dataSource);
            this.mPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void play(boolean isMute, String path) {
        this.hasPrepared = false;
        this.isStoped = false;
        this.isNeedMute = isMute;
        this.initPlayer();
        try {
            this.mPlayer.reset();
            this.mPlayer.setDataSource(path);
            this.mPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getPrepareSeekPosition() {
        return this.prepareSeekPosition;
    }

    public int getExceptTargetPos(int cu) {
        int targetPos = this.getPrepareSeekPosition() != -1 ? cu - this.getPrepareSeekPosition() : cu;
        return targetPos;
    }

    public void setPrepareSeekPosition(int prepareSeekPosition) {
        this.prepareSeekPosition = prepareSeekPosition;
    }

    public int getCu() {
        if (this.mPlayer != null) {
            int currentPosition = this.mPlayer.getCurrentPosition();
            return currentPosition;
        }
        return -1;
    }

    public int getT() {
        if (this.mPlayer != null) {
            int duration = this.mPlayer.getDuration();
            return duration;
        }
        return -1;
    }

    public void start() {
        if (this.isStoped) {
            return;
        }
        if (null != this.mPlayer && this.hasPrepared) {
            this.mPlayer.start();
            this.setVolume(this.isNeedMute ? 0.0f : 1.0f);
            if (this.prepareSeekPosition > 0) {
                this.seekTo(this.prepareSeekPosition);
            }
        }
    }

    public void setVolume(float volume) {
        if (this.mPlayer != null) {
            ALOG.i("setVolume:" + volume + "hasPrepared:" + this.hasPrepared);
            this.mPlayer.setVolume(volume, volume);
        }
    }

    public void pause() {
        if (null != this.mPlayer && this.hasPrepared) {
            this.mPlayer.pause();
        }
    }

    public void seekTo(int position) {
        if (null != this.mPlayer && this.hasPrepared) {
            this.mPlayer.seekTo(position);
        }
    }

    public void setDisplay(SurfaceHolder holder) {
        if (null != this.mPlayer) {
            this.mPlayer.setDisplay(holder);
        }
    }

    public void stop() {
        if (this.mPlayer == null) {
            return;
        }
        this.prepareSeekPosition = -1;
        this.isStoped = true;
        this.hasPrepared = false;
        Log.i((String)TAG, (String)("player to stop:" + this.hasPrepared + "-thread:" + Thread.currentThread().getName()));
        this.mPlayer.stop();
    }

    public void onPrepared(MediaPlayer mp) {
        this.hasPrepared = true;
        this.start();
    }

    public void onCompletion(MediaPlayer mp) {
        this.hasPrepared = false;
        ALOG.i(TAG, "onCompletion");
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.hasPrepared = false;
        return true;
    }

    public void setSpeed(float speed) {
        Log.i((String)TAG, (String)("setSpeed:" + speed));
        try {
            if (this.mPlayer != null) {
                if (speed > 5.0f) {
                    speed = 5.0f;
                }
                if (speed < 0.3f) {
                    speed = 0.3f;
                }
                PlaybackParams playbackParams = null;
                if (Build.VERSION.SDK_INT >= 23) {
                    playbackParams = this.mPlayer.getPlaybackParams();
                    playbackParams.setSpeed(speed);
                    this.mPlayer.setPlaybackParams(playbackParams);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initAudioEffect() {
    }

    public void release() {
        this.hasPrepared = false;
        this.isStoped = true;
        this.mPlayer.stop();
        this.mPlayer.release();
        this.mPlayer = null;
    }
}

