/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.utils;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.OrientationEventListener;

public abstract class DisplayOrientationDetector {
    private final OrientationEventListener mOrientationEventListener;
    static final SparseIntArray DISPLAY_ORIENTATIONS = new SparseIntArray();
    private Display mDisplay;
    private int mLastKnownDisplayOrientation = 0;
    private int mLastKnownDeviceOrientation = 0;

    public DisplayOrientationDetector(Context context) {
        this.mOrientationEventListener = new OrientationEventListener(context){
            private int mLastKnownDisplayRotation;
            {
                this.mLastKnownDisplayRotation = -1;
            }

            public void onOrientationChanged(int orientation) {
                if (orientation == -1 || DisplayOrientationDetector.this.mDisplay == null) {
                    return;
                }
                boolean displayOrDeviceOrientationChanged = false;
                int displayRotation = DisplayOrientationDetector.this.mDisplay.getRotation();
                if (this.mLastKnownDisplayRotation != displayRotation) {
                    this.mLastKnownDisplayRotation = displayRotation;
                    displayOrDeviceOrientationChanged = true;
                }
                int deviceOrientation = orientation >= 60 && orientation <= 140 ? 270 : (orientation >= 140 && orientation <= 220 ? 180 : (orientation >= 220 && orientation <= 300 ? 90 : 0));
                if (DisplayOrientationDetector.this.mLastKnownDeviceOrientation != deviceOrientation) {
                    DisplayOrientationDetector.this.mLastKnownDeviceOrientation = deviceOrientation;
                    displayOrDeviceOrientationChanged = true;
                }
                if (displayOrDeviceOrientationChanged) {
                    DisplayOrientationDetector.this.dispatchOnDisplayOrDeviceOrientationChanged(DISPLAY_ORIENTATIONS.get(displayRotation));
                }
            }
        };
    }

    public void enable(Display display) {
        this.mDisplay = display;
        this.mOrientationEventListener.enable();
        this.dispatchOnDisplayOrDeviceOrientationChanged(DISPLAY_ORIENTATIONS.get(display.getRotation()));
    }

    public void disable() {
        this.mOrientationEventListener.disable();
        this.mDisplay = null;
    }

    public int getLastKnownDisplayOrientation() {
        return this.mLastKnownDisplayOrientation;
    }

    void dispatchOnDisplayOrDeviceOrientationChanged(int displayOrientation) {
        this.mLastKnownDisplayOrientation = displayOrientation;
        if (this.mOrientationEventListener.canDetectOrientation()) {
            this.onDisplayOrDeviceOrientationChanged(displayOrientation, this.mLastKnownDeviceOrientation);
        } else {
            this.onDisplayOrDeviceOrientationChanged(displayOrientation, displayOrientation);
        }
    }

    public abstract void onDisplayOrDeviceOrientationChanged(int var1, int var2);

    static {
        DISPLAY_ORIENTATIONS.put(0, 0);
        DISPLAY_ORIENTATIONS.put(1, 90);
        DISPLAY_ORIENTATIONS.put(2, 180);
        DISPLAY_ORIENTATIONS.put(3, 270);
    }
}

