/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.common;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.tencent.thumbplayer.core.common.TPMethodCalledByNative;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TPHeadsetPluginDetector {
    private static final String TAG = "TPHeadsetPluginDetector";
    private static final int AUDIO_TYPE_BUILTIN_SPEAKER = 0;
    private static final int AUDIO_TYPE_HEADPHONES = 1;
    private static final int AUDIO_TYPE_BLUETOOTH_A2DP = 2;
    private static final int AUDIO_TYPE_BUILTIN_OTHERS = 99;
    private static boolean isInitted = false;
    private static boolean hasRegisterReceiver = false;
    private static WeakReference<Context> mContextRef = null;
    private static BroadcastReceiver mReceiver = null;
    private static List<HeadsetPluginListener> listeners = new LinkedList<HeadsetPluginListener>();
    private static Set<Integer> mCurOutputs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        Class<TPHeadsetPluginDetector> clazz = TPHeadsetPluginDetector.class;
        synchronized (TPHeadsetPluginDetector.class) {
            if (isInitted) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Context context2 = context.getApplicationContext();
            mContextRef = new WeakReference<Context>(context2);
            isInitted = true;
            TPHeadsetPluginDetector.initCurrentOutputs();
            TPNativeLog.printLog(2, TAG, "HeadsetPluginDetector init succeed!");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinit() {
        Class<TPHeadsetPluginDetector> clazz = TPHeadsetPluginDetector.class;
        synchronized (TPHeadsetPluginDetector.class) {
            if (!isInitted || mContextRef == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            mContextRef.clear();
            isInitted = false;
            TPNativeLog.printLog(2, TAG, "HeadsetPluginDetector deinit succeed!");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @TPMethodCalledByNative
    public static boolean isHeadsetPlugin() {
        AudioManager audioManager = TPHeadsetPluginDetector.getAudioManager();
        if (audioManager == null) {
            return false;
        }
        return audioManager.isWiredHeadsetOn();
    }

    @TPMethodCalledByNative
    public static boolean isBluetoothPlugin() {
        AudioManager audioManager = TPHeadsetPluginDetector.getAudioManager();
        if (audioManager == null) {
            return false;
        }
        return audioManager.isBluetoothA2dpOn();
    }

    @TPMethodCalledByNative
    public static boolean isAudioRouteTypeOn(int n2) {
        if (mCurOutputs == null) {
            return false;
        }
        return mCurOutputs.contains(n2);
    }

    @TPMethodCalledByNative
    public static Set<Integer> getCurrentRoutes() {
        return mCurOutputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHeadsetPluginListener(HeadsetPluginListener headsetPluginListener) {
        Class<TPHeadsetPluginDetector> clazz = TPHeadsetPluginDetector.class;
        synchronized (TPHeadsetPluginDetector.class) {
            if (listeners.add(headsetPluginListener) && !hasRegisterReceiver) {
                TPHeadsetPluginDetector.registerReceiver();
                hasRegisterReceiver = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHeadsetPluginListener(HeadsetPluginListener headsetPluginListener) {
        Class<TPHeadsetPluginDetector> clazz = TPHeadsetPluginDetector.class;
        synchronized (TPHeadsetPluginDetector.class) {
            listeners.remove(headsetPluginListener);
            if (listeners.isEmpty() && hasRegisterReceiver) {
                TPHeadsetPluginDetector.unregisterReceiver();
                hasRegisterReceiver = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void initCurrentOutputs() {
        mCurOutputs = TPHeadsetPluginDetector.getAudioOutputs();
    }

    private static Set<Integer> getAudioOutputs() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        AudioManager audioManager = TPHeadsetPluginDetector.getAudioManager();
        if (audioManager == null) {
            return hashSet;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] audioDeviceInfoArray = audioManager.getDevices(2);
            if (audioDeviceInfoArray != null) {
                AudioDeviceInfo[] audioDeviceInfoArray2 = audioDeviceInfoArray;
                int n2 = audioDeviceInfoArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray2[i2];
                    if (audioDeviceInfo.getType() == 2) {
                        hashSet.add(0);
                        continue;
                    }
                    if (audioDeviceInfo.getType() == 8) {
                        hashSet.add(2);
                        continue;
                    }
                    if (audioDeviceInfo.getType() != 3) continue;
                    hashSet.add(1);
                }
            }
        } else {
            hashSet.add(0);
            if (TPHeadsetPluginDetector.isHeadsetPlugin()) {
                hashSet.add(1);
            }
            if (TPHeadsetPluginDetector.isBluetoothPlugin()) {
                hashSet.add(2);
            }
        }
        return hashSet;
    }

    @RequiresApi(api=23)
    private static boolean registerDeviceCallback() {
        AudioManager audioManager = TPHeadsetPluginDetector.getAudioManager();
        if (audioManager == null) {
            return false;
        }
        audioManager.registerAudioDeviceCallback(new AudioDeviceCallback(){

            public final void onAudioDevicesAdded(AudioDeviceInfo[] audioDeviceInfoArray) {
                TPNativeLog.printLog(2, TPHeadsetPluginDetector.TAG, "onAudioDevicesAdded!");
                TPHeadsetPluginDetector.notifyAudioOutputStateChange(mCurOutputs, TPHeadsetPluginDetector.getAudioOutputs());
            }

            public final void onAudioDevicesRemoved(AudioDeviceInfo[] audioDeviceInfoArray) {
                TPNativeLog.printLog(2, TPHeadsetPluginDetector.TAG, "onAudioDevicesRemoved!");
                TPHeadsetPluginDetector.notifyAudioOutputStateChange(mCurOutputs, TPHeadsetPluginDetector.getAudioOutputs());
            }
        }, null);
        return true;
    }

    private static void registerReceiver() {
        if (Build.VERSION.SDK_INT >= 23 && TPHeadsetPluginDetector.registerDeviceCallback()) {
            return;
        }
        if (mReceiver == null) {
            mReceiver = new HeadsetPluginReceiver();
        }
        if (!isInitted || mContextRef == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, TPHeadsetPluginDetector is not init yet!");
            return;
        }
        Context context = (Context)mContextRef.get();
        if (context == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, context is null, maybe is invalid!");
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        context.registerReceiver(mReceiver, intentFilter);
    }

    private static void unregisterReceiver() {
        if (!isInitted || mContextRef == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, HeadsetPluginDetector is not init yet!");
            return;
        }
        Context context = (Context)mContextRef.get();
        if (context == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, context is null, maybe is invalid!");
            return;
        }
        context.unregisterReceiver(mReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyAudioOutputStateChange(Set<Integer> set, Set<Integer> set2) {
        boolean bl2 = true;
        if (set != null && set2 != null && set.size() == set2.size() && set2.containsAll(set)) {
            bl2 = false;
        }
        if (!bl2) {
            return;
        }
        mCurOutputs = set2;
        Class<TPHeadsetPluginDetector> clazz = TPHeadsetPluginDetector.class;
        synchronized (TPHeadsetPluginDetector.class) {
            Iterator<HeadsetPluginListener> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onHeadsetPlugin(set, set2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static AudioManager getAudioManager() {
        if (!isInitted || mContextRef == null) {
            TPNativeLog.printLog(4, TAG, "getAudioManager failed, HeadsetPluginDetector is not init yet!");
            return null;
        }
        Context context = (Context)mContextRef.get();
        if (context == null) {
            TPNativeLog.printLog(4, TAG, "getAudioManager failed, context is null, maybe is invalid!");
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
        if (audioManager == null) {
            TPNativeLog.printLog(4, TAG, "getAudioManager failed, audioMgr is null!");
            return null;
        }
        return audioManager;
    }

    static class HeadsetPluginReceiver
    extends BroadcastReceiver {
        private HeadsetPluginReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            TPNativeLog.printLog(2, TPHeadsetPluginDetector.TAG, "onReceive: " + intent.getAction());
            Set set = TPHeadsetPluginDetector.getAudioOutputs();
            if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                String string = "state";
                int n2 = 0;
                if (intent.hasExtra(string)) {
                    n2 = intent.getIntExtra(string, 0);
                }
                if (set != null) {
                    if (n2 == 0) {
                        set.remove(1);
                    } else if (n2 == 1) {
                        set.add(1);
                    }
                }
                TPHeadsetPluginDetector.notifyAudioOutputStateChange(mCurOutputs, set);
                return;
            }
            if ("android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                if (set != null) {
                    set.remove(1);
                }
                TPHeadsetPluginDetector.notifyAudioOutputStateChange(mCurOutputs, set);
                return;
            }
            if ("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                int n3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                if (set != null) {
                    if (n3 == 2) {
                        set.add(2);
                    } else if (n3 == 0) {
                        set.remove(2);
                    }
                }
                TPHeadsetPluginDetector.notifyAudioOutputStateChange(mCurOutputs, set);
            }
        }
    }

    static interface HeadsetPluginListener {
        public void onHeadsetPlugin(Set<Integer> var1, Set<Integer> var2);
    }
}

