/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.connection;

import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedirectHandler {
    private static final int MAX_REDIRECT_TIMES = 10;
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final int HTTP_PERMANENT_REDIRECT = 308;

    public static FileDownloadConnection process(Map<String, List<String>> requestHeaderFields, FileDownloadConnection connection, List<String> redirectedUrlList) throws IOException, IllegalAccessException {
        int code = connection.getResponseCode();
        String location = connection.getResponseHeaderField("Location");
        ArrayList<String> redirectLocationList = new ArrayList<String>();
        int redirectTimes = 0;
        FileDownloadConnection redirectConnection = connection;
        while (RedirectHandler.isRedirect(code)) {
            if (location == null) {
                throw new IllegalAccessException(FileDownloadUtils.formatString("receive %d (redirect) but the location is null with response [%s]", code, redirectConnection.getResponseHeaderFields()));
            }
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(RedirectHandler.class, "redirect to %s with %d, %s", location, code, redirectLocationList);
            }
            redirectConnection.ending();
            redirectConnection = RedirectHandler.buildRedirectConnection(requestHeaderFields, location);
            redirectLocationList.add(location);
            redirectConnection.execute();
            code = redirectConnection.getResponseCode();
            location = redirectConnection.getResponseHeaderField("Location");
            if (++redirectTimes < 10) continue;
            throw new IllegalAccessException(FileDownloadUtils.formatString("redirect too many times! %s", redirectLocationList));
        }
        if (redirectedUrlList != null) {
            redirectedUrlList.addAll(redirectLocationList);
        }
        return redirectConnection;
    }

    private static boolean isRedirect(int code) {
        return code == 301 || code == 302 || code == 303 || code == 300 || code == 307 || code == 308;
    }

    private static FileDownloadConnection buildRedirectConnection(Map<String, List<String>> requestHeaderFields, String newUrl) throws IOException {
        FileDownloadConnection redirectConnection = CustomComponentHolder.getImpl().createConnection(newUrl);
        Set<Map.Entry<String, List<String>>> entries = requestHeaderFields.entrySet();
        for (Map.Entry<String, List<String>> e : entries) {
            String name = e.getKey();
            List<String> list = e.getValue();
            if (list == null) continue;
            for (String value : list) {
                redirectConnection.addHeader(name, value);
            }
        }
        return redirectConnection;
    }
}

