/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.event;

import com.liulishuo.filedownloader.event.IDownloadEvent;
import com.liulishuo.filedownloader.event.IDownloadEventPool;
import com.liulishuo.filedownloader.event.IDownloadListener;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class DownloadEventPoolImpl
implements IDownloadEventPool {
    private final Executor threadPool = FileDownloadExecutors.newDefaultThreadPool(10, "EventPool");
    private final HashMap<String, LinkedList<IDownloadListener>> listenersMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(String eventId, IDownloadListener listener) {
        String string;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "setListener %s", eventId);
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null!");
        }
        LinkedList<IDownloadListener> container = this.listenersMap.get(eventId);
        if (container == null) {
            string = eventId.intern();
            synchronized (string) {
                container = this.listenersMap.get(eventId);
                if (container == null) {
                    container = new LinkedList();
                    this.listenersMap.put(eventId, container);
                }
            }
        }
        string = eventId.intern();
        synchronized (string) {
            return container.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(String eventId, IDownloadListener listener) {
        String string;
        LinkedList<IDownloadListener> container;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "removeListener %s", eventId);
        }
        if ((container = this.listenersMap.get(eventId)) == null) {
            string = eventId.intern();
            synchronized (string) {
                container = this.listenersMap.get(eventId);
            }
        }
        if (container == null || listener == null) {
            return false;
        }
        string = eventId.intern();
        synchronized (string) {
            boolean succeed = container.remove(listener);
            if (container.size() <= 0) {
                this.listenersMap.remove(eventId);
            }
            return succeed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(IDownloadEvent event) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "publish %s", event.getId());
        }
        if (event == null) {
            throw new IllegalArgumentException("event must not be null!");
        }
        String eventId = event.getId();
        LinkedList<IDownloadListener> listeners = this.listenersMap.get(eventId);
        if (listeners == null) {
            String string = eventId.intern();
            synchronized (string) {
                listeners = this.listenersMap.get(eventId);
                if (listeners == null) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "No listener for this event %s", eventId);
                    }
                    return false;
                }
            }
        }
        this.trigger(listeners, event);
        return true;
    }

    @Override
    public void asyncPublishInNewThread(final IDownloadEvent event) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "asyncPublishInNewThread %s", event.getId());
        }
        if (event == null) {
            throw new IllegalArgumentException("event must not be null!");
        }
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                DownloadEventPoolImpl.this.publish(event);
            }
        });
    }

    private void trigger(LinkedList<IDownloadListener> listeners, IDownloadEvent event) {
        Object o;
        Object[] lists;
        Object[] objectArray = lists = listeners.toArray();
        int n = objectArray.length;
        for (int i = 0; !(i >= n || (o = objectArray[i]) != null && ((IDownloadListener)o).callback(event)); ++i) {
        }
        if (event.callback != null) {
            event.callback.run();
        }
    }
}

