/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.daasuu.mp4compose.composer.BaseAudioChannel;
import com.daasuu.mp4compose.composer.SonicAudioProcessor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AudioChannelWithSP
extends BaseAudioChannel {
    private static final String TAG = "AUDIO_CHANNEL_WITH_SONIC";
    private SonicAudioProcessor stream = null;
    private float timeScale = 1.0f;
    boolean isEOF = false;
    private int BUFFER_CAPACITY = 2048;
    private long totalDataAdded = 0L;
    private int pendingDecoderOutputBuffIndx = -1;
    private ByteBuffer tempInputBuffer = null;
    private boolean isPendingFeeding = true;
    private boolean isAffectInPitch;

    AudioChannelWithSP(MediaCodec decoder, MediaCodec encoder, MediaFormat encodeFormat, float timeScale, boolean isPitchChanged) {
        super(decoder, encoder, encodeFormat);
        this.isAffectInPitch = isPitchChanged;
        this.timeScale = timeScale;
    }

    @Override
    public void setActualDecodedFormat(MediaFormat decodedFormat) {
        super.setActualDecodedFormat(decodedFormat);
        if (this.inputChannelCount > 2) {
            throw new UnsupportedOperationException("Input channel count (" + this.inputChannelCount + ") not supported.");
        }
        this.stream = new SonicAudioProcessor(this.inputSampleRate, this.outputChannelCount);
        this.isEOF = false;
        this.totalDataAdded = 0L;
        this.isPendingFeeding = true;
        this.tempInputBuffer = ByteBuffer.allocateDirect(this.BUFFER_CAPACITY * 16).order(ByteOrder.nativeOrder());
        if (this.isAffectInPitch) {
            this.stream.setRate(this.timeScale);
        } else {
            this.stream.setSpeed(this.timeScale);
        }
    }

    @Override
    protected long sampleCountToDurationUs(long sampleCount, int sampleRate, int channelCount) {
        return (long)(1000000.0f * ((float)sampleCount * 1.0f) / ((float)sampleRate * 1.0f * (float)channelCount));
    }

    @Override
    public void drainDecoderBufferAndQueue(int bufferIndex, long presentationTimeUs) {
        ByteBuffer data;
        if (this.actualDecodedFormat == null) {
            throw new RuntimeException("Buffer received before format!");
        }
        ByteBuffer byteBuffer = data = bufferIndex == -1 ? null : this.decoder.getOutputBuffer(bufferIndex);
        if (data != null) {
            this.writeToSonicSteam(data.asShortBuffer());
            this.pendingDecoderOutputBuffIndx = bufferIndex;
            this.isEOF = false;
            this.decoder.releaseOutputBuffer(bufferIndex, false);
        } else {
            this.stream.flushStream();
            this.isEOF = true;
        }
    }

    @Override
    public boolean feedEncoder(long timeoutUs) {
        if (this.stream == null || !this.isPendingFeeding || !this.isEOF && this.stream.samplesAvailable() == 0) {
            this.updatePendingDecoderStatus();
            return false;
        }
        if (!this.isEOF && this.timeScale < 1.0f && this.stream.samplesAvailable() > 0 && this.stream.samplesAvailable() * this.outputChannelCount < this.BUFFER_CAPACITY) {
            this.updatePendingDecoderStatus();
            return false;
        }
        int encoderInBuffIndex = this.encoder.dequeueInputBuffer(timeoutUs);
        if (encoderInBuffIndex < 0) {
            return false;
        }
        boolean status = false;
        status = this.timeScale < 1.0f ? this.slowTimeBufferProcess(encoderInBuffIndex) : this.FastOrNormalTimeBufferProcess(encoderInBuffIndex);
        return status;
    }

    private void updatePendingDecoderStatus() {
        if (this.pendingDecoderOutputBuffIndx != -1) {
            this.pendingDecoderOutputBuffIndx = -1;
        }
    }

    private boolean FastOrNormalTimeBufferProcess(int encoderInBuffIndex) {
        int samplesNum = this.stream.samplesAvailable();
        boolean status = false;
        int rawDataLen = samplesNum * this.outputChannelCount;
        if (rawDataLen >= this.BUFFER_CAPACITY) {
            return this.readStreamDataAndQueueToEncoder(this.BUFFER_CAPACITY, encoderInBuffIndex);
        }
        if (rawDataLen > 0 && rawDataLen < this.BUFFER_CAPACITY) {
            return this.readStreamDataAndQueueToEncoder(rawDataLen, encoderInBuffIndex);
        }
        if (this.isEOF && samplesNum == 0) {
            return this.finalizeEncoderQueue(encoderInBuffIndex);
        }
        return status;
    }

    private boolean slowTimeBufferProcess(int encoderInBuffIndex) {
        int samplesNum = this.stream.samplesAvailable();
        boolean status = false;
        int rawDataLen = samplesNum * this.outputChannelCount;
        if (rawDataLen >= this.BUFFER_CAPACITY) {
            return this.readStreamDataAndQueueToEncoder(this.BUFFER_CAPACITY, encoderInBuffIndex);
        }
        if (this.isEOF && rawDataLen > 0 && rawDataLen < this.BUFFER_CAPACITY) {
            return this.readStreamDataAndQueueToEncoder(rawDataLen, encoderInBuffIndex);
        }
        if (this.isEOF && rawDataLen == 0) {
            return this.finalizeEncoderQueue(encoderInBuffIndex);
        }
        return status;
    }

    private boolean finalizeEncoderQueue(int encoderInBuffIndex) {
        this.isPendingFeeding = false;
        return this.queueInputBufferInEncoder(null, encoderInBuffIndex);
    }

    private boolean readStreamDataAndQueueToEncoder(int capacity, int encoderInBuffIndex) {
        short[] rawData = new short[capacity];
        this.stream.readShortFromStream(rawData, capacity / this.outputChannelCount);
        return this.queueInputBufferInEncoder(rawData, encoderInBuffIndex);
    }

    private boolean queueInputBufferInEncoder(short[] rawData, int encoderInBuffIndex) {
        ShortBuffer outBuffer = this.encoder.getInputBuffer(encoderInBuffIndex).asShortBuffer();
        outBuffer.clear();
        if (rawData != null) {
            outBuffer.put(rawData);
            this.totalDataAdded += (long)rawData.length;
            long presentationTimeUs = this.sampleCountToDurationUs(this.totalDataAdded, this.inputSampleRate, this.outputChannelCount);
            this.encoder.queueInputBuffer(encoderInBuffIndex, 0, rawData.length * 2, presentationTimeUs, 0);
            return false;
        }
        this.encoder.queueInputBuffer(encoderInBuffIndex, 0, 0, 0L, 4);
        return false;
    }

    private void writeToSonicSteam(ShortBuffer data) {
        short[] temBuff = new short[data.capacity()];
        data.get(temBuff);
        data.rewind();
        this.stream.writeShortToStream(temBuff, temBuff.length / this.outputChannelCount);
    }

    public boolean isAnyPendingBuffIndex() {
        return this.pendingDecoderOutputBuffIndx != -1;
    }
}

