/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.config;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import com.taobao.weex.WXSDKInstance;
import io.dcloud.feature.weex.config.UniPathParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;

public class MimeInfoParser {
    HashSet<String> registerFileTypeSet = new HashSet();
    HashSet<String> registerFileFormatSet = new HashSet();
    HashSet<String> registerEncodeFormatSet = new HashSet();
    final String DATA_FLAG = "data:";
    final String FILE_TYPE_FLAG = "/";
    final String FILE_FORMAT_FLAG = ";";
    final String ENCODE_FORMAT_FLAG = ",";

    public static MimeInfoParser getInstance() {
        return new MimeInfoParser();
    }

    private MimeInfoParser() {
        this.registerFileTypeSet.add("keystore");
        this.registerFileTypeSet.add("cert");
        this.registerFileFormatSet.add("p12");
        this.registerFileFormatSet.add("pem");
        this.registerEncodeFormatSet.add("filepath");
        this.registerEncodeFormatSet.add("base64");
        this.registerEncodeFormatSet.add("text");
    }

    public static InputStream getFilePathStream(WXSDKInstance wxsdkInstance, String filePath) {
        if (wxsdkInstance != null) {
            String androidPathUrl = wxsdkInstance.getURIAdapter().rewrite(wxsdkInstance, "file", Uri.parse((String)filePath)).toString();
            FileInputStream certificate = null;
            try {
                File cerFile = new File(new URI(androidPathUrl));
                if (cerFile.exists()) {
                    certificate = new FileInputStream(cerFile);
                    return certificate;
                }
                String assetPath = UniPathParser.getAndroidPath(filePath);
                File assetFile = new File(assetPath);
                if (assetFile.exists()) {
                    certificate = new FileInputStream(assetFile);
                    return certificate;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public MimeInfo obtainMimeInfo(String mimeEncode) {
        MimeInfo mimeInfo = this.parseMimeInfo(mimeEncode);
        if (mimeInfo != null && !mimeInfo.isValid(this)) {
            return null;
        }
        return mimeInfo;
    }

    private MimeInfo parseMimeInfo(String mimeEncode) {
        MimeInfo ret = new MimeInfo();
        if (!mimeEncode.startsWith("data:")) {
            return null;
        }
        if (!mimeEncode.contains("/")) {
            return null;
        }
        if (!mimeEncode.contains(";")) {
            return null;
        }
        if (!mimeEncode.contains(",")) {
            return null;
        }
        String nextEncode = mimeEncode.substring("data:".length());
        String encodeFileType = nextEncode.substring(0, nextEncode.indexOf("/"));
        ret.fileType = encodeFileType;
        nextEncode = nextEncode.substring((encodeFileType + "/").length());
        String encodeFileFormat = nextEncode.substring(0, nextEncode.indexOf(";"));
        ret.fileFormat = encodeFileFormat;
        nextEncode = nextEncode.substring((encodeFileFormat + ";").length());
        String encodeFormat = nextEncode.substring(0, nextEncode.indexOf(","));
        ret.encodeFormat = encodeFormat;
        nextEncode = nextEncode.substring((encodeFormat + ",").length());
        ret.dataContent = nextEncode;
        return ret;
    }

    public static class MimeInfo {
        private String fileType;
        private String fileFormat;
        private String encodeFormat;
        private String dataContent;

        public InputStream getDataBytes(WXSDKInstance wxsdkInstance) {
            if ("base64".equals(this.encodeFormat)) {
                ByteArrayInputStream certificate = new ByteArrayInputStream(Base64.decode((String)this.dataContent, (int)2));
                return certificate;
            }
            if ("text".equals(this.encodeFormat)) {
                ByteArrayInputStream certificate = new ByteArrayInputStream(this.dataContent.getBytes());
                return certificate;
            }
            if ("filepath".equals(this.encodeFormat)) {
                if (wxsdkInstance != null) {
                    String androidPathUrl = wxsdkInstance.getURIAdapter().rewrite(wxsdkInstance, "file", Uri.parse((String)this.dataContent)).toString();
                    FileInputStream certificate = null;
                    try {
                        File cerFile = new File(new URI(androidPathUrl));
                        certificate = new FileInputStream(cerFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        certificate = null;
                    }
                    return certificate;
                }
                return null;
            }
            return null;
        }

        private boolean isValid(MimeInfoParser mimeInfoParser) {
            if (TextUtils.isEmpty((CharSequence)this.fileType) || TextUtils.isEmpty((CharSequence)this.fileFormat) || TextUtils.isEmpty((CharSequence)this.encodeFormat) || TextUtils.isEmpty((CharSequence)this.dataContent)) {
                return false;
            }
            if (!mimeInfoParser.registerFileTypeSet.contains(this.fileType)) {
                return false;
            }
            if (!mimeInfoParser.registerFileFormatSet.contains(this.fileFormat)) {
                return false;
            }
            return mimeInfoParser.registerEncodeFormatSet.contains(this.encodeFormat);
        }

        public String getFileType() {
            return this.fileType;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }

        public void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        public String getEncodeFormat() {
            return this.encodeFormat;
        }

        public void setEncodeFormat(String encodeFormat) {
            this.encodeFormat = encodeFormat;
        }

        public String getDataContent() {
            return this.dataContent;
        }

        public void setDataContent(String dataContent) {
            this.dataContent = dataContent;
        }
    }
}

