/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Paint;
import android.text.Spannable;
import android.util.AttributeSet;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.DimenRes;
import androidx.annotation.Px;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import com.vanniktech.emoji.EmojiEditable;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;

public class EmojiAutoCompleteTextView
extends AppCompatAutoCompleteTextView
implements EmojiEditable {
    private float emojiSize;

    public EmojiAutoCompleteTextView(Context context) {
        this(context, null);
    }

    public EmojiAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.emojiSize = Utils.initTextView((TextView)this, attrs);
    }

    public EmojiAutoCompleteTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.emojiSize = Utils.initTextView((TextView)this, attrs);
    }

    @CallSuper
    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        EmojiManager.getInstance().replaceWithImages(this.getContext(), (Spannable)this.getText(), this.emojiSize != 0.0f ? this.emojiSize : defaultEmojiSize);
    }

    @Override
    @CallSuper
    public void backspace() {
        Utils.backspace((EditText)this);
    }

    @Override
    @CallSuper
    public void input(Emoji emoji) {
        Utils.input((EditText)this, emoji);
    }

    @Override
    public final float getEmojiSize() {
        return this.emojiSize;
    }

    @Override
    public final void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    @Override
    public final void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText((CharSequence)this.getText());
        }
    }

    @Override
    public final void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    @Override
    public final void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }
}

