/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.daasuu.mp4compose.composer.BaseAudioChannel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

class AudioChannel
extends BaseAudioChannel {
    AudioChannel(MediaCodec decoder, MediaCodec encoder, MediaFormat encodeFormat) {
        super(decoder, encoder, encodeFormat);
    }

    @Override
    public void setActualDecodedFormat(MediaFormat decodedFormat) {
        super.setActualDecodedFormat(decodedFormat);
        if (this.inputChannelCount != 1 && this.inputChannelCount != 2) {
            throw new UnsupportedOperationException("Input channel count (" + this.inputChannelCount + ") not supported.");
        }
    }

    @Override
    public void drainDecoderBufferAndQueue(int bufferIndex, long presentationTimeUs) {
        if (this.actualDecodedFormat == null) {
            throw new RuntimeException("Buffer received before format!");
        }
        ByteBuffer data = bufferIndex == -1 ? null : this.decoder.getOutputBuffer(bufferIndex);
        BaseAudioChannel.AudioBuffer buffer = (BaseAudioChannel.AudioBuffer)this.emptyBuffers.poll();
        if (buffer == null) {
            buffer = new BaseAudioChannel.AudioBuffer();
        }
        buffer.bufferIndex = bufferIndex;
        buffer.presentationTimeUs = presentationTimeUs;
        ShortBuffer shortBuffer = buffer.data = data == null ? null : data.asShortBuffer();
        if (this.overflowBuffer.data == null) {
            this.overflowBuffer.data = ByteBuffer.allocateDirect(data.capacity()).order(ByteOrder.nativeOrder()).asShortBuffer();
            this.overflowBuffer.data.clear().flip();
        }
        this.filledBuffers.add(buffer);
    }

    @Override
    public boolean feedEncoder(long timeoutUs) {
        boolean hasOverflow;
        boolean bl = hasOverflow = this.overflowBuffer.data != null && this.overflowBuffer.data.hasRemaining();
        if (this.filledBuffers.isEmpty() && !hasOverflow) {
            return false;
        }
        int encoderInBuffIndex = this.encoder.dequeueInputBuffer(timeoutUs);
        if (encoderInBuffIndex < 0) {
            return false;
        }
        ShortBuffer outBuffer = this.encoder.getInputBuffer(encoderInBuffIndex).asShortBuffer();
        if (hasOverflow) {
            long presentationTimeUs = this.drainOverflow(outBuffer);
            this.encoder.queueInputBuffer(encoderInBuffIndex, 0, outBuffer.position() * 2, presentationTimeUs, 0);
            return true;
        }
        BaseAudioChannel.AudioBuffer inBuffer = (BaseAudioChannel.AudioBuffer)this.filledBuffers.poll();
        if (inBuffer.bufferIndex == -1) {
            this.encoder.queueInputBuffer(encoderInBuffIndex, 0, 0, 0L, 4);
            return false;
        }
        long presentationTimeUs = this.remixAndMaybeFillOverflow(inBuffer, outBuffer);
        this.encoder.queueInputBuffer(encoderInBuffIndex, 0, outBuffer.position() * 2, presentationTimeUs, 0);
        if (inBuffer != null) {
            this.decoder.releaseOutputBuffer(inBuffer.bufferIndex, false);
            this.emptyBuffers.add(inBuffer);
        }
        return true;
    }

    @Override
    protected long sampleCountToDurationUs(long sampleCount, int sampleRate, int channelCount) {
        return sampleCount / ((long)sampleRate * 1000000L) / (long)channelCount;
    }

    private long drainOverflow(ShortBuffer outBuff) {
        ShortBuffer overflowBuff = this.overflowBuffer.data;
        int overflowLimit = overflowBuff.limit();
        int overflowSize = overflowBuff.remaining();
        long beginPresentationTimeUs = this.overflowBuffer.presentationTimeUs + this.sampleCountToDurationUs(overflowBuff.position(), this.inputSampleRate, this.outputChannelCount);
        outBuff.clear();
        overflowBuff.limit(outBuff.capacity());
        outBuff.put(overflowBuff);
        if (overflowSize >= outBuff.capacity()) {
            overflowBuff.clear().limit(0);
        } else {
            overflowBuff.limit(overflowLimit);
        }
        return beginPresentationTimeUs;
    }

    private long remixAndMaybeFillOverflow(BaseAudioChannel.AudioBuffer input, ShortBuffer outBuff) {
        ShortBuffer inBuff = input.data;
        ShortBuffer overflowBuff = this.overflowBuffer.data;
        outBuff.clear();
        inBuff.clear();
        if (inBuff.remaining() > outBuff.remaining()) {
            inBuff.limit(outBuff.capacity());
            outBuff.put(inBuff);
            inBuff.limit(inBuff.capacity());
            long consumedDurationUs = this.sampleCountToDurationUs(inBuff.position(), this.inputSampleRate, this.inputChannelCount);
            overflowBuff.put(inBuff);
            overflowBuff.flip();
            this.overflowBuffer.presentationTimeUs = input.presentationTimeUs + consumedDurationUs;
        } else {
            outBuff.put(inBuff);
        }
        return input.presentationTimeUs;
    }
}

