/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.base;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewbinding.ViewBinding;
import com.daya.orchestra.accompany.helper.QMUIStatusBarHelper;

public abstract class BaseActivity<V extends ViewBinding>
extends AppCompatActivity {
    protected V viewBinding = null;

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(BaseActivity.getConfigurationContext(newBase));
    }

    private static Context getConfigurationContext(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        configuration.fontScale = 1.0f;
        return context.createConfigurationContext(configuration);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.viewBinding = this.getLayoutView();
        this.setContentView(this.viewBinding.getRoot());
        QMUIStatusBarHelper.translucent((Activity)this);
        this.initView();
        this.initData();
    }

    protected void initData() {
    }

    protected abstract void initView();

    protected abstract V getLayoutView();

    public V getViewBinding() {
        return this.viewBinding;
    }

    public boolean checkActivityExist() {
        return !this.isFinishing() && !this.isDestroyed();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.viewBinding != null) {
            this.viewBinding = null;
        }
    }
}

