/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.Utils;
import com.daya.orchestra.accompany.widget.AcPermissionTipDialog;
import com.tbruyelle.rxpermissions3.RxPermissions;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class AcPermissionTipHelper {
    private AcPermissionTipDialog mPermissionTipDialog;
    private Disposable mTimeDisposable;
    private boolean isShow = true;

    private AcPermissionTipHelper() {
    }

    public static AcPermissionTipHelper getInstance() {
        return PermissionTipHelperHolder.mHelper;
    }

    public void showTipDialog(Activity activity, String[] permissions) {
        this.showTipDialog(activity, permissions, "", "");
    }

    public void showTipDialog(Fragment context, String[] permissions) {
        this.showTipDialog((Activity)context.getActivity(), permissions, "", "");
    }

    public void showTipDialog(final Activity activity, final String[] permissions, final String title, final String tip) {
        if (this.hasPermissions((Context)activity, permissions)) {
            return;
        }
        this.isShow = true;
        Observable timer = Observable.timer((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        timer.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Long>(){

            public void onSubscribe(@NonNull Disposable d) {
                AcPermissionTipHelper.this.mTimeDisposable = d;
            }

            public void onNext(@NonNull Long aLong) {
                AcPermissionTipHelper.this.doAction(activity, permissions, title, tip);
            }

            public void onError(@NonNull Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    private void doAction(Activity activity, String[] permissions, String title, String tip) {
        ALOG.i("acc", "showTipDialog:" + this.isShow);
        if (!this.isShow) {
            return;
        }
        this.mPermissionTipDialog = new AcPermissionTipDialog((Context)activity);
        this.mPermissionTipDialog.show();
        String des = !TextUtils.isEmpty((CharSequence)tip) ? tip : this.getTipFromPermissions(permissions);
        this.mPermissionTipDialog.setDes(des);
    }

    private String getTipFromPermissions(String[] permissions) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            String tip = this.createTip(permission2);
            if (stringBuilder.indexOf(tip) != -1) continue;
            stringBuilder.append(tip);
        }
        return stringBuilder.toString();
    }

    private String createTip(String permission2) {
        if (TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.CAMERA")) {
            return Utils.getApp().getString(R.string.ac_camera_permission_tip);
        }
        if (TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.WRITE_EXTERNAL_STORAGE")) {
            return Utils.getApp().getString(R.string.ac_write_or_read_storage_permission_tip);
        }
        if (TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.READ_EXTERNAL_STORAGE")) {
            return Utils.getApp().getString(R.string.ac_write_or_read_storage_permission_tip);
        }
        if (TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.RECORD_AUDIO")) {
            return Utils.getApp().getString(R.string.ac_record_audio_permission_tip);
        }
        if (TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.CALL_PHONE")) {
            return Utils.getApp().getString(R.string.ac_call_phone_permission_tip);
        }
        return "";
    }

    private boolean hasPermission(RxPermissions rxPermissions, String[] permissions) {
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            boolean granted = rxPermissions.isGranted(permission2);
            boolean revoked = rxPermissions.isRevoked(permission2);
            ALOG.i("permission:" + permission2 + "granted:+" + granted + "-revoked:" + revoked);
            if (granted || revoked) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissions(Context context, String[] permissions) {
        if (permissions == null || permissions.length == 0) {
            return true;
        }
        boolean ifSdk = Build.VERSION.SDK_INT >= 23;
        for (String permission2 : permissions) {
            if (!ifSdk || this.hasPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPermission(Context context, String permission2) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public void dismissDialog() {
        ALOG.i("acc", "dismissDialog");
        this.isShow = false;
        if (this.mTimeDisposable != null) {
            this.mTimeDisposable.dispose();
        }
        if (this.mPermissionTipDialog != null) {
            this.mPermissionTipDialog.dismiss();
            this.mPermissionTipDialog = null;
        }
    }

    private static class PermissionTipHelperHolder {
        private static AcPermissionTipHelper mHelper = new AcPermissionTipHelper();

        private PermissionTipHelperHolder() {
        }
    }
}

