/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.utils;

import android.app.Application;
import android.content.Context;
import android.graphics.Point;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.daya.orchestra.accompany.common.Constants;
import com.daya.orchestra.accompany.helper.QMUIDisplayHelper;
import com.daya.orchestra.accompany.utils.SizeUtils;

public class Utils {
    private static Application sApp;
    private static final int MIN_CLICK_DELAY_TIME = 1000;
    private static long lastClickTime;

    public static void init(Application application) {
        sApp = application;
    }

    public static Application getApp() {
        return sApp;
    }

    public static String checkType(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] devices = audioManager.getDevices(2);
            String result = null;
            for (AudioDeviceInfo device : devices) {
                int deviceType = device.getType();
                if (deviceType == 3 || deviceType == 4) {
                    result = "\u6709\u7ebf\u8033\u673a";
                }
                if (deviceType != 8 && deviceType != 7) continue;
                result = "\u84dd\u7259\u8033\u673a";
            }
            if (TextUtils.isEmpty(result)) {
                if (Constants.HEADSET_PLUE_TAG.isEmpty()) {
                    return null;
                }
                return "\u6709\u7ebf\u8033\u673a";
            }
            return result;
        }
        if (audioManager.isWiredHeadsetOn()) {
            return "\u6709\u7ebf\u8033\u673a";
        }
        if (audioManager.isBluetoothScoOn() || audioManager.isBluetoothA2dpOn()) {
            return "\u84dd\u7259\u8033\u673a";
        }
        return null;
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isFastClick() {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if (curClickTime - lastClickTime < 1000L) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }

    public static boolean isFastClick(long timeLimit) {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if (curClickTime - lastClickTime < timeLimit) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }

    public static void setHeadView(View view, Context context, int height) {
        int statusBarHeight = QMUIDisplayHelper.getStatusBarHeight(context);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (statusBarHeight == 0) {
            statusBarHeight = Utils.getStatusBarHeight(context);
        }
        if (statusBarHeight == 0) {
            statusBarHeight = SizeUtils.dp2px(20.0f);
        }
        layoutParams.height = statusBarHeight + SizeUtils.dp2px(height);
        view.setLayoutParams(layoutParams);
    }

    public static int getCurrentStatusBarHeight(Context context) {
        int statusBarHeight = QMUIDisplayHelper.getStatusBarHeight(context);
        if (statusBarHeight == 0) {
            statusBarHeight = Utils.getStatusBarHeight(context);
        }
        if (statusBarHeight == 0) {
            statusBarHeight = SizeUtils.dp2px(20.0f);
        }
        return statusBarHeight;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getAppScreenHeight() {
        WindowManager wm = (WindowManager)Utils.getApp().getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        wm.getDefaultDisplay().getSize(point);
        return point.y;
    }
}

