/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_switch;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.dcloud.feature.weex_switch.SwitchButton;

public class SwitchGroup
extends LinearLayout {
    private static final int DEFAULT_WIDTH = SwitchGroup.dp2pxInt(58.0f);
    private static final int DEFAULT_HEIGHT = SwitchGroup.dp2pxInt(36.0f);
    int i = 0;

    public SwitchGroup(Context context) {
        super(context);
        SwitchButton sb = new SwitchButton(context);
        LinearLayout.LayoutParams centerParams = new LinearLayout.LayoutParams(-1, -1);
        this.addView(sb, (ViewGroup.LayoutParams)centerParams);
    }

    public SwitchGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SwitchGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int topChild = 0;
        int count = this.getChildCount();
        for (int index = 0; index < count; ++index) {
            SwitchButton child = (SwitchButton)this.getChildAt(index);
            int childHeight = (int)((float)child.getMeasuredHeight() + child.getShadowBottomSize());
            int childWidth = child.getMeasuredWidth();
            child.layout(0, topChild, childWidth, topChild + childHeight);
        }
        this.disableClipOnParents((View)this);
    }

    public void disableClipOnParents(View v) {
        if (v.getParent() == null) {
            return;
        }
        if (v instanceof ViewGroup) {
            ((ViewGroup)v).setClipChildren(false);
        }
        if (v.getParent() instanceof View && this.i < 2) {
            ++this.i;
            this.disableClipOnParents((View)v.getParent());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == 0 || widthMode == Integer.MIN_VALUE) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)DEFAULT_WIDTH, (int)0x40000000);
        }
        if (heightMode == 0 || heightMode == Integer.MIN_VALUE) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)DEFAULT_HEIGHT, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private static int dp2pxInt(float dp) {
        return (int)SwitchGroup.dp2px(dp);
    }

    private static float dp2px(float dp) {
        Resources r = Resources.getSystem();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }
}

