/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.taobao.weex.base.CalledByNative;
import java.io.Serializable;
import java.lang.reflect.Method;

public class SystemMessageHandler
extends Handler
implements Serializable {
    private static final String TAG = "SystemMessageHandler";
    private static final int SCHEDULED_WORK = 1;
    private long mMessagePumpDelegateNative = 0L;
    private Method mMessageMethodSetAsynchronous;

    private native void nativeRunWork(long var1);

    private SystemMessageHandler(long messagePumpDelegateNative, boolean mainHandle) {
        super(mainHandle ? Looper.getMainLooper() : Looper.myLooper());
        this.mMessagePumpDelegateNative = messagePumpDelegateNative;
        try {
            Class<?> messageClass = Class.forName("android.os.Message");
            this.mMessageMethodSetAsynchronous = messageClass.getMethod("setAsynchronous", Boolean.TYPE);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Failed to find android.os.Message class:" + e));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Failed to load Message.setAsynchronous method:" + e));
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Exception while loading Message.setAsynchronous method: " + e));
        }
    }

    @CalledByNative
    public static SystemMessageHandler create(long messagePumpDelegateNative, boolean mainHandle) {
        return new SystemMessageHandler(messagePumpDelegateNative, mainHandle);
    }

    @CalledByNative
    private void scheduleWork() {
        this.sendMessage(this.obtainAsyncMessage(1));
    }

    @CalledByNative
    private void scheduleDelayedWork(long delayMillis) {
        this.sendMessageDelayed(this.obtainAsyncMessage(1), delayMillis);
    }

    @CalledByNative
    private void stop() {
        this.removeMessages(1);
    }

    private Message obtainAsyncMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        return msg;
    }

    public void handleMessage(Message msg) {
        this.nativeRunWork(this.mMessagePumpDelegateNative);
    }
}

