/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Notification;
import android.os.Looper;
import com.liulishuo.filedownloader.FileDownloader;
import java.io.File;

public class FileDownloadLine {
    public void startForeground(final int id, final Notification notification) {
        if (FileDownloader.getImpl().isServiceConnected()) {
            FileDownloader.getImpl().startForeground(id, notification);
            return;
        }
        ConnectSubscriber subscriber = new ConnectSubscriber(){

            @Override
            public void connected() {
                FileDownloader.getImpl().startForeground(id, notification);
            }

            @Override
            public Object getValue() {
                return null;
            }
        };
        this.wait(subscriber);
    }

    public long getSoFar(final int id) {
        if (FileDownloader.getImpl().isServiceConnected()) {
            return FileDownloader.getImpl().getSoFar(id);
        }
        ConnectSubscriber subscriber = new ConnectSubscriber(){
            private long mValue;

            @Override
            public void connected() {
                this.mValue = FileDownloader.getImpl().getSoFar(id);
            }

            @Override
            public Object getValue() {
                return this.mValue;
            }
        };
        this.wait(subscriber);
        return (Long)subscriber.getValue();
    }

    public long getTotal(final int id) {
        if (FileDownloader.getImpl().isServiceConnected()) {
            return FileDownloader.getImpl().getTotal(id);
        }
        ConnectSubscriber subscriber = new ConnectSubscriber(){
            private long mValue;

            @Override
            public void connected() {
                this.mValue = FileDownloader.getImpl().getTotal(id);
            }

            @Override
            public Object getValue() {
                return this.mValue;
            }
        };
        this.wait(subscriber);
        return (Long)subscriber.getValue();
    }

    public byte getStatus(final int id, final String path) {
        if (FileDownloader.getImpl().isServiceConnected()) {
            return FileDownloader.getImpl().getStatus(id, path);
        }
        if (path != null && new File(path).exists()) {
            return -3;
        }
        ConnectSubscriber subscriber = new ConnectSubscriber(){
            private byte mValue;

            @Override
            public void connected() {
                this.mValue = FileDownloader.getImpl().getStatus(id, path);
            }

            @Override
            public Object getValue() {
                return this.mValue;
            }
        };
        this.wait(subscriber);
        return (Byte)subscriber.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(ConnectSubscriber subscriber) {
        ConnectListener connectListener;
        ConnectListener connectListener2 = connectListener = new ConnectListener(subscriber);
        synchronized (connectListener2) {
            FileDownloader.getImpl().bindService(connectListener);
            if (!connectListener.isFinished()) {
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    throw new IllegalThreadStateException("Sorry, FileDownloader can not block the main thread, because the system is also  callbacks ServiceConnection#onServiceConnected method in the main thread.");
                }
                try {
                    connectListener.wait(200000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static interface ConnectSubscriber {
        public void connected();

        public Object getValue();
    }

    static class ConnectListener
    implements Runnable {
        private boolean mIsFinished = false;
        private final ConnectSubscriber mSubscriber;

        ConnectListener(ConnectSubscriber subscriber) {
            this.mSubscriber = subscriber;
        }

        public boolean isFinished() {
            return this.mIsFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectListener connectListener = this;
            synchronized (connectListener) {
                this.mSubscriber.connected();
                this.mIsFinished = true;
                this.notifyAll();
            }
        }
    }
}

