/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.player;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.daya.orchestra.accompany.helper.MusicFileDownloadHelper;
import com.daya.orchestra.accompany.player.BasePlayer;
import com.daya.orchestra.accompany.utils.ALOG;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.SimpleExoPlayer;
import java.io.File;

public class CustomExoPlayer
extends BasePlayer {
    public static final String TAG = "CustomExoPlayer";
    private ExoPlayer mExoPlayer;
    private boolean hasPrepared;
    private boolean isStoped = false;
    private boolean isNeedMute = false;
    private int prepareSeekPosition = -1;
    private boolean isSeekCompleted;
    private float speed = 1.0f;

    public CustomExoPlayer(Context context) {
        this.initPlayer(context);
    }

    private void initPlayer(Context context) {
        if (this.mExoPlayer == null) {
            DefaultLoadControl loadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(200000, 200000, 10000, 20000).build();
            this.mExoPlayer = new SimpleExoPlayer.Builder(context).setLoadControl((LoadControl)loadControl).build();
            this.mExoPlayer.addListener(new Player.Listener(){

                public void onPlaybackStateChanged(int playbackState) {
                    ALOG.i("onPlaybackStateChanged:" + playbackState);
                    if (playbackState == 4) {
                        if (CustomExoPlayer.this.onListener != null) {
                            CustomExoPlayer.this.onListener.onCompletion();
                        }
                    } else if (playbackState == 3) {
                        CustomExoPlayer.this.start();
                    }
                }

                public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
                    ALOG.i("oldPosition:" + oldPosition.positionMs);
                    ALOG.i("newPosition:" + newPosition.positionMs);
                }
            });
        }
    }

    @Override
    public void play(boolean isMute, float speed, String path) {
        this.hasPrepared = false;
        this.isStoped = false;
        this.isSeekCompleted = false;
        this.isNeedMute = isMute;
        try {
            MediaItem mediaItem = this.createMediaItem(path);
            this.mExoPlayer.setMediaItem(mediaItem);
            this.mExoPlayer.prepare();
            this.mExoPlayer.setPlayWhenReady(false);
            this.setVolume(this.isNeedMute ? 0.0f : 1.0f);
            this.setSpeed(speed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MediaItem createMediaItem(String path) {
        try {
            File file;
            String downloadSavePath = MusicFileDownloadHelper.getDownloadSavePath(path);
            if (!TextUtils.isEmpty((CharSequence)downloadSavePath) && (file = new File(downloadSavePath)).exists()) {
                ALOG.i("createMediaItem file:" + file.getAbsolutePath());
                MediaItem mediaItem = MediaItem.fromUri((Uri)Uri.fromFile((File)file));
                return mediaItem;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ALOG.i("createMediaItem next file:" + path);
        MediaItem mediaItem = MediaItem.fromUri((Uri)Uri.parse((String)path));
        return mediaItem;
    }

    private void start() {
        if (this.isStoped) {
            return;
        }
        if (null != this.mExoPlayer) {
            if (this.prepareSeekPosition > 0 && !this.isSeekCompleted) {
                this.seekTo(this.prepareSeekPosition);
            } else {
                this.mExoPlayer.play();
            }
        }
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
        this.mExoPlayer.setPlaybackSpeed(speed);
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    public void setVolume(float volume) {
        if (this.mExoPlayer != null) {
            ALOG.i("setVolume:" + volume + "hasPrepared:" + this.hasPrepared);
            this.mExoPlayer.setVolume(volume);
        }
    }

    @Override
    public void seekTo(int position) {
        if (null != this.mExoPlayer) {
            this.mExoPlayer.setSeekParameters(SeekParameters.PREVIOUS_SYNC);
            this.mExoPlayer.seekTo((long)position);
            this.isSeekCompleted = true;
        }
    }

    @Override
    public long getCu() {
        if (this.mExoPlayer != null) {
            long currentPosition = this.mExoPlayer.getCurrentPosition();
            long bufferedPosition = this.mExoPlayer.getBufferedPosition();
            Log.i((String)TAG, (String)("currentPosition:" + currentPosition));
            Log.i((String)TAG, (String)("bufferedPosition:" + bufferedPosition));
            return currentPosition;
        }
        return -1L;
    }

    @Override
    public long getT() {
        if (this.mExoPlayer != null) {
            long duration = this.mExoPlayer.getDuration();
            return duration;
        }
        return -1L;
    }

    @Override
    public void stop() {
        if (this.mExoPlayer == null) {
            return;
        }
        this.prepareSeekPosition = -1;
        this.isStoped = true;
        this.hasPrepared = false;
        Log.i((String)TAG, (String)("player to stop:" + this.hasPrepared + "-thread:" + Thread.currentThread().getName()));
        this.mExoPlayer.stop();
    }

    public int getPrepareSeekPosition() {
        return this.prepareSeekPosition;
    }

    public long getExceptTargetPos(long cu) {
        long targetPos = this.getPrepareSeekPosition() != -1 ? cu - (long)this.getPrepareSeekPosition() : cu;
        return targetPos;
    }

    public void setPrepareSeekPosition(int prepareSeekPosition) {
        this.prepareSeekPosition = prepareSeekPosition;
    }

    @Override
    public void release() {
        try {
            this.hasPrepared = false;
            this.isStoped = true;
            this.mExoPlayer.stop();
            this.mExoPlayer.release();
            this.mExoPlayer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

