/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vanniktech.emoji.EmojiInformation;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiRange;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmojiUtils {
    private static final Pattern SPACE_REMOVAL = Pattern.compile("[\\s]");

    public static boolean isOnlyEmojis(@Nullable CharSequence text) {
        if (text != null && text.length() > 0) {
            String inputWithoutSpaces = SPACE_REMOVAL.matcher(text).replaceAll(Matcher.quoteReplacement(""));
            return EmojiManager.getInstance().getEmojiRepetitivePattern().matcher(inputWithoutSpaces).matches();
        }
        return false;
    }

    @NonNull
    public static List<EmojiRange> emojis(@Nullable CharSequence text) {
        return EmojiManager.getInstance().findAllEmojis(text);
    }

    public static int emojisCount(@Nullable CharSequence text) {
        return EmojiUtils.emojis(text).size();
    }

    @NonNull
    public static EmojiInformation emojiInformation(@Nullable CharSequence text) {
        List<EmojiRange> emojis = EmojiManager.getInstance().findAllEmojis(text);
        boolean isOnlyEmojis = EmojiUtils.isOnlyEmojis(text);
        return new EmojiInformation(isOnlyEmojis, emojis);
    }

    private EmojiUtils() {
        throw new AssertionError((Object)"No instances.");
    }
}

