/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.custom;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import cn.rongcloud.rtc.custom.MediaVideoDecoder;
import cn.rongcloud.rtc.utils.FinLog;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaVideoDecoder16
extends MediaVideoDecoder {
    private static final String TAG = "MediaVideoDecoder16";
    private static final String MEDIA_FORMAT_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_STRIDE = "stride";
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList = new int[]{21, 19, 2141391872, 2130706688, 2141391876, 2141391875, 2141391874, 2141391873};
    private MediaExtractor extractor;
    private MediaCodec videoDecoder;
    private MediaFormat mVideoFormat = null;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mStride = 0;
    private int mSliceHeight = 0;
    private int mColorFormat = 0;
    private Thread mDecodeTask = new Thread("DecodeTask"){

        @Override
        public void run() {
            MediaVideoDecoder16.this.decode();
        }
    };

    @Override
    public boolean init(FileDescriptor fd, long offset, long len) {
        block8: {
            try {
                this.extractor = new MediaExtractor();
                this.extractor.setDataSource(fd, offset, len);
                int videoTrackIndex = this.selectVideoTrack(this.extractor);
                this.mVideoFormat = this.extractor.getTrackFormat(videoTrackIndex);
                String mimeType = this.mVideoFormat.getString("mime");
                DecoderProperties decoderProperties = this.findDecoder(mimeType);
                if (decoderProperties == null) {
                    return false;
                }
                this.mVideoFormat.setInteger("color-format", decoderProperties.colorFormat);
                this.mColorFormat = decoderProperties.colorFormat;
                this.mStride = this.mWidth = this.mVideoFormat.getInteger("width");
                this.mSliceHeight = this.mHeight = this.mVideoFormat.getInteger("height");
                this.videoDecoder = MediaCodec.createByCodecName((String)decoderProperties.name);
                this.videoDecoder.configure(this.mVideoFormat, null, null, 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.videoDecoder != null) {
                    try {
                        this.videoDecoder.release();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (this.extractor == null) break block8;
                try {
                    this.extractor.release();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return true;
    }

    private void decode() {
        this.videoDecoder.start();
        while (true) {
            MediaCodec.BufferInfo bufferInfo;
            int outputBufferIndex;
            ByteBuffer inputBuffer;
            int inputBufferIndex;
            if ((inputBufferIndex = this.videoDecoder.dequeueInputBuffer(0L)) >= 0 && (inputBuffer = this.videoDecoder.getInputBuffers()[inputBufferIndex]) != null) {
                inputBuffer.clear();
                int readSize = this.extractor.readSampleData(inputBuffer, 0);
                if (readSize >= 0) {
                    this.videoDecoder.queueInputBuffer(inputBufferIndex, 0, readSize, this.extractor.getSampleTime(), this.extractor.getSampleFlags());
                    this.extractor.advance();
                } else {
                    this.videoDecoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                }
            }
            if ((outputBufferIndex = this.videoDecoder.dequeueOutputBuffer(bufferInfo = new MediaCodec.BufferInfo(), 10000L)) < 0) {
                if (outputBufferIndex != -2) continue;
                MediaFormat format = this.videoDecoder.getOutputFormat();
                int sliceHeight = format.getInteger(MEDIA_FORMAT_SLICE_HEIGHT);
                int stride = format.getInteger(MEDIA_FORMAT_STRIDE);
                if (sliceHeight != 0) {
                    this.mSliceHeight = sliceHeight;
                }
                if (stride == 0) continue;
                this.mStride = stride;
                continue;
            }
            if ((bufferInfo.flags & 4) != 0) break;
            ByteBuffer outputBuffer = this.videoDecoder.getOutputBuffers()[outputBufferIndex];
            if (outputBuffer == null) continue;
            byte[] outBytes = new byte[outputBuffer.limit()];
            outputBuffer.get(outBytes);
            if (this.mOnFrameAvailableListener != null) {
                this.mOnFrameAvailableListener.onFrame(this.convert(outBytes), this.mStride, this.mSliceHeight, 0, bufferInfo.presentationTimeUs / 1000L);
            }
            this.videoDecoder.releaseOutputBuffer(outputBufferIndex, true);
        }
        try {
            this.videoDecoder.stop();
        }
        catch (Exception e) {
            FinLog.e(TAG, "Media Decoder stop failed" + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.videoDecoder.release();
        }
        catch (Exception e) {
            FinLog.e(TAG, "Media Decoder release failed" + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.extractor.release();
        }
        catch (Exception e) {
            FinLog.e(TAG, "VideoExtractor release failed" + e.getMessage());
            e.printStackTrace();
        }
    }

    private DecoderProperties findDecoder(String mime) {
        int codecCount = MediaCodecList.getCodecCount();
        for (int i = 0; i < codecCount; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo == null || codecInfo.isEncoder()) continue;
            String[] supportedTypes = codecInfo.getSupportedTypes();
            String codecName = null;
            for (String type : supportedTypes) {
                if (!type.equals(mime)) continue;
                codecName = codecInfo.getName();
                break;
            }
            if (codecName == null) continue;
            MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(mime);
            for (int format : capabilities.colorFormats) {
                Log.i((String)TAG, (String)("ColorFormat: " + Integer.toHexString(format)));
            }
            for (int colorFormat : capabilities.colorFormats) {
                for (int supportColorFormat : supportedColorList) {
                    if (colorFormat != supportColorFormat) continue;
                    return new DecoderProperties(codecName, colorFormat);
                }
            }
        }
        return null;
    }

    private byte[] convert(byte[] data) {
        if (this.mColorFormat == 19) {
            return this.I420ToNv21(data);
        }
        return this.Nv12ToNv21(data, this.mWidth, this.mHeight);
    }

    private byte[] Nv12ToNv21(byte[] nv12, int width, int height) {
        byte[] nv21 = new byte[width * height * 3 / 2];
        int frameSize = width * height;
        System.arraycopy(nv12, 0, nv21, 0, frameSize);
        int i = 0;
        for (i = 0; i < frameSize / 4; ++i) {
            nv21[frameSize + i * 2] = nv12[frameSize + i * 2 + 1];
            nv21[frameSize + i * 2 + 1] = nv12[frameSize + i * 2];
        }
        return nv21;
    }

    public byte[] I420ToNv21(byte[] data) {
        byte[] ret = new byte[data.length];
        int total = this.mWidth * this.mHeight;
        ByteBuffer bufferY = ByteBuffer.wrap(ret, 0, total);
        ByteBuffer bufferV = ByteBuffer.wrap(ret, total, total / 4);
        ByteBuffer bufferU = ByteBuffer.wrap(ret, total + total / 4, total / 4);
        bufferY.put(data, 0, total);
        for (int i = 0; i < total / 4; ++i) {
            bufferV.put(data[total + i]);
            bufferU.put(data[i + total + total / 4]);
        }
        return ret;
    }

    private byte[] I420ToNv21(byte[] data, int width, int height) {
        byte[] nv21 = new byte[data.length];
        int frameSize = width * height;
        int i = 0;
        System.arraycopy(data, 0, nv21, 0, frameSize);
        for (i = 0; i < frameSize / 2; i += 2) {
            nv21[frameSize + i] = data[frameSize + frameSize / 4 + i / 2];
            nv21[frameSize + i + 1] = data[frameSize + i / 2];
        }
        return nv21;
    }

    @Override
    public void start() {
        this.mDecodeTask.start();
    }

    @Override
    public void stop() {
    }

    @Override
    public void release() {
    }

    private class DecoderProperties {
        public String name;
        public int colorFormat;

        public DecoderProperties(String name, int colorFormat) {
            this.name = name;
            this.colorFormat = colorFormat;
        }
    }
}

