/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.common;

import com.daya.orchestra.accompany.api.DownloadApi;
import com.daya.orchestra.accompany.callback.ResultCallback;
import com.daya.orchestra.accompany.net.RetrofitClientNoToken;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import okhttp3.ResponseBody;

public class MidHelper {
    public static final String MID_STATUS_PLAY = "play";
    public static final String MID_STATUS_SUSPEND = "suspend";
    public static final int DOWNLOAD_MID_FAILED = 10001;

    private MidHelper() {
    }

    public static MidHelper getInstance() {
        return MidHelperHolder.mHelper;
    }

    public void startDownloadMidFile(String midiFile, final ResultCallback<ResponseBody> resultCallback) {
        ((DownloadApi)RetrofitClientNoToken.getInstance().getRetrofit().create(DownloadApi.class)).downloadFileWithFixedUrl(midiFile).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribeWith((Observer)new Observer<ResponseBody>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ResponseBody response) {
                if (resultCallback != null) {
                    resultCallback.onSuccess(response);
                }
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                if (resultCallback != null) {
                    resultCallback.onFail(10001, "\u4e0b\u8f7d\u5931\u8d25");
                }
            }

            public void onComplete() {
            }
        });
    }

    private static class MidHelperHolder {
        private static MidHelper mHelper = new MidHelper();

        private MidHelperHolder() {
        }
    }
}

