/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class NetworkUtil {
    public static final int NETWORKTYPE_INVALID = 0;
    public static final int NETWORKTYPE_WAP = 1;
    public static final int NETWORKTYPE_2G = 2;
    public static final int NETWORKTYPE_3G = 3;
    public static final int NETWORKTYPE_WIFI = 4;
    public static int mNetWorkType;

    private NetworkUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null) {
                NetworkInfo[] networkInfos;
                for (NetworkInfo networkInfo : networkInfos = connectivityManager.getAllNetworkInfo()) {
                    NetworkInfo.State state = networkInfo.getState();
                    if (state != NetworkInfo.State.CONNECTED) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean ping() {
        String result = null;
        try {
            String ip = "www.baidu.com";
            Process p = Runtime.getRuntime().exec("ping -c 3 -w 100 " + ip);
            InputStream input = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            StringBuffer stringBuffer = new StringBuffer();
            String content = "";
            while ((content = in.readLine()) != null) {
                stringBuffer.append(content);
            }
            Log.d((String)"------ping-----", (String)("result content : " + stringBuffer.toString()));
            int status = p.waitFor();
            if (status == 0) {
                result = "success";
                boolean bl = true;
                return bl;
            }
            result = "failed";
        }
        catch (IOException e) {
            result = "IOException";
        }
        catch (InterruptedException e) {
            result = "InterruptedException";
        }
        finally {
            Log.d((String)"----result---", (String)("result = " + result));
        }
        return false;
    }

    public static int getNetWorkType(Context context) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                String type = networkInfo.getTypeName();
                if (type.equalsIgnoreCase("WIFI")) {
                    mNetWorkType = 4;
                } else if (type.equalsIgnoreCase("MOBILE")) {
                    String proxyHost = Proxy.getDefaultHost();
                    mNetWorkType = TextUtils.isEmpty((CharSequence)proxyHost) ? (NetworkUtil.isFastMobileNetwork(context) ? 3 : 2) : 1;
                }
            } else {
                mNetWorkType = 0;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return mNetWorkType;
    }

    public static boolean isWifiNetwork(Context context) {
        int netWorkType = NetworkUtil.getNetWorkType(context);
        return netWorkType == 4;
    }

    public static boolean isFastMobileNetwork(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }
}

