/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.stat;

import android.os.Build;
import android.os.HandlerThread;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatForm;
import cn.rongcloud.rtc.stat.StatHandler;
import cn.rongcloud.rtc.utils.DeviceUtils;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import io.rong.imlib.RongCoreClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum RongRtcStatMagr {
    instance;

    public static final int WHAT_ADD_PUBLISH = 1;
    public static final int WHAT_REMOVE_PUBLISH = 2;
    public static final int WHAT_ADD_RECEIVE = 3;
    public static final int WHAT_REMOVE_RECEIVE = 4;
    public static final int WHAT_RELEASE = 5;
    private static final String TAG = "RongRtcStatMagr";
    private StatHandler mHandler;
    private String mRoomId;
    private RTCConnectionHolder mConnectionHolder;
    private RCRTCLiveRole mRole;

    public void addPublish(List<RongRtcStatForm> statForms) {
        this.sendMsg(1, statForms);
    }

    public void addReceive(List<RongRtcStatForm> statForms) {
        this.sendMsg(3, statForms);
    }

    public void removePublish(List<String> trackIds) {
        this.sendMsg(2, trackIds);
    }

    public void removeReceive(List<String> trackIds) {
        this.sendMsg(4, trackIds);
    }

    public String getRoomId() {
        return this.mRoomId;
    }

    public void start(String roomId, RCRTCLiveRole role) {
        this.mRoomId = roomId;
        this.mRole = role;
        if (!TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            this.reportR1();
        }
    }

    public void setRTCConnectionHolder(RTCConnectionHolder connectionHolder) {
        this.mConnectionHolder = connectionHolder;
        if (this.mHandler != null) {
            this.mHandler.setRTCConnectionHolder(connectionHolder);
        }
    }

    public void release() {
        if (this.mHandler != null) {
            this.mHandler.sendEmptyMessage(5);
            this.mHandler.getLooper().quitSafely();
        }
        this.mHandler = null;
        this.mRoomId = null;
        this.mConnectionHolder = null;
    }

    private void sendMsg(int what, Object obj) {
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            FinLog.e(TAG, "sendMsg RoomId is Null, what=" + what);
            return;
        }
        if (this.mHandler == null) {
            HandlerThread handlerThread = new HandlerThread(TAG);
            handlerThread.start();
            this.mHandler = new StatHandler(handlerThread.getLooper(), this.mRoomId, this.mRole);
            if (this.mConnectionHolder != null) {
                this.mHandler.setRTCConnectionHolder(this.mConnectionHolder);
            }
        }
        this.mHandler.obtainMessage(what, obj).sendToTarget();
    }

    public void reportR1() {
        String imVer;
        try {
            imVer = RongCoreClient.getVersion();
        }
        catch (NoSuchMethodError e) {
            imVer = "5.2.4";
        }
        String versionStr = "R1\t" + RCRTCEngine.getVersion() + "\t" + imVer + "\tAndroid\t" + Build.BRAND + DeviceUtils.getBuildModel() + "\t" + Build.VERSION.RELEASE + "\t" + -1 + "\t" + -1 + "\t" + RTCEngineImpl.getInstance().getClientId() + "\t" + this.mRole.getType();
        this.setRTCUserState(versionStr);
    }

    public void reportSubscribe(Map<MediaStream, MediaStreamTrack> streamMap) {
        if (streamMap == null || streamMap.isEmpty()) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(streamMap.size());
        Set<MediaStream> keys = streamMap.keySet();
        ArrayList<RongRtcStatForm> forms = new ArrayList<RongRtcStatForm>();
        for (MediaStream key : keys) {
            RongRtcStatForm form = new RongRtcStatForm(streamMap.get(key).id(), key.getId(), RCRTCMediaType.VIDEO.getDescription().equalsIgnoreCase(streamMap.get(key).kind()) ? RCRTCMediaType.VIDEO : RCRTCMediaType.AUDIO);
            forms.add(form);
            ids.add(form.trackId);
        }
        this.onReportR2(true, true, ids);
        this.addReceive(forms);
    }

    public void reportSubStream(String trackId, String streamId, RCRTCMediaType mediaType) {
        RongRtcStatForm form = new RongRtcStatForm(trackId, streamId, mediaType);
        ArrayList<RongRtcStatForm> forms = new ArrayList<RongRtcStatForm>();
        forms.add(form);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(trackId);
        this.onReportR2(true, true, ids);
        this.addReceive(forms);
    }

    public void reportSubscribe(List<RongRtcStatForm> statForms) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RongRtcStatForm form : statForms) {
            ids.add(form.trackId);
        }
        this.onReportR2(true, true, ids);
        this.addReceive(statForms);
    }

    public void reportUnSubscribe(List<? extends IStreamResource> streams) {
        List<String> trackIds = this.parseRongRTCStream(true, false, streams);
        if (trackIds != null) {
            this.removeReceive(trackIds);
        }
    }

    public void reportPublish(boolean isBegin, List<? extends IStreamResource> streams) {
        List<String> trackIds = this.parseRongRTCStream(false, isBegin, streams);
        if (trackIds != null) {
            if (isBegin) {
                ArrayList<RongRtcStatForm> forms = new ArrayList<RongRtcStatForm>();
                for (IStreamResource iStreamResource : streams) {
                    forms.add(new RongRtcStatForm(iStreamResource.getStreamId(), iStreamResource.getMediaType()));
                }
                this.addPublish(forms);
            } else {
                this.removePublish(trackIds);
            }
        }
    }

    private List<String> parseRongRTCStream(boolean isSubscribe, boolean isBegin, List<? extends IStreamResource> streams) {
        if (streams == null || streams.isEmpty()) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (IStreamResource iStreamResource : streams) {
            ids.add(iStreamResource.getStreamId() + "_" + iStreamResource.getMediaType().getDescription());
        }
        this.onReportR2(isSubscribe, isBegin, ids);
        return ids;
    }

    private void onReportR2(boolean isSubscribe, boolean isBegin, List<String> trackIds) {
        if (trackIds == null || trackIds.isEmpty()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mRoomId)) {
            FinLog.e(TAG, "reportR2 RoomId is Null");
            return;
        }
        StringBuilder val = new StringBuilder();
        val.append("R2").append("\t").append(isSubscribe ? "subscribe" : "publish").append("\t").append(isBegin ? "begin" : "end").append("\r");
        for (String trackId : trackIds) {
            val.append(trackId).append("\t");
        }
        val.deleteCharAt(val.length() - 1);
        val.append("\r").append(this.mRole.getType());
        this.setRTCUserState(val.toString());
    }

    private void setRTCUserState(String val) {
        SignalManager.getInstance().setRTCUserState(this.mRoomId, val, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e(RongRtcStatMagr.TAG, "setRTCUserState Failed: " + errorCode.getValue());
            }
        });
    }
}

