/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import com.liulishuo.filedownloader.connection.DefaultConnectionCountAdapter;
import com.liulishuo.filedownloader.connection.FileDownloadUrlConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.database.RemitDatabase;
import com.liulishuo.filedownloader.services.DefaultIdGenerator;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.stream.FileDownloadRandomAccessFile;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;

public class DownloadMgrInitialParams {
    private final InitCustomMaker mMaker;

    public DownloadMgrInitialParams() {
        this.mMaker = null;
    }

    public DownloadMgrInitialParams(InitCustomMaker maker) {
        this.mMaker = maker;
    }

    public int getMaxNetworkThreadCount() {
        if (this.mMaker == null) {
            return this.getDefaultMaxNetworkThreadCount();
        }
        Integer customizeMaxNetworkThreadCount = this.mMaker.mMaxNetworkThreadCount;
        if (customizeMaxNetworkThreadCount != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize maxNetworkThreadCount: %d", customizeMaxNetworkThreadCount);
            }
            return FileDownloadProperties.getValidNetworkThreadCount(customizeMaxNetworkThreadCount);
        }
        return this.getDefaultMaxNetworkThreadCount();
    }

    public FileDownloadDatabase createDatabase() {
        if (this.mMaker == null || this.mMaker.mDatabaseCustomMaker == null) {
            return this.createDefaultDatabase();
        }
        FileDownloadDatabase customDatabase = this.mMaker.mDatabaseCustomMaker.customMake();
        if (customDatabase != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize database: %s", customDatabase);
            }
            return customDatabase;
        }
        return this.createDefaultDatabase();
    }

    public FileDownloadHelper.OutputStreamCreator createOutputStreamCreator() {
        if (this.mMaker == null) {
            return this.createDefaultOutputStreamCreator();
        }
        FileDownloadHelper.OutputStreamCreator outputStreamCreator = this.mMaker.mOutputStreamCreator;
        if (outputStreamCreator != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize output stream: %s", outputStreamCreator);
            }
            return outputStreamCreator;
        }
        return this.createDefaultOutputStreamCreator();
    }

    public FileDownloadHelper.ConnectionCreator createConnectionCreator() {
        if (this.mMaker == null) {
            return this.createDefaultConnectionCreator();
        }
        FileDownloadHelper.ConnectionCreator connectionCreator = this.mMaker.mConnectionCreator;
        if (connectionCreator != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize connection creator: %s", connectionCreator);
            }
            return connectionCreator;
        }
        return this.createDefaultConnectionCreator();
    }

    public FileDownloadHelper.ConnectionCountAdapter createConnectionCountAdapter() {
        if (this.mMaker == null) {
            return this.createDefaultConnectionCountAdapter();
        }
        FileDownloadHelper.ConnectionCountAdapter adapter = this.mMaker.mConnectionCountAdapter;
        if (adapter != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize connection count adapter: %s", adapter);
            }
            return adapter;
        }
        return this.createDefaultConnectionCountAdapter();
    }

    public FileDownloadHelper.IdGenerator createIdGenerator() {
        if (this.mMaker == null) {
            return this.createDefaultIdGenerator();
        }
        FileDownloadHelper.IdGenerator idGenerator = this.mMaker.mIdGenerator;
        if (idGenerator != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize id generator: %s", idGenerator);
            }
            return idGenerator;
        }
        return this.createDefaultIdGenerator();
    }

    public ForegroundServiceConfig createForegroundServiceConfig() {
        if (this.mMaker == null) {
            return this.createDefaultForegroundServiceConfig();
        }
        ForegroundServiceConfig foregroundServiceConfig = this.mMaker.mForegroundServiceConfig;
        if (foregroundServiceConfig != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize foreground service config: %s", foregroundServiceConfig);
            }
            return foregroundServiceConfig;
        }
        return this.createDefaultForegroundServiceConfig();
    }

    private ForegroundServiceConfig createDefaultForegroundServiceConfig() {
        return new ForegroundServiceConfig.Builder().needRecreateChannelId(true).build();
    }

    private FileDownloadHelper.IdGenerator createDefaultIdGenerator() {
        return new DefaultIdGenerator();
    }

    private int getDefaultMaxNetworkThreadCount() {
        return FileDownloadProperties.getImpl().downloadMaxNetworkThreadCount;
    }

    private FileDownloadDatabase createDefaultDatabase() {
        return new RemitDatabase();
    }

    private FileDownloadHelper.OutputStreamCreator createDefaultOutputStreamCreator() {
        return new FileDownloadRandomAccessFile.Creator();
    }

    private FileDownloadHelper.ConnectionCreator createDefaultConnectionCreator() {
        return new FileDownloadUrlConnection.Creator();
    }

    private FileDownloadHelper.ConnectionCountAdapter createDefaultConnectionCountAdapter() {
        return new DefaultConnectionCountAdapter();
    }

    public static class InitCustomMaker {
        FileDownloadHelper.DatabaseCustomMaker mDatabaseCustomMaker;
        Integer mMaxNetworkThreadCount;
        FileDownloadHelper.OutputStreamCreator mOutputStreamCreator;
        FileDownloadHelper.ConnectionCreator mConnectionCreator;
        FileDownloadHelper.ConnectionCountAdapter mConnectionCountAdapter;
        FileDownloadHelper.IdGenerator mIdGenerator;
        ForegroundServiceConfig mForegroundServiceConfig;

        public InitCustomMaker idGenerator(FileDownloadHelper.IdGenerator idGenerator) {
            this.mIdGenerator = idGenerator;
            return this;
        }

        public InitCustomMaker connectionCountAdapter(FileDownloadHelper.ConnectionCountAdapter adapter) {
            this.mConnectionCountAdapter = adapter;
            return this;
        }

        public InitCustomMaker database(FileDownloadHelper.DatabaseCustomMaker maker) {
            this.mDatabaseCustomMaker = maker;
            return this;
        }

        public InitCustomMaker maxNetworkThreadCount(int maxNetworkThreadCount) {
            if (maxNetworkThreadCount > 0) {
                this.mMaxNetworkThreadCount = maxNetworkThreadCount;
            }
            return this;
        }

        public InitCustomMaker outputStreamCreator(FileDownloadHelper.OutputStreamCreator creator) {
            this.mOutputStreamCreator = creator;
            if (this.mOutputStreamCreator != null && !this.mOutputStreamCreator.supportSeek() && !FileDownloadProperties.getImpl().fileNonPreAllocation) {
                throw new IllegalArgumentException("Since the provided FileDownloadOutputStream does not support the seek function, if FileDownloader pre-allocates file size at the beginning of the download, it will can not be resumed from the breakpoint. If you need to ensure that the resumption is available, please add and set the value of 'file.non-pre-allocation' field to 'true' in the 'filedownloader.properties' file which is in your application assets folder manually for resolving this problem.");
            }
            return this;
        }

        public InitCustomMaker connectionCreator(FileDownloadHelper.ConnectionCreator creator) {
            this.mConnectionCreator = creator;
            return this;
        }

        public InitCustomMaker foregroundServiceConfig(ForegroundServiceConfig config) {
            this.mForegroundServiceConfig = config;
            return this;
        }

        public void commit() {
        }

        public String toString() {
            return FileDownloadUtils.formatString("component: database[%s], maxNetworkCount[%s], outputStream[%s], connection[%s], connectionCountAdapter[%s]", this.mDatabaseCustomMaker, this.mMaxNetworkThreadCount, this.mOutputStreamCreator, this.mConnectionCreator, this.mConnectionCountAdapter);
        }
    }
}

