/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.recorder;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.Looper;
import com.daya.orchestra.accompany.recorder.AudioChunk;
import com.daya.orchestra.accompany.utils.ALOG;
import java.io.IOException;
import java.io.OutputStream;

public interface PullTransport {
    public void isEnableToBePulled(boolean var1);

    public void startPoolingAndWriting(AudioRecord var1, int var2, OutputStream var3) throws IOException;

    public static class Noise
    extends AbstractPullTransport {
        private OnSilenceListener onSilenceListener;
        private long pushTimeThreshold = 500L;
        private long silenceTimeThreshold = 200L;
        private long startSilenceMoment = 0L;
        private long silenceTime = 0L;
        private int writeCountAfterSilence = 0;

        public Noise setOnAudioChunkPulledListener(OnAudioChunkPulledListener onAudioChunkPulledListener) {
            this.onAudioChunkPulledListener = onAudioChunkPulledListener;
            return this;
        }

        public Noise setOnSilenceListener(OnSilenceListener onSilenceListener) {
            this.onSilenceListener = onSilenceListener;
            return this;
        }

        public Noise setSilenceTimeThreshold(long silenceTimeThreshold) {
            this.silenceTimeThreshold = silenceTimeThreshold;
            return this;
        }

        public Noise setPushTimeThreshold(long pushTimeThreshold) {
            this.pushTimeThreshold = pushTimeThreshold;
            return this;
        }

        @Override
        public void startPoolingAndWriting(AudioRecord audioRecord, int pullSizeInBytes, OutputStream outputStream) throws IOException {
            AudioChunk.Shorts audioChunk = new AudioChunk.Shorts(new short[pullSizeInBytes]);
            while (this.pull) {
                int count = audioRecord.read(audioChunk.toShorts(), 0, pullSizeInBytes);
                if (-3 == count || -2 == count) continue;
                this.postPullEvent(audioChunk);
                ALOG.i("\u63a5\u6536\u97f3\u9891\u6570\u636e", "startPoolingAndWriting2: " + audioChunk);
                if (audioChunk.isOverSilence()) {
                    outputStream.write(audioChunk.toBytes());
                    ++this.writeCountAfterSilence;
                    if (this.silenceTime > this.pushTimeThreshold && this.writeCountAfterSilence >= 3) {
                        this.writeCountAfterSilence = 0;
                        this.postSilenceEvent(this.silenceTime, this.silenceTime - this.silenceTimeThreshold);
                    }
                    this.startSilenceMoment = 0L;
                    this.silenceTime = 0L;
                    continue;
                }
                if (this.startSilenceMoment == 0L) {
                    this.startSilenceMoment = System.currentTimeMillis();
                }
                this.silenceTime = System.currentTimeMillis() - this.startSilenceMoment;
                if (this.silenceTime >= this.silenceTimeThreshold) continue;
                outputStream.write(audioChunk.toBytes());
            }
        }

        private void postSilenceEvent(final long silenceTime, final long discardTime) {
            if (this.onSilenceListener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        onSilenceListener.onSilence(silenceTime, discardTime);
                    }
                });
            }
        }
    }

    public static class Default
    extends AbstractPullTransport {
        public Default setOnAudioChunkPulledListener(OnAudioChunkPulledListener onAudioChunkPulledListener) {
            this.onAudioChunkPulledListener = onAudioChunkPulledListener;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startPoolingAndWriting(AudioRecord audioRecord, int pullSizeInBytes, OutputStream outputStream) throws IOException {
            ALOG.d("\u63a5\u6536\u97f3\u9891\u6570\u636e", "startPoolingAndWriting() called with: audioRecord = [" + audioRecord + "], pullSizeInBytes = [" + pullSizeInBytes + "], outputStream = [" + outputStream + "]");
            ALOG.i("\u63a5\u6536\u97f3\u9891\u6570\u636e", "startPoolingAndWriting byte: " + new byte[pullSizeInBytes]);
            AudioChunk.Bytes audioChunk = new AudioChunk.Bytes(new byte[pullSizeInBytes]);
            try {
                while (this.pull) {
                    int count = audioRecord.read(audioChunk.toBytes(), 0, pullSizeInBytes);
                    if (-3 == count || -2 == count) continue;
                    this.postPullEvent(audioChunk);
                    ALOG.i("\u63a5\u6536\u97f3\u9891\u6570\u636e", "startPoolingAndWriting: " + audioChunk.toBytes().toString());
                    outputStream.write(audioChunk.toBytes());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static abstract class AbstractPullTransport
    implements PullTransport {
        volatile boolean pull;
        OnAudioChunkPulledListener onAudioChunkPulledListener;
        Handler handler = new Handler(Looper.getMainLooper());

        AbstractPullTransport() {
        }

        @Override
        public void isEnableToBePulled(boolean enabledToBePulled) {
            this.pull = enabledToBePulled;
        }

        void postPullEvent(final AudioChunk audioChunk) {
            if (this.onAudioChunkPulledListener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        onAudioChunkPulledListener.onAudioChunkPulled(audioChunk);
                    }
                });
            }
        }
    }

    public static interface OnAudioChunkPulledListener {
        public void onAudioChunkPulled(AudioChunk var1);
    }

    public static interface OnSilenceListener {
        public void onSilence(long var1, long var3);
    }
}

