/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.utils;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.EncryptUtils;
import com.daya.orchestra.accompany.utils.StringUtils;
import com.daya.orchestra.accompany.utils.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.ResponseBody;

public class MyFileUtils {
    private static final String TAG = "FileUtil";
    private static final String filesDirectory = MyFileUtils.getCacheDir((Context)Utils.getApp()) + File.separator + "public";
    public static final String examDownloadDirectory = "examDownload";
    public static final String MP3_FILE_SUFFIX = ".mp3";
    public static final String MP4_FILE_SUFFIX = ".mp4";
    public static final String WAV_FILE_SUFFIX = ".wav";
    public static final String DOCUMENTS_DIR = "documents";

    public static String getCacheDir(Context context) {
        String cacheDir = context.getExternalCacheDir().getAbsolutePath();
        return cacheDir;
    }

    public static String getCacheDir(Context context, String directory) {
        try {
            File file = new File(context.getExternalCacheDir() + File.separator + directory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileDir = file.getAbsolutePath();
            return fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getCacheDir2(Context context, String directory) {
        try {
            File file = new File(context.getCacheDir() + File.separator + directory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileDir = file.getAbsolutePath();
            return fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getFilesDir(Context context) {
        try {
            File file = context.getExternalFilesDir(filesDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileDir = file.getAbsolutePath();
            return fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getFilesDir(Context context, String directory) {
        try {
            File file = context.getExternalFilesDir(filesDirectory + File.separator + directory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileDir = file.getAbsolutePath();
            return fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPublicDirectory(String path) {
        String fileDir = null;
        try {
            File file = new File(filesDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            fileDir = file.getAbsolutePath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File filePath = new File(file.getPath() + File.separator + path);
                if (!filePath.exists()) {
                    filePath.mkdirs();
                }
                fileDir = filePath.getAbsolutePath();
            }
            return fileDir;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getPublicDirectoryDownload() {
        try {
            File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<String> getFilesAllName(String path) {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files == null) {
            Log.e((String)"error", (String)"\u7a7a\u76ee\u5f55");
            return null;
        }
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            s.add(files[i].getAbsolutePath());
        }
        return s;
    }

    public static boolean isImg(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            int lastDot = file.getName().lastIndexOf(".");
            if (lastDot < 0) {
                return false;
            }
            String fileType = MyFileUtils.getFileType(file.getName(), lastDot);
            return TextUtils.equals((CharSequence)"file_image", (CharSequence)fileType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getBase64Type(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        String type = "";
        switch (str) {
            case "data:application/msword;base64": {
                type = "doc";
            }
            case "data:application/vnd.openxmlformats-officedocument.wordprocessingml.document;base64": {
                type = "docx";
            }
            case "data:application/vnd.ms-excel;base64": {
                type = "xls";
            }
            case "data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64": {
                type = "xlsx";
            }
            case "data:application/pdf;base64": {
                type = "pdf";
            }
            case "data:application/vnd.ms-powerpoint;base64": {
                type = "ppt";
            }
            case "data:application/vnd.openxmlformats-officedocument.presentationml.presentation;base64": {
                type = "pptx";
            }
            case "data:text/plain;base64": {
                type = "txt";
            }
            case "data:image/png;base64": {
                type = "png";
            }
            case "data:image/jpeg;base64": {
                type = "jpg";
            }
        }
        return type;
    }

    public static boolean saveVideoToGallery(Context context, String filePath) {
        if (Build.VERSION.SDK_INT < 29) {
            return MyFileUtils.saveVideoToAlbumBeforeQ(context, filePath);
        }
        return MyFileUtils.saveVideoToAlbumAfterQ(context, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveVideoToAlbumBeforeQ(Context context, String videoFile) {
        File picDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        File tempFile = new File(videoFile);
        File destFile = new File(picDir, context.getPackageName() + File.separator + tempFile.getName());
        FileInputStream ins = null;
        FilterOutputStream ous = null;
        try {
            int n;
            ins = new FileInputStream(tempFile);
            ous = new BufferedOutputStream(new FileOutputStream(destFile));
            long nread = 0L;
            byte[] buf = new byte[1024];
            while ((n = ins.read(buf)) > 0) {
                ((BufferedOutputStream)ous).write(buf, 0, n);
                nread += (long)n;
            }
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{destFile.getAbsolutePath()}, (String[])new String[]{"video/*"}, (path, uri) -> {});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
                if (ous != null) {
                    ous.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean saveVideoToAlbumAfterQ(Context context, String videoFile) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            File tempFile = new File(videoFile);
            ContentValues contentValues = MyFileUtils.getVideoContentValues(context, tempFile, System.currentTimeMillis());
            Uri uri = contentResolver.insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues);
            MyFileUtils.copyFileAfterQ(context, contentResolver, tempFile, uri);
            contentValues.clear();
            contentValues.put("is_pending", Integer.valueOf(0));
            context.getContentResolver().update(uri, contentValues, null, null);
            context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ContentValues getVideoContentValues(Context context, File paramFile, long timestamp) {
        ContentValues localContentValues = new ContentValues();
        if (Build.VERSION.SDK_INT >= 29) {
            localContentValues.put("relative_path", Environment.DIRECTORY_DCIM + File.separator + context.getPackageName());
        }
        localContentValues.put("title", paramFile.getName());
        localContentValues.put("_display_name", paramFile.getName());
        localContentValues.put("mime_type", "video/mp4");
        localContentValues.put("datetaken", Long.valueOf(timestamp));
        localContentValues.put("date_modified", Long.valueOf(timestamp));
        localContentValues.put("date_added", Long.valueOf(timestamp));
        localContentValues.put("_size", Long.valueOf(paramFile.length()));
        return localContentValues;
    }

    private static void copyFileAfterQ(Context context, ContentResolver localContentResolver, File tempFile, Uri localUri) throws IOException {
        if (Build.VERSION.SDK_INT >= 29 && context.getApplicationInfo().targetSdkVersion >= 29) {
            OutputStream os = localContentResolver.openOutputStream(localUri);
            Files.copy(tempFile.toPath(), os);
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileFromSdcard(String filename) {
        ByteArrayOutputStream outputStream = null;
        FileInputStream fis = null;
        try {
            outputStream = new ByteArrayOutputStream();
            File file = new File(Environment.getExternalStorageDirectory(), filename);
            if ("mounted".equals(Environment.getExternalStorageState())) {
                fis = new FileInputStream(file);
                int len = 0;
                byte[] data = new byte[1024];
                while ((len = fis.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return new String(outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContentToSdcard(String filename, String content) {
        boolean flag;
        FileOutputStream fos = null;
        content = content + "\r\n";
        try {
            File file = new File(filename);
            if (file.exists()) {
                file.mkdirs();
            }
            fos = new FileOutputStream(file, true);
            fos.write(content.getBytes());
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return flag;
    }

    public static boolean saveFileToSdcard(String mPath, InputStream inputStream) {
        byte[] mData = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            byte[] bytes = new byte[1024];
            while ((len = inputStream.read(bytes)) != -1) {
                baos.write(bytes, 0, len);
            }
            mData = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(mPath));
            fos.write(mData, 0, mData.length);
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static long getFileSizes(File f) {
        long size = 0L;
        try {
            if (f.exists()) {
                FileInputStream fis = null;
                fis = new FileInputStream(f);
                size = fis.available();
            } else {
                f.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public static long getFileSize(File dir) throws Exception {
        long size = 0L;
        File[] flist = dir.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += MyFileUtils.getFileSize(flist[i]);
                continue;
            }
            size += flist[i].length();
        }
        return size;
    }

    public static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static long getlist(File f) {
        long size = 0L;
        File[] flist = f.listFiles();
        size = flist.length;
        for (int i = 0; i < flist.length; ++i) {
            if (!flist[i].isDirectory()) continue;
            size += MyFileUtils.getlist(flist[i]);
            --size;
        }
        return size;
    }

    public static String searchFile(String keyword) {
        File[] files;
        String result = "";
        for (File file : files = new File("/").listFiles()) {
            if (file.getName().indexOf(keyword) < 0) continue;
            result = result + file.getPath() + "\n";
        }
        if (result.equals("")) {
            result = "\u627e\u4e0d\u5230\u6587\u4ef6!!";
        }
        return result;
    }

    public static List<String> search(File file, String[] ext) {
        ArrayList<String> list;
        block2: {
            block3: {
                list = new ArrayList<String>();
                if (file == null) break block2;
                if (!file.isDirectory()) break block3;
                File[] listFile = file.listFiles();
                if (listFile == null) break block2;
                for (int i = 0; i < listFile.length; ++i) {
                    MyFileUtils.search(listFile[i], ext);
                }
                break block2;
            }
            String filename = file.getAbsolutePath();
            for (int i = 0; i < ext.length; ++i) {
                if (!filename.endsWith(ext[i])) continue;
                list.add(filename);
                break;
            }
        }
        return list;
    }

    public static List<File> FindFile(File file, String keyword) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File tempf : files) {
                if (tempf.isDirectory()) {
                    if (tempf.getName().toLowerCase().lastIndexOf(keyword) > -1) {
                        list.add(tempf);
                    }
                    list.addAll(MyFileUtils.FindFile(tempf, keyword));
                    continue;
                }
                if (tempf.getName().toLowerCase().lastIndexOf(keyword) <= -1) continue;
                list.add(tempf);
            }
        }
        return list;
    }

    public static List<Map<String, Object>> searchFile(Context context, String keyword, File filepath) {
        File[] files;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> rowItem = null;
        int index = 0;
        if (Environment.getExternalStorageState().equals("mounted") && (files = filepath.listFiles()).length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (file.getName().toLowerCase().lastIndexOf(keyword) > -1) {
                        rowItem = new HashMap<String, Object>();
                        rowItem.put("number", index);
                        rowItem.put("fileName", file.getName());
                        rowItem.put("path", file.getPath());
                        rowItem.put("size", file.length() + "");
                        list.add(rowItem);
                    }
                    if (!file.canRead()) continue;
                    list.addAll(MyFileUtils.searchFile(context, keyword, file));
                    continue;
                }
                try {
                    if (file.getName().indexOf(keyword) <= -1 && file.getName().indexOf(keyword.toUpperCase()) <= -1) continue;
                    rowItem = new HashMap();
                    rowItem.put("number", index);
                    rowItem.put("fileName", file.getName());
                    rowItem.put("path", file.getPath());
                    rowItem.put("size", file.length() + "");
                    list.add(rowItem);
                    ++index;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public static String getFileType(String fileName, int pointIndex) {
        String type = fileName.substring(pointIndex + 1).toLowerCase();
        type = "m4a".equalsIgnoreCase(type) || "xmf".equalsIgnoreCase(type) || "ogg".equalsIgnoreCase(type) || "wav".equalsIgnoreCase(type) || "m4a".equalsIgnoreCase(type) || "aiff".equalsIgnoreCase(type) || "midi".equalsIgnoreCase(type) || "vqf".equalsIgnoreCase(type) || "aac".equalsIgnoreCase(type) || "flac".equalsIgnoreCase(type) || "tak".equalsIgnoreCase(type) || "wv".equalsIgnoreCase(type) ? "file_audio" : ("mp3".equalsIgnoreCase(type) || "mid".equalsIgnoreCase(type) ? "file_mp3" : ("avi".equalsIgnoreCase(type) || "mp4".equalsIgnoreCase(type) || "dvd".equalsIgnoreCase(type) || "mid".equalsIgnoreCase(type) || "mov".equalsIgnoreCase(type) || "mkv".equalsIgnoreCase(type) || "mp2v".equalsIgnoreCase(type) || "mpe".equalsIgnoreCase(type) || "mpeg".equalsIgnoreCase(type) || "mpg".equalsIgnoreCase(type) || "asx".equalsIgnoreCase(type) || "asf".equalsIgnoreCase(type) || "flv".equalsIgnoreCase(type) || "navi".equalsIgnoreCase(type) || "divx".equalsIgnoreCase(type) || "rm".equalsIgnoreCase(type) || "rmvb".equalsIgnoreCase(type) || "dat".equalsIgnoreCase(type) || "mpa".equalsIgnoreCase(type) || "vob".equalsIgnoreCase(type) || "3gp".equalsIgnoreCase(type) || "swf".equalsIgnoreCase(type) || "wmv".equalsIgnoreCase(type) ? "file_video" : ("bmp".equalsIgnoreCase(type) || "pcx".equalsIgnoreCase(type) || "tiff".equalsIgnoreCase(type) || "gif".equalsIgnoreCase(type) || "jpeg".equalsIgnoreCase(type) || "tga".equalsIgnoreCase(type) || "exif".equalsIgnoreCase(type) || "fpx".equalsIgnoreCase(type) || "psd".equalsIgnoreCase(type) || "cdr".equalsIgnoreCase(type) || "raw".equalsIgnoreCase(type) || "eps".equalsIgnoreCase(type) || "gif".equalsIgnoreCase(type) || "jpg".equalsIgnoreCase(type) || "jpeg".equalsIgnoreCase(type) || "png".equalsIgnoreCase(type) || "hdri".equalsIgnoreCase(type) || "ai".equalsIgnoreCase(type) ? "file_image" : ("ppt".equalsIgnoreCase(type) || "doc".equalsIgnoreCase(type) || "xls".equalsIgnoreCase(type) || "pps".equalsIgnoreCase(type) || "xlsx".equalsIgnoreCase(type) || "xlsm".equalsIgnoreCase(type) || "pptx".equalsIgnoreCase(type) || "pptm".equalsIgnoreCase(type) || "ppsx".equalsIgnoreCase(type) || "maw".equalsIgnoreCase(type) || "mdb".equalsIgnoreCase(type) || "pot".equalsIgnoreCase(type) || "msg".equalsIgnoreCase(type) || "oft".equalsIgnoreCase(type) || "xlw".equalsIgnoreCase(type) || "wps".equalsIgnoreCase(type) || "rtf".equalsIgnoreCase(type) || "ppsm".equalsIgnoreCase(type) || "potx".equalsIgnoreCase(type) || "potm".equalsIgnoreCase(type) || "ppam".equalsIgnoreCase(type) ? "ic_file_office" : ("txt".equalsIgnoreCase(type) || "text".equalsIgnoreCase(type) || "chm".equalsIgnoreCase(type) || "hlp".equalsIgnoreCase(type) || "pdf".equalsIgnoreCase(type) || "doc".equalsIgnoreCase(type) || "docx".equalsIgnoreCase(type) || "docm".equalsIgnoreCase(type) || "dotx".equalsIgnoreCase(type) ? "file_text" : ("ini".equalsIgnoreCase(type) || "sys".equalsIgnoreCase(type) || "dll".equalsIgnoreCase(type) || "adt".equalsIgnoreCase(type) ? "file_system" : ("rar".equalsIgnoreCase(type) || "zip".equalsIgnoreCase(type) || "arj".equalsIgnoreCase(type) || "gz".equalsIgnoreCase(type) || "z".equalsIgnoreCase(type) || "7Z".equalsIgnoreCase(type) || "GZ".equalsIgnoreCase(type) || "BZ".equalsIgnoreCase(type) || "ZPAQ".equalsIgnoreCase(type) ? "ic_file_rar" : ("html".equalsIgnoreCase(type) || "htm".equalsIgnoreCase(type) || "java".equalsIgnoreCase(type) || "php".equalsIgnoreCase(type) || "asp".equalsIgnoreCase(type) || "aspx".equalsIgnoreCase(type) || "jsp".equalsIgnoreCase(type) || "shtml".equalsIgnoreCase(type) || "xml".equalsIgnoreCase(type) ? "file_web" : ("exe".equalsIgnoreCase(type) || "com".equalsIgnoreCase(type) || "bat".equalsIgnoreCase(type) || "iso".equalsIgnoreCase(type) || "msi".equalsIgnoreCase(type) ? "file_exe" : ("apk".equalsIgnoreCase(type) ? "ic_file_apk" : "ic_file_normal"))))))))));
        return type;
    }

    public static String changeFileSize(String size) {
        size = Integer.parseInt(size) > 1024 ? Integer.parseInt(size) / 1024 + "K" : (Integer.parseInt(size) > 0x100000 ? Integer.parseInt(size) / 0x100000 + "M" : (Integer.parseInt(size) > 0x40000000 ? Integer.parseInt(size) / 0x40000000 + "G" : size + "B"));
        return size;
    }

    public static ArrayList<File> getAllFiles(File dir) {
        ArrayList<File> allFiles = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            allFiles.add(file);
            if (!file.isDirectory()) continue;
            MyFileUtils.getAllFiles(file);
        }
        return allFiles;
    }

    public static String getMIMEType(File f) {
        String type = "";
        String fName = f.getName();
        String end = fName.substring(fName.lastIndexOf(".") + 1, fName.length()).toLowerCase();
        type = end.equalsIgnoreCase("m4a") || end.equalsIgnoreCase("mp3") || end.equalsIgnoreCase("mid") || end.equalsIgnoreCase("xmf") || end.equalsIgnoreCase("ogg") || end.equalsIgnoreCase("wav") ? "audio" : (end.equalsIgnoreCase("3gp") || end.equalsIgnoreCase("mp4") ? "video" : (end.equalsIgnoreCase("jpg") || end.equalsIgnoreCase("gif") || end.equalsIgnoreCase("png") || end.equalsIgnoreCase("jpeg") || end.equalsIgnoreCase("bmp") ? "image" : (end.equalsIgnoreCase("apk") ? "application/vnd.android.package-archive" : (end.equalsIgnoreCase("txt") || end.equalsIgnoreCase("java") ? "text" : "*"))));
        if (!end.equalsIgnoreCase("apk")) {
            type = type + "/*";
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File fromFile, String toFile) throws IOException {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"", (Throwable)e);
                }
            }
        }
    }

    public static File createNewFile(File file) {
        try {
            if (file.exists()) {
                return file;
            }
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
        return file;
    }

    public static File createNewFile(String path) {
        File file = new File(path);
        return MyFileUtils.createNewFile(file);
    }

    public static void deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        MyFileUtils.deleteFile(file);
    }

    public static void deleteFile(File file) {
        try {
            if (!file.exists()) {
                return;
            }
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    MyFileUtils.deleteFile(files[i]);
                }
            }
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean write(String path, String content) {
        return MyFileUtils.write(path, content, false);
    }

    public static boolean write(String path, String content, boolean append) {
        return MyFileUtils.write(new File(path), content, append);
    }

    public static boolean write(File file, String content) {
        return MyFileUtils.write(file, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(File file, String content, boolean append) {
        if (file == null || TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        if (!file.exists()) {
            file = MyFileUtils.createNewFile(file);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, append);
            fos.write(content.getBytes());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"", (Throwable)e);
            }
            fos = null;
        }
        return true;
    }

    public static String getFileName(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File f = new File(path);
        String name = f.getName();
        f = null;
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(File file, int startLine, int lineCount) {
        ArrayList<String> list;
        block17: {
            if (file == null || startLine < 1 || lineCount < 1) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            InputStreamReader fileReader = null;
            list = null;
            try {
                int i;
                list = new ArrayList<String>();
                fileReader = new FileReader(file);
                LineNumberReader lineReader = new LineNumberReader(fileReader);
                boolean end = false;
                for (i = 1; i < startLine; ++i) {
                    if (lineReader.readLine() != null) continue;
                    end = true;
                    break;
                }
                if (end) break block17;
                for (i = startLine; i < startLine + lineCount; ++i) {
                    String line = lineReader.readLine();
                    if (line == null) {
                        break;
                    }
                    list.add(line);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"read log error!", (Throwable)e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    public static boolean createDir(File dir) {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"create dir error", (Throwable)e);
            return false;
        }
    }

    public static File creatSDDir(String dirName) {
        File dir = new File(dirName);
        dir.mkdir();
        return dir;
    }

    public static boolean isFileExist(String fileName) {
        File file = new File(fileName);
        return file == null ? false : file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File write2SDFromInput(String path, String fileName, InputStream input) {
        File file = null;
        OutputStream output = null;
        try {
            MyFileUtils.creatSDDir(path);
            file = MyFileUtils.createNewFile(path + "/" + fileName);
            output = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        FileReader read = null;
        String content = "";
        String result = "";
        BufferedReader br = null;
        try {
            read = new FileReader(file);
            br = new BufferedReader(read);
            while ((content = br.readLine().toString().trim()) != null) {
                result = result + content + "\r\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                read.close();
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void compressBmpToFile(Bitmap bmp, File file) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int options = 100;
        bmp.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
        while (baos.toByteArray().length / 1024 > 100) {
            baos.reset();
            bmp.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)baos);
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap compressImageFromFile(String srcPath, float pixWidth, float pixHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        int w = options.outWidth;
        int h = options.outHeight;
        int scale = 1;
        if (w > h && (float)w > pixWidth) {
            scale = (int)((float)options.outWidth / pixWidth);
        } else if (w < h && (float)h > pixHeight) {
            scale = (int)((float)options.outHeight / pixHeight);
        }
        if (scale <= 0) {
            scale = 1;
        }
        options.inSampleSize = scale;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inPurgeable = true;
        options.inInputShareable = true;
        bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)options);
        return bitmap;
    }

    public void transImage(String fromFile, String toFile, int width, int height, int quality) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)fromFile);
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            float scaleWidth = (float)width / (float)bitmapWidth;
            float scaleHeight = (float)height / (float)bitmapHeight;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            Bitmap resizeBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmapWidth, (int)bitmapHeight, (Matrix)matrix, (boolean)false);
            File myCaptureFile = new File(toFile);
            FileOutputStream out = new FileOutputStream(myCaptureFile);
            if (resizeBitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out)) {
                out.flush();
                out.close();
            }
            if (!bitmap.isRecycled()) {
                bitmap.recycle();
            }
            if (!resizeBitmap.isRecycled()) {
                resizeBitmap.recycle();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getFilePath(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)baos);
        String path = Environment.getExternalStorageDirectory() + "/dayaWhiteBroad";
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(path + "/" + System.currentTimeMillis() + ".png");
        try {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            int x = 0;
            byte[] b = new byte[102400];
            while ((x = is.read(b)) != -1) {
                fos.write(b, 0, x);
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file.getPath();
    }

    public static void saveImageToGallery(Bitmap bmp, String path) {
        File file = new File(path);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uriToFile(Context context, Uri uri, String filePath) {
        File privateFile = new File(filePath);
        File fileParent = privateFile.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        if (privateFile.exists()) {
            return privateFile.getAbsolutePath();
        }
        InputStream ist = null;
        OutputStream ost = null;
        try {
            privateFile.createNewFile();
            ist = context.getContentResolver().openInputStream(uri);
            ost = new FileOutputStream(privateFile);
            byte[] buffer = new byte[4096];
            int byteCount = 0;
            while ((byteCount = ist.read(buffer)) != -1) {
                ost.write(buffer, 0, byteCount);
            }
        }
        catch (IOException e) {
            String string2 = "";
            return string2;
        }
        finally {
            try {
                if (ist != null) {
                    ist.close();
                }
                if (ost != null) {
                    ost.close();
                }
            }
            catch (IOException e) {
                return "";
            }
        }
        return privateFile.getAbsolutePath();
    }

    public static Intent startIntent(Context context, String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        Intent intent = null;
        switch (path.substring(path.lastIndexOf(".") + 1)) {
            case "pdf": {
                intent = MyFileUtils.getPdfFileIntent(context, path);
                break;
            }
            case "text": {
                intent = MyFileUtils.getTextFileIntent(context, path);
                break;
            }
            case "html": {
                intent = MyFileUtils.getHtmlFileIntent(path);
                break;
            }
            case "doc": 
            case "docx": {
                intent = MyFileUtils.getWordFileIntent(context, path);
                break;
            }
            case "xls": 
            case "xlsx": {
                intent = MyFileUtils.getHtmlFileIntent(path);
            }
        }
        return intent;
    }

    public static Intent getHtmlFileIntent(String Path2) {
        File file = new File(Path2);
        Uri uri = Uri.parse((String)file.toString()).buildUpon().encodedAuthority("com.android.htmlfileprovider").scheme("content").encodedPath(file.toString()).build();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "text/html");
        return intent;
    }

    public static Intent getImageFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)file);
        intent.setDataAndType(uri, "image/*");
        return intent;
    }

    public static Intent getPdfFileIntent(Context context, String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = null;
        boolean isN = Build.VERSION.SDK_INT >= 24;
        uri = isN ? FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".FileProvider"), (File)file) : Uri.fromFile((File)file);
        intent.setDataAndType(uri, "application/pdf");
        return intent;
    }

    public static Intent getTextFileIntent(Context context, String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = null;
        boolean isN = Build.VERSION.SDK_INT >= 24;
        uri = isN ? FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".FileProvider"), (File)file) : Uri.fromFile((File)file);
        intent.setDataAndType(uri, "text/plain");
        return intent;
    }

    public static Intent getAudioFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x4000000);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        Uri uri = Uri.fromFile((File)file);
        intent.setDataAndType(uri, "audio/*");
        return intent;
    }

    public static Intent getVideoFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x4000000);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        Uri uri = Uri.fromFile((File)file);
        intent.setDataAndType(uri, "video/*");
        return intent;
    }

    public static Intent getChmFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)file);
        intent.setDataAndType(uri, "application/x-chm");
        return intent;
    }

    public static Intent getWordFileIntent(Context context, String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = null;
        boolean isN = Build.VERSION.SDK_INT >= 24;
        uri = isN ? FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".FileProvider"), (File)file) : Uri.fromFile((File)file);
        intent.setDataAndType(uri, "application/msword");
        return intent;
    }

    public static Intent getExcelFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)file);
        intent.setDataAndType(uri, "application/vnd.ms-excel");
        return intent;
    }

    public static Intent getPPTFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)file);
        intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
        return intent;
    }

    public static Intent getApkFileIntent(String Path2) {
        File file = new File(Path2);
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        return intent;
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (MyFileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (MyFileUtils.isDownloadsDocument(uri)) {
                    String[] contentUriPrefixesToTry;
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    if (id2 != null && id2.startsWith("raw:")) {
                        return id2.substring(4);
                    }
                    for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads"}) {
                        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)Long.valueOf(id2));
                        try {
                            String path = MyFileUtils.getDataColumn(context, contentUri, null, null);
                            if (path == null || path.equals("")) continue;
                            return path;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String fileName = MyFileUtils.getFileName(context, uri);
                    File cacheDir = MyFileUtils.getDocumentCacheDir(context);
                    File file = MyFileUtils.generateFileName(fileName, cacheDir);
                    String destinationPath = null;
                    if (file != null) {
                        destinationPath = file.getAbsolutePath();
                        MyFileUtils.saveFileFromUri(context, uri, destinationPath);
                    }
                    return destinationPath;
                }
                if (MyFileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return MyFileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                String path = MyFileUtils.getDataColumn(context, uri, null, null);
                if (path != null && !path.equals("")) {
                    return path;
                }
                String fileName = MyFileUtils.getFileName(context, uri);
                File cacheDir = MyFileUtils.getDocumentCacheDir(context);
                File file = MyFileUtils.generateFileName(fileName, cacheDir);
                String destinationPath = null;
                if (file != null) {
                    destinationPath = file.getAbsolutePath();
                    MyFileUtils.saveFileFromUri(context, uri, destinationPath);
                }
                return destinationPath;
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        String path = "";
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = path = cursor.getString(column_index);
                return string2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return path;
    }

    public static String getFileName(@NonNull Context context, Uri uri) {
        String mimeType = context.getContentResolver().getType(uri);
        String filename = null;
        if (mimeType == null && context != null) {
            String path = MyFileUtils.getPath(context, uri);
            if (path == null) {
                filename = MyFileUtils.getName(uri.toString());
            } else {
                File file = new File(path);
                filename = file.getName();
            }
        } else {
            Cursor returnCursor = context.getContentResolver().query(uri, null, null, null, null);
            if (returnCursor != null) {
                int nameIndex = returnCursor.getColumnIndex("_display_name");
                returnCursor.moveToFirst();
                filename = returnCursor.getString(nameIndex);
                returnCursor.close();
            }
        }
        return filename;
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = filename.lastIndexOf(47);
        return filename.substring(index + 1);
    }

    public static File getDocumentCacheDir(@NonNull Context context) {
        File dir = new File(context.getCacheDir(), DOCUMENTS_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    @Nullable
    public static File generateFileName(@Nullable String name, File directory) {
        if (name == null) {
            return null;
        }
        File file = new File(directory, name);
        if (file.exists()) {
            String fileName = name;
            String extension = "";
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0) {
                fileName = name.substring(0, dotIndex);
                extension = name.substring(dotIndex);
            }
            int index = 0;
            while (file.exists()) {
                name = fileName + '(' + ++index + ')' + extension;
                file = new File(directory, name);
            }
        }
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFileFromUri(Context context, Uri uri, String destinationPath) {
        InputStream is = null;
        FilterOutputStream bos = null;
        try {
            is = context.getContentResolver().openInputStream(uri);
            bos = new BufferedOutputStream(new FileOutputStream(destinationPath, false));
            byte[] buf = new byte[1024];
            is.read(buf);
            do {
                bos.write(buf);
            } while (is.read(buf) != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bitmapToBase64(Bitmap bitmap) {
        String result = null;
        ByteArrayOutputStream baos = null;
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
                baos.flush();
                baos.close();
                byte[] bitmapBytes = baos.toByteArray();
                result = Base64.encodeToString((byte[])bitmapBytes, (int)0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64.decode((String)base64Data, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static String getRecordFilePath() {
        return MyFileUtils.getCacheDir((Context)Utils.getApp()) + File.separator + "wav-accompany.wav";
    }

    public static boolean isVideo(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        boolean b = filePath.endsWith(MP4_FILE_SUFFIX);
        return b;
    }

    public static boolean isVideoFromUrl(String url) {
        boolean b = url.endsWith(MP4_FILE_SUFFIX);
        return b;
    }

    public static String getMp3OrMp4FileSuffix(String url) {
        boolean isVideo = MyFileUtils.isVideoFromUrl(url);
        String fileEndSuffix = isVideo ? MP4_FILE_SUFFIX : MP3_FILE_SUFFIX;
        return fileEndSuffix;
    }

    public static String getWAVOrMp4FileSuffix(String url) {
        boolean isVideo = MyFileUtils.isVideoFromUrl(url);
        String fileEndSuffix = isVideo ? MP4_FILE_SUFFIX : WAV_FILE_SUFFIX;
        return fileEndSuffix;
    }

    public static String getDownloadSavePath(String url) {
        int lastDot = url.lastIndexOf(".");
        if (lastDot < 0) {
            return "";
        }
        String fileType = url.substring(lastDot).toLowerCase();
        String fileName = EncryptUtils.encryptMD5ToString(url);
        String path = filesDirectory + File.separator + fileName + fileType;
        ALOG.i(TAG, "getDownloadSavePath:" + path);
        return path;
    }

    public static void copyMidiFile(Application application) {
        try {
            File f = new File(com.jinmingyunle.midiplaylib.utils.Utils.getMidMusicSourcePath((Context)application));
            if (f.exists() && f.length() < 0x2700000L) {
                f.delete();
            }
            if (!f.exists()) {
                InputStream is = application.getAssets().open("soundfont.sf2");
                if (is == null) {
                    return;
                }
                f.createNewFile();
                FileOutputStream os = new FileOutputStream(f);
                byte[] data = new byte[1024];
                int len = 0;
                while ((len = is.read(data)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                }
                is.close();
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File saveBase64ImgToLocalFile(String base64) throws Exception {
        byte[] bytes;
        if (base64.startsWith("data:image/png;base64")) {
            String[] split = base64.split(",");
            bytes = Base64.decode((String)split[1], (int)0);
        } else {
            bytes = Base64.decode((String)base64, (int)0);
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        File parentFile = new File(MyFileUtils.getCacheDir((Context)Utils.getApp()) + File.separator + "img");
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String targetFileName = "IMG_" + new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA).format(new Date()) + ".png";
        File file = new File(parentFile, targetFileName);
        MyFileUtils.saveImagToGallery(bitmap, file.getAbsolutePath());
        if (file != null && file.exists()) {
            try {
                MediaStore.Images.Media.insertImage((ContentResolver)Utils.getApp().getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
                Utils.getApp().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(file.getPath()))));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new File(file.getAbsolutePath());
    }

    public static void saveImagToGallery(Bitmap bmp, String path) throws Exception {
        File file = new File(path);
        FileOutputStream fos = new FileOutputStream(file);
        bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileToSDCard(ResponseBody body, String filePath, String fileName) {
        boolean bl;
        OutputStream outputStream;
        block15: {
            if (null == body) {
                return false;
            }
            File parentFile = new File(filePath);
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            File futureStudioIconFile = new File(parentFile, fileName);
            InputStream inputStream = null;
            outputStream = null;
            try {
                int read;
                byte[] fileReader = new byte[4096];
                long fileSize = body.contentLength();
                long fileSizeDownloaded = 0L;
                inputStream = body.byteStream();
                outputStream = new FileOutputStream(futureStudioIconFile);
                while ((read = inputStream.read(fileReader)) != -1) {
                    outputStream.write(fileReader, 0, read);
                    fileSizeDownloaded += (long)read;
                }
                outputStream.flush();
                bl = true;
                if (inputStream == null) break block15;
            }
            catch (IOException e) {
                boolean bl2;
                block16: {
                    try {
                        bl2 = false;
                        if (inputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e2) {
                            return false;
                        }
                    }
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                return bl2;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        return bl;
    }

    public static boolean createOrExistsFile(String filePath) {
        return MyFileUtils.createOrExistsFile(MyFileUtils.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!MyFileUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static File getFileByPath(String filePath) {
        return StringUtils.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean deleteAllInDir(String dirPath) {
        return MyFileUtils.deleteAllInDir(MyFileUtils.getFileByPath(dirPath));
    }

    public static boolean deleteAllInDir(File dir) {
        return MyFileUtils.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static boolean deleteFilesInDirWithFilter(File dir, FileFilter filter) {
        if (dir == null || filter == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !MyFileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !MyFileUtils.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }
}

