/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.web;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.base.BaseActivity;
import com.daya.orchestra.accompany.bean.MusicSaveParams;
import com.daya.orchestra.accompany.callback.ResultCallback;
import com.daya.orchestra.accompany.callback.ResultCallbackV2;
import com.daya.orchestra.accompany.common.AccompanyManager;
import com.daya.orchestra.accompany.databinding.AccActivityAccompanyBinding;
import com.daya.orchestra.accompany.helper.AcPermissionTipHelper;
import com.daya.orchestra.accompany.helper.AccompanyPlayHelper;
import com.daya.orchestra.accompany.helper.CacheHelper;
import com.daya.orchestra.accompany.helper.MidiFileHelper;
import com.daya.orchestra.accompany.helper.MusicFileDownloadHelper;
import com.daya.orchestra.accompany.helper.QMUIStatusBarHelper;
import com.daya.orchestra.accompany.helper.WebParamsHelper;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.MyFileUtils;
import com.daya.orchestra.accompany.utils.ToastUtil;
import com.daya.orchestra.accompany.web.AccompanyFragment;
import com.tbruyelle.rxpermissions3.RxPermissions;
import com.wonderkiln.camerakit.CameraView;
import com.wonderkiln.camerakit.events.CameraKitError;
import com.wonderkiln.camerakit.events.CameraKitEvent;
import com.wonderkiln.camerakit.events.CameraKitEventListener;
import com.wonderkiln.camerakit.events.CameraKitImage;
import com.wonderkiln.camerakit.events.CameraKitVideo;
import com.wonderkiln.camerakit.events.CameraStartRecord;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AccompanyActivity
extends BaseActivity<AccActivityAccompanyBinding> {
    public static final String TAG = "AccompanyActivity";
    public static final String FRAGMENT_TAG = "accompanyFragment";
    FrameLayout camera;
    FrameLayout fl_webview;
    private final int PORTRAIT_REQUEST_CODE = 1002;
    private final int ADD_ACCOMPANIMENT_CODE = 1003;
    private final int SAVE_PRACTICE_REQUEST_CODE = 1004;
    private String authorization;
    private String webViewUrl;
    CameraView cameraView;
    private String filePath;
    private String videoDerectoryName = "/gytTaskVideo";
    private View cameraGroupView;
    private String recordVideFilePath;
    private String accompanimentUrl;
    private AccompanyFragment accompanyFragment;
    private JSONObject baseJsonObject;
    private boolean isNeedResetScreenOrientation = true;
    private long startRecordRealTime = -1L;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        QMUIStatusBarHelper.hideStatusBar((Activity)this);
    }

    @Override
    protected void initView() {
        this.camera = ((AccActivityAccompanyBinding)this.viewBinding).camera;
        this.fl_webview = ((AccActivityAccompanyBinding)this.viewBinding).flWebview;
        Intent intent = this.getIntent();
        String url = intent.getStringExtra("web_url");
        if (TextUtils.isEmpty((CharSequence)url)) {
            url = intent.getStringExtra("url");
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.finish();
            ALOG.i(TAG, "url can not null");
            return;
        }
        int orientation = intent.getIntExtra("orientation", -1);
        int c_orientation = intent.getIntExtra("c_orientation", 1);
        this.isNeedResetScreenOrientation = c_orientation == 1;
        ALOG.i("c_orientation:" + c_orientation + "--isNeedResetScreenOrientation:" + this.isNeedResetScreenOrientation);
        boolean isOpenLight = intent.getBooleanExtra("isOpenLight", false);
        if (isOpenLight) {
            this.getWindow().addFlags(128);
        }
        if (orientation >= 0) {
            this.setRequestedOrientation(orientation);
        }
        this.setStatusBarTextColor(intent.getBooleanExtra("statusBarTextColor", true));
        this.webViewUrl = url;
        this.initAccompanyFragment();
    }

    private void initAccompanyFragment() {
        Fragment fragmentByTag = this.getSupportFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        ALOG.i("findFragment:" + fragmentByTag);
        this.accompanyFragment = fragmentByTag != null ? (AccompanyFragment)fragmentByTag : AccompanyFragment.newInstance(this.webViewUrl, true);
        this.initAccompanyListener();
        if (this.accompanyFragment.isAdded()) {
            this.getSupportFragmentManager().beginTransaction().show((Fragment)this.accompanyFragment).commitAllowingStateLoss();
        } else {
            this.getSupportFragmentManager().beginTransaction().add(R.id.fl_webview, (Fragment)this.accompanyFragment, FRAGMENT_TAG).commitAllowingStateLoss();
        }
    }

    private void initAccompanyListener() {
        this.accompanyFragment.setOnAccompanyListener(new AccompanyFragment.onListener(){

            @Override
            public void setStatusBarTextColor(boolean statusBarTextColor) {
            }

            @Override
            public void openCamera() {
                if (AccompanyActivity.this.cameraView == null) {
                    AccompanyActivity.this.cameraGroupView = LayoutInflater.from((Context)AccompanyActivity.this).inflate(R.layout.acc_record_video_layout, (ViewGroup)AccompanyActivity.this.camera, false);
                    AccompanyActivity.this.camera.addView(AccompanyActivity.this.cameraGroupView);
                    AccompanyActivity.this.cameraView = (CameraView)AccompanyActivity.this.cameraGroupView.findViewById(R.id.camera);
                    AccompanyActivity.this.cameraView.setVideoQuality(1);
                    AccompanyActivity.this.cameraView.setPermissions(2);
                    AccompanyActivity.this.cameraView.start();
                    AccompanyActivity.this.cameraView.addCameraKitListener(new CameraKitEventListener(){

                        public void onEvent(CameraKitEvent cameraKitEvent) {
                            if (TextUtils.equals((CharSequence)cameraKitEvent.getType(), (CharSequence)"CKCameraOpenedEvent")) {
                                if (AccompanyActivity.this.cameraView != null) {
                                    AccompanyActivity.this.cameraView.requestLayout();
                                }
                            } else if (TextUtils.equals((CharSequence)cameraKitEvent.getType(), (CharSequence)"CKStartRecordEvent") && cameraKitEvent instanceof CameraStartRecord) {
                                CameraStartRecord recordEvent = (CameraStartRecord)cameraKitEvent;
                                AccompanyActivity.this.startRecordRealTime = recordEvent.getTime();
                            }
                        }

                        public void onError(CameraKitError cameraKitError) {
                        }

                        public void onImage(CameraKitImage cameraKitImage) {
                        }

                        public void onVideo(CameraKitVideo cameraKitVideo) {
                            try {
                                if (!AccompanyActivity.this.checkActivityExist()) {
                                    return;
                                }
                                File file = cameraKitVideo.getVideoFile();
                                AccompanyActivity.this.filePath = file.getPath();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }

            @Override
            public void closeCamera() {
                if (AccompanyActivity.this.cameraView != null) {
                    AccompanyActivity.this.filePath = "";
                    AccompanyActivity.this.startRecordRealTime = -1L;
                    AccompanyActivity.this.cameraView.stop();
                    AccompanyActivity.this.cameraView.destroyDrawingCache();
                    AccompanyActivity.this.camera.removeView(AccompanyActivity.this.cameraGroupView);
                    AccompanyActivity.this.cameraGroupView = null;
                    AccompanyActivity.this.cameraView = null;
                }
            }

            @Override
            public void startCapture() {
                if (AccompanyActivity.this.cameraView != null) {
                    AccompanyActivity.this.startRecordRealTime = -1L;
                    AccompanyActivity.this.toStartCapture();
                }
            }

            @Override
            public void videoUpdate(JSONObject jsonObject) {
                String[] permissions = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
                AcPermissionTipHelper.getInstance().showTipDialog((Activity)AccompanyActivity.this, permissions);
                new RxPermissions((FragmentActivity)AccompanyActivity.this).request(permissions).subscribe(permission2 -> {
                    AcPermissionTipHelper.getInstance().dismissDialog();
                    if (permission2.booleanValue()) {
                        AccompanyActivity.this.toSaveVideo(jsonObject);
                    } else {
                        AccompanyActivity.this.upLoadFileFaile();
                        AccompanyManager.getInstance().showPermissionTipDialog(AccompanyActivity.this.getSupportFragmentManager(), (Context)AccompanyActivity.this, "\u63d0\u793a", "\u8bf7\u5f00\u542f\u50a8\u5b58\u8bbf\u95ee\u6743\u9650");
                    }
                });
            }

            @Override
            public void onDownloadAccompaniment(final JSONObject message) {
                JSONObject content = message.optJSONObject("content");
                if (content != null) {
                    String accompanyMp3Url = content.optString("musicSrc");
                    AccompanyActivity.this.accompanimentUrl = accompanyMp3Url;
                    if (!TextUtils.isEmpty((CharSequence)AccompanyActivity.this.accompanimentUrl)) {
                        boolean b = MusicFileDownloadHelper.checkFileIsExist(AccompanyActivity.this.accompanimentUrl);
                        if (b) {
                            AccompanyActivity.this.sendCreateMusicPlayerMsg(message);
                        } else {
                            MusicFileDownloadHelper.getInstance().download(accompanyMp3Url, new ResultCallbackV2<String>(){

                                @Override
                                public void onSuccess(String s) {
                                    ALOG.i("download success:" + s);
                                    AccompanyActivity.this.sendCreateMusicPlayerMsg(message);
                                }

                                @Override
                                public void onProgress(int progressPercent) {
                                    ALOG.i("download onProgress:" + progressPercent);
                                }

                                @Override
                                public void onFail(int errorCode, String errorStr) {
                                    ALOG.i("download onFail:" + errorCode + "--" + errorStr);
                                    AccompanyActivity.this.sendCreateMusicPlayerMsg(message);
                                }
                            });
                        }
                    }
                }
            }

            @Override
            public void openAdjustRecording(MusicSaveParams musicSaveParams) {
                AccompanyActivity.this.goAdjustMusic(musicSaveParams);
            }

            @Override
            public void endCapture() {
                if (!AccompanyActivity.this.checkActivityExist()) {
                    MyFileUtils.deleteFile(AccompanyActivity.this.recordVideFilePath);
                    return;
                }
                if (AccompanyActivity.this.cameraView != null && AccompanyActivity.this.cameraView.getVisibility() == 0) {
                    AccompanyActivity.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (AccompanyActivity.this.cameraView != null) {
                                AccompanyActivity.this.cameraView.stopVideo();
                            }
                        }
                    }, 1000L);
                }
            }
        });
    }

    private void toSaveVideo(JSONObject jsonObject) {
        this.baseJsonObject = jsonObject;
        File file = new File(this.recordVideFilePath);
        if (!file.exists()) {
            ToastUtil.getInstance().showShort("\u672a\u627e\u5230\u8be5\u89c6\u9891\uff0c\u8bf7\u91cd\u8bd5");
            MyFileUtils.deleteFile(this.recordVideFilePath);
            return;
        }
        this.toSaveVideoToAlbum(this.recordVideFilePath);
        String bucket = WebParamsHelper.getParams(jsonObject, "bucket");
        String uploadPath = WebParamsHelper.getParams(jsonObject, "path");
        AccompanyManager.getInstance().toUpload((Activity)this, file, bucket, uploadPath, new ResultCallback<Object>(){

            @Override
            public void onSuccess(Object o) {
                try {
                    String url = (String)o;
                    JSONObject contentObj = AccompanyActivity.this.baseJsonObject.getJSONObject("content");
                    String uuid = contentObj.getString("uuid");
                    contentObj.put("type", (Object)"success");
                    contentObj.put("filePath", (Object)url);
                    contentObj.put("uuid", (Object)uuid);
                    contentObj.put("message", (Object)"\u4e0a\u4f20\u6210\u529f");
                    AccompanyActivity.this.accompanyFragment.onSendMessage(AccompanyActivity.this.baseJsonObject.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFail(int errorCode, String errorStr) {
                AccompanyActivity.this.upLoadFileFaile();
                ToastUtil.getInstance().showShort("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        });
    }

    private void toSaveVideoToAlbum(final String filePath) {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(@NonNull ObservableEmitter<Object> emitter) throws Throwable {
                MyFileUtils.saveVideoToGallery(AccompanyActivity.this.getApplicationContext(), filePath);
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Throwable {
            }
        });
    }

    @Override
    protected void initData() {
        super.initData();
        this.requestPermission();
    }

    @SuppressLint(value={"CheckResult"})
    private void toStartCapture() {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(@NonNull ObservableEmitter<Object> emitter) {
                if (AccompanyActivity.this.cameraView != null) {
                    AccompanyActivity.this.recordVideFilePath = MyFileUtils.getPublicDirectory(AccompanyActivity.this.videoDerectoryName) + File.separator + "VID_" + new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA).format(new Date()) + ".mp4";
                    AccompanyActivity.this.cameraView.captureVideo(new File(AccompanyActivity.this.recordVideFilePath));
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) {
            }
        });
    }

    private void requestPermission() {
        MidiFileHelper.initMidFile();
    }

    private int getVideoDelay() {
        if (this.startRecordRealTime != -1L && AccompanyPlayHelper.realPlayStartTime != -1L) {
            ALOG.i("\u6d4b\u8bd5\u65f6\u95f4", "realPlayStartTime:" + AccompanyPlayHelper.realPlayStartTime);
            ALOG.i("\u6d4b\u8bd5\u65f6\u95f4", "startRecordRealTime:" + this.startRecordRealTime);
            int time = (int)(AccompanyPlayHelper.realPlayStartTime - this.startRecordRealTime);
            ALOG.i("\u6d4b\u8bd5\u65f6\u95f4", "\u89c6\u9891\u5f55\u5236\u6d88\u8017:" + time);
            return time;
        }
        return 0;
    }

    private void goAdjustMusic(MusicSaveParams musicSaveParams) {
        int customCacheForInt;
        if (TextUtils.isEmpty((CharSequence)this.accompanimentUrl)) {
            ToastUtil.getInstance().showShort("\u65e0\u6cd5\u627e\u5230\u4f34\u594f\u6587\u4ef6");
            return;
        }
        int evaluateDelay = customCacheForInt = Math.abs(CacheHelper.getCustomCacheForInt("delayForCurrentPlay", 0));
        String recordFilePath = MyFileUtils.getRecordFilePath();
        if (!TextUtils.isEmpty((CharSequence)this.filePath)) {
            recordFilePath = this.filePath;
            customCacheForInt = this.getVideoDelay();
            ALOG.i("\u89c6\u9891\u5ef6\u8fdf\u7ed3\u679c", "customCacheForInt:" + customCacheForInt);
        }
        musicSaveParams.setAccompanyUrl(this.accompanimentUrl);
        musicSaveParams.setRecordFilePath(recordFilePath);
        musicSaveParams.setDefaultDelay(customCacheForInt);
        musicSaveParams.setEvaluateDelay(evaluateDelay);
        AccompanyManager.getInstance().openMusicMergePage((Activity)this, musicSaveParams, 1004);
    }

    public void setStatusBarTextColor(boolean statusBarTextColor) {
        if (statusBarTextColor) {
            QMUIStatusBarHelper.setStatusBarDarkMode((Activity)this);
        } else {
            QMUIStatusBarHelper.setStatusBarLightMode((Activity)this);
        }
    }

    @Override
    protected AccActivityAccompanyBinding getLayoutView() {
        return AccActivityAccompanyBinding.inflate(this.getLayoutInflater());
    }

    protected void onResume() {
        super.onResume();
        if (this.cameraView != null) {
            this.cameraView.setVisibility(0);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (AccompanyActivity.this.cameraView != null) {
                        AccompanyActivity.this.cameraView.start();
                    }
                }
            }, 1000L);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 1004) {
            if (data != null) {
                int result = data.getIntExtra("saveWorksStatus", 0);
                if (result == 1) {
                    this.sendSaveSuccessMsg();
                }
                if (result == 2) {
                    this.sendRecordMsg();
                }
            }
            return;
        }
        if (requestCode == 1003) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("api", (Object)"reload");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (requestCode == 1000) {
            if (data != null) {
                try {
                    String filePath = data.getStringExtra("filePath");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("api", (Object)"uploadVideo");
                    jsonObject.put("url", (Object)filePath);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else if (requestCode == 1011) {
            String selectAddress = data.getStringExtra("selectAddress");
            if (null != this.accompanyFragment) {
                this.accompanyFragment.selectAddress(selectAddress);
            }
        }
    }

    private void sendCreateMusicPlayerMsg(JSONObject jsonObject) {
        if (this.accompanyFragment != null) {
            this.accompanyFragment.onSendMessage(jsonObject.toString());
        }
    }

    private void sendRecordMsg() {
        JSONObject json = new JSONObject();
        try {
            JSONObject content = new JSONObject();
            json.put("api", (Object)"retryEvaluating");
            json.put("content", (Object)content);
            if (this.accompanyFragment != null) {
                this.accompanyFragment.onSendMessage(json.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendSaveSuccessMsg() {
        JSONObject json = new JSONObject();
        try {
            JSONObject content = new JSONObject();
            json.put("api", (Object)"hideComplexButton");
            json.put("content", (Object)content);
            if (this.accompanyFragment != null) {
                this.accompanyFragment.onSendMessage(json.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onStop() {
        if (this.cameraView != null) {
            this.cameraView.stop();
            this.cameraView.destroyDrawingCache();
        }
        super.onStop();
    }

    private void upLoadFileFaile() {
        try {
            JSONObject contentObj = this.baseJsonObject.getJSONObject("content");
            String uuid = contentObj.getString("uuid");
            contentObj.put("type", (Object)"error");
            contentObj.put("uuid", (Object)uuid);
            contentObj.put("message", (Object)"\u4fdd\u5b58\u5931\u8d25");
            this.accompanyFragment.onSendMessage(this.baseJsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        this.checkScreenOrientation();
        super.finish();
    }

    public void onBackPressed() {
        this.checkScreenOrientation();
        super.onBackPressed();
    }

    private void checkScreenOrientation() {
        ALOG.i("isNeedResetScreenOrientation:" + this.isNeedResetScreenOrientation);
        if (this.isNeedResetScreenOrientation && this.getRequestedOrientation() == 0) {
            this.setRequestedOrientation(1);
        }
    }
}

