/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.airbnb.lottie.LottieAnimationView;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.helper.QMUIDeviceHelper;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.SizeUtils;
import com.daya.orchestra.accompany.widget.BaseDelayCheckView;

public class DefaultDelayCheckView
extends BaseDelayCheckView {
    private LottieAnimationView leftTopAnim;
    private LottieAnimationView rightTopAnim;
    private LottieAnimationView centerTopAnim;
    private LottieAnimationView mainAnim;
    private ImageView mIvTip;
    private ImageView mIvBack;
    private ImageView mIvImg1;
    private ImageView mIvImg2;
    private AnimatorSet mAnimatorSet;
    private View mViewRetry;
    private LinearLayout mLlEarphoneTip;

    public DefaultDelayCheckView(@NonNull Context context) {
        super(context);
    }

    public DefaultDelayCheckView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DefaultDelayCheckView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutRes() {
        return R.layout.acc_default_delaycheck_anim_layout;
    }

    @Override
    public void initView() {
        this.leftTopAnim = (LottieAnimationView)this.findViewById(R.id.view_anim1);
        this.rightTopAnim = (LottieAnimationView)this.findViewById(R.id.view_anim2);
        this.centerTopAnim = (LottieAnimationView)this.findViewById(R.id.view_anim3);
        this.mainAnim = (LottieAnimationView)this.findViewById(R.id.view_anim4);
        this.mIvTip = (ImageView)this.findViewById(R.id.iv_tip);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_close);
        this.mIvImg1 = (ImageView)this.findViewById(R.id.iv_img1);
        this.mIvImg2 = (ImageView)this.findViewById(R.id.iv_img2);
        this.mViewRetry = this.findViewById(R.id.view_retry);
        this.mLlEarphoneTip = (LinearLayout)this.findViewById(R.id.ll_earphone_tip);
    }

    @Override
    public void initData() {
        boolean isTable = QMUIDeviceHelper.isTablet(this.getContext());
        if (isTable) {
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mainAnim.getLayoutParams();
            layoutParams.bottomMargin = SizeUtils.dp2px(50.0f);
            this.mainAnim.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.mLlEarphoneTip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultDelayCheckView.this.mLlEarphoneTip.setVisibility(8);
            }
        });
    }

    @Override
    public void setOnViewClickListener(View.OnClickListener onViewClickListener) {
        super.setOnViewClickListener(onViewClickListener);
        if (this.mIvBack != null) {
            this.mIvBack.setOnClickListener(onViewClickListener);
        }
        if (this.mViewRetry != null) {
            this.mViewRetry.setOnClickListener(onViewClickListener);
        }
    }

    @Override
    public void showAnimStep(int step) {
        if (this.mViewRetry != null) {
            this.mViewRetry.setVisibility(step == 3 ? 0 : 8);
        }
        if (step != 4) {
            if (step == 0) {
                this.resetAnim();
            }
            if (step == 5) {
                this.mLlEarphoneTip.setVisibility(0);
                return;
            }
            this.mLlEarphoneTip.setVisibility(8);
            int mainAnimRes = this.getMainAnimRes(step);
            this.mainAnim.setAnimation(mainAnimRes);
            this.mainAnim.playAnimation();
            this.mIvTip.setImageResource(this.getTipImgRes(step));
        } else {
            this.handleCompletedAnim();
        }
    }

    private void resetAnim() {
        float translationX2;
        float translationX;
        float translationY2;
        float translationY = this.mIvImg1.getTranslationY();
        if (translationY != 0.0f) {
            ALOG.i("translationY:" + translationY);
            this.mIvImg1.setTranslationY(0.0f);
        }
        if ((translationY2 = this.mIvImg2.getTranslationY()) != 0.0f) {
            ALOG.i("translationY2:" + translationY2);
            this.mIvImg2.setTranslationY(0.0f);
        }
        if ((translationX = this.leftTopAnim.getTranslationX()) != 0.0f) {
            ALOG.i("translationX:" + translationX);
            this.leftTopAnim.setTranslationX(0.0f);
        }
        if ((translationX2 = this.rightTopAnim.getTranslationX()) != 0.0f) {
            ALOG.i("translationX2:" + translationX2);
            this.rightTopAnim.setTranslationX(0.0f);
        }
    }

    private void handleCompletedAnim() {
        ALOG.i("handleCompletedAnim");
        int height = this.mIvImg1.getHeight();
        int height2 = this.mIvImg2.getHeight();
        int leftTopAnimWidth = this.leftTopAnim.getWidth();
        int rightTopAnimWidth = this.rightTopAnim.getWidth();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mIvImg1, (String)"translationY", (float[])new float[]{0.0f, -height});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.mIvImg2, (String)"translationY", (float[])new float[]{0.0f, -height2});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)this.leftTopAnim, (String)"translationX", (float[])new float[]{0.0f, -leftTopAnimWidth});
        ObjectAnimator objectAnimator4 = ObjectAnimator.ofFloat((Object)this.rightTopAnim, (String)"translationX", (float[])new float[]{0.0f, rightTopAnimWidth});
        this.mAnimatorSet = new AnimatorSet();
        this.mAnimatorSet.playTogether(new Animator[]{objectAnimator, objectAnimator2, objectAnimator3, objectAnimator4});
        this.mAnimatorSet.setDuration(1000L);
        this.mAnimatorSet.start();
    }

    private int getTipImgRes(int step) {
        if (step == 0) {
            return R.drawable.as_icon_delay_check_tip1;
        }
        if (step == 1) {
            return R.drawable.as_icon_delay_check_tip2;
        }
        if (step == 2) {
            return R.drawable.as_icon_delay_check_tip3;
        }
        if (step == 3) {
            return R.drawable.as_icon_delay_check_tip4;
        }
        return R.drawable.as_icon_delay_check_tip1;
    }

    private int getMainAnimRes(int step) {
        if (step == 0) {
            return R.raw.as_check_prepare;
        }
        if (step == 1) {
            return R.raw.as_check_ing;
        }
        if (step == 2) {
            return R.raw.as_check_success;
        }
        if (step == 3) {
            return R.raw.as_check_fail;
        }
        return R.raw.as_check_prepare;
    }

    @Override
    public void release() {
        super.release();
        this.stopAnim();
    }

    private void stopAnim() {
        if (this.leftTopAnim != null) {
            this.leftTopAnim.cancelAnimation();
            this.leftTopAnim.clearAnimation();
        }
        if (this.rightTopAnim != null) {
            this.rightTopAnim.cancelAnimation();
            this.rightTopAnim.clearAnimation();
        }
        if (this.centerTopAnim != null) {
            this.centerTopAnim.cancelAnimation();
            this.centerTopAnim.clearAnimation();
        }
        if (this.mainAnim != null) {
            this.mainAnim.cancelAnimation();
            this.mainAnim.clearAnimation();
        }
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.cancel();
            this.mAnimatorSet = null;
        }
    }
}

