/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.VideoSource;
import java.util.IdentityHashMap;

public class VideoTrack
extends MediaStreamTrack {
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();
    protected VideoSource mVideoSource;

    public VideoTrack(long nativeTrack) {
        super(nativeTrack);
    }

    public void addSink(VideoSink sink) throws IllegalArgumentException, IllegalStateException {
        if (sink == null) {
            throw new IllegalArgumentException("The VideoSink is not allowed to be null");
        }
        if (!this.sinks.containsKey(sink)) {
            long nativeSink = VideoTrack.nativeWrapSink(sink);
            this.sinks.put(sink, nativeSink);
            VideoTrack.nativeAddSink(this.getNativeMediaStreamTrack(), nativeSink);
        }
    }

    public void removeSink(VideoSink sink) throws IllegalArgumentException, IllegalStateException {
        Long nativeSink = this.sinks.remove(sink);
        if (nativeSink != null) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), nativeSink);
            VideoTrack.nativeFreeSink(nativeSink);
        }
    }

    @Override
    public void dispose() throws IllegalArgumentException, IllegalStateException {
        for (long nativeSink : this.sinks.values()) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), nativeSink);
            VideoTrack.nativeFreeSink(nativeSink);
        }
        this.sinks.clear();
        if (this.mVideoSource != null) {
            this.mVideoSource.dispose();
        }
        super.dispose();
    }

    long getNativeVideoTrack() {
        return this.getNativeMediaStreamTrack();
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);

    public VideoSource getVideoSource() {
        return this.mVideoSource;
    }

    public void setVideoSource(VideoSource videoSource) {
        this.mVideoSource = videoSource;
    }
}

