/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.daya.orchestra.accompany.common.AccompanyError;
import com.daya.orchestra.accompany.common.Constants;
import com.daya.orchestra.accompany.common.SocketStatus;
import com.daya.orchestra.accompany.helper.CacheHelper;
import com.daya.orchestra.accompany.helper.DelayCheckHelper;
import com.daya.orchestra.accompany.helper.DeviceDelayCheckHelper;
import com.daya.orchestra.accompany.player.CustomExoPlayer;
import com.daya.orchestra.accompany.player.OnCompletionListener;
import com.daya.orchestra.accompany.recorder.AudioChunk;
import com.daya.orchestra.accompany.recorder.AudioRecordConfig;
import com.daya.orchestra.accompany.recorder.MsRecorder;
import com.daya.orchestra.accompany.recorder.PullTransport;
import com.daya.orchestra.accompany.recorder.Recorder;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.MyFileUtils;
import com.daya.orchestra.accompany.utils.ToastUtil;
import com.daya.orchestra.accompany.utils.Utils;
import com.daya.orchestra.accompany.websocket.JWebSocketClient;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class AccompanyPlayHelper
implements OnCompletionListener {
    public static final String TAG = "AccPlayHelper";
    public static long realPlayStartTime = -1L;
    public static final long MIN_GET_PLAY_PROGRESS_INTERVAL = 15L;
    private Context mContext;
    private ArrayList<Integer> delayCheckResults = new ArrayList();
    private String musicSrc;
    private String tuneSrc;
    private int[] delaySample = new int[]{800, 800};
    private int playDelayTime = 0;
    public static final String BLANK_DEVICE_DELAY_CACHE_KEY = "blankDelayCache";
    public static final String DELAY_FOR_CURRENT_CACHE_KEY = "delayForCurrentPlay";
    private Recorder wavRecorder;
    private CustomExoPlayer player;
    private long startPlayTime = 0L;
    private boolean isTag = true;
    boolean isSendRecordStartTime = false;
    long sendFirstTime = 0L;
    boolean isSendAudioData = false;
    long startOffsetTime = 0L;
    private JWebSocketClient webSocketClient;
    private WebView webView;
    private Handler loopHandler;
    private boolean isStartTune = false;
    private boolean isAutoEnd = false;
    private OnEventListener listener;
    private DelayCheckHelper mCheckHelper;
    private Runnable mTuneRunnable = new Runnable(){

        @Override
        public void run() {
            if (AccompanyPlayHelper.this.player == null) {
                return;
            }
            long cu = AccompanyPlayHelper.this.player.getCu();
            long duration = AccompanyPlayHelper.this.player.getT();
            if (cu > 500L && AccompanyPlayHelper.this.isTag) {
                ALOG.i(AccompanyPlayHelper.TAG, "cu:" + cu);
                ALOG.i(AccompanyPlayHelper.TAG, "duration:" + duration);
                long cTime = System.currentTimeMillis();
                long endTime = cTime - cu;
                long delayTime = endTime - AccompanyPlayHelper.this.startPlayTime;
                AccompanyPlayHelper.this.playDelayTime = (int)delayTime;
                ALOG.i(AccompanyPlayHelper.TAG, "\u6821\u97f3\u5ef6\u8fdfdelayTime:" + delayTime);
                AccompanyPlayHelper.this.isTag = false;
            }
            AccompanyPlayHelper.this.loopHandler.postDelayed(AccompanyPlayHelper.this.mTuneRunnable, 10L);
        }
    };
    private Runnable mRunnable2 = new Runnable(){

        @Override
        public void run() {
            CustomExoPlayer player = AccompanyPlayHelper.this.getPlayer();
            long cu = player.getCu();
            long duration = player.getT();
            long exceptTargetPos = player.getExceptTargetPos(cu);
            if (exceptTargetPos > 1000L && AccompanyPlayHelper.this.isTag) {
                long endTime;
                long cTime = System.currentTimeMillis();
                ALOG.i(AccompanyPlayHelper.TAG, "cTime:" + cTime);
                ALOG.i(AccompanyPlayHelper.TAG, "playSpeed:" + player.getSpeed());
                long preogressBySpeed = (long)((float)exceptTargetPos / player.getSpeed());
                realPlayStartTime = endTime = cTime - preogressBySpeed;
                long delayTime = endTime - AccompanyPlayHelper.this.startPlayTime;
                ALOG.i(AccompanyPlayHelper.TAG, "\u7b2c\u4e8c\u6bb5 endTime:" + endTime);
                ALOG.i(AccompanyPlayHelper.TAG, "\u7b2c\u4e8c\u6bb5 startPlayTime:" + AccompanyPlayHelper.this.startPlayTime);
                ALOG.i(AccompanyPlayHelper.TAG, "\u7b2c\u4e8c\u6bb5 delayTime:" + delayTime);
                AccompanyPlayHelper.this.sendOffsetMessage(delayTime);
                AccompanyPlayHelper.this.isTag = false;
            }
            AccompanyPlayHelper.this.sendPlayProgressMessage(cu, duration);
            AccompanyPlayHelper.this.loopHandler.postDelayed(AccompanyPlayHelper.this.mRunnable2, 15L);
        }
    };

    public AccompanyPlayHelper(Context context, JWebSocketClient jWebSocketClient, WebView webView, ViewGroup delayCheckContainer, OnEventListener listener) {
        this.mContext = context;
        this.listener = listener;
        this.webSocketClient = jWebSocketClient;
        this.webView = webView;
        this.loopHandler = new Handler(Looper.getMainLooper());
        this.initDelayLayout(delayCheckContainer);
    }

    private void initDelayLayout(ViewGroup viewGroup) {
        this.mCheckHelper = new DelayCheckHelper(this.loopHandler);
        this.mCheckHelper.init(viewGroup, new DelayCheckHelper.OnEventListener(){

            @Override
            public SocketStatus getWebSocketStatus() {
                if (AccompanyPlayHelper.this.listener != null) {
                    return AccompanyPlayHelper.this.listener.getWebSocketStatus();
                }
                return SocketStatus.CLOSED;
            }

            @Override
            public void goStartTune(JSONObject message) {
                AccompanyPlayHelper.this.startTune(message);
            }

            @Override
            public void toFinishTune() {
                AccompanyPlayHelper.this.onFinishTune(null);
            }

            @Override
            public void sendWebViewMsg(String jsonObject) {
                AccompanyPlayHelper.this.onSendMessage(jsonObject);
            }

            @Override
            public void onCancelCheck() {
                AccompanyPlayHelper.this.stopPlay();
            }
        });
    }

    public void setWebSocketClient(JWebSocketClient jWebSocketClient) {
        ALOG.i(TAG, "setWebSocketClient:" + (Object)((Object)jWebSocketClient));
        this.webSocketClient = jWebSocketClient;
    }

    public void createMusicPlayer(JSONObject message) {
        ALOG.i(TAG, "createMusicPlayer:" + message.toString());
        JSONObject content = message.optJSONObject("content");
        if (content != null) {
            this.tuneSrc = content.optString("tuneSrc");
            this.musicSrc = content.optString("musicSrc");
            int hz = content.optInt("checkFrequence", 800);
            Arrays.fill(this.delaySample, hz);
        }
    }

    public void startTune(JSONObject message) {
        this.onSendMessage(message.toString());
        JSONObject contentJson = message.optJSONObject("content");
        if (contentJson != null) {
            this.isAutoEnd = contentJson.optBoolean("isAutoEnd", false);
            String count = contentJson.optString("count", "");
            if (TextUtils.equals((CharSequence)count, (CharSequence)"0")) {
                this.delayCheckResults.clear();
            }
        } else {
            this.isAutoEnd = false;
            this.delayCheckResults.clear();
        }
        if (!TextUtils.isEmpty((CharSequence)this.tuneSrc)) {
            this.startTune();
        }
    }

    private void startTune() {
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                JSONObject jsonObject = new JSONObject();
                JSONObject headerObject = new JSONObject();
                headerObject.put("commond", (Object)"recordStart");
                headerObject.put("type", (Object)"DELAY_CHECK");
                headerObject.put("status", 200);
                jsonObject.put("header", (Object)headerObject);
                JSONObject bodyJsonObject = new JSONObject();
                bodyJsonObject.put("HZ", this.delayCheckResults.size() == 0 ? this.delaySample[0] : this.delaySample[1]);
                jsonObject.put("body", (Object)bodyJsonObject);
                this.sendWebSocketMessage(jsonObject.toString());
                this.initRecorder();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.sendAccompanyError(AccompanyError.SOCKETERROR);
            ALOG.i(TAG, "startTune fail because webSocket not open");
        }
    }

    public void endTune(JSONObject message) {
        this.stopTune();
    }

    public void getDeviceDelay(JSONObject jsonObject) {
        JSONObject contentJson = jsonObject.optJSONObject("content");
        if (contentJson == null) {
            contentJson = new JSONObject();
        }
        if (contentJson != null) {
            int customCache = CacheHelper.getCustomCacheForInt(BLANK_DEVICE_DELAY_CACHE_KEY);
            try {
                contentJson.put("value", customCache);
                jsonObject.put("content", (Object)contentJson);
                this.onSendMessage(jsonObject.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void stopTune() {
        this.stopPlay();
        this.releaseRecorder();
        if (this.loopHandler != null) {
            this.loopHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        JSONObject headerObject = new JSONObject();
                        headerObject.put("commond", (Object)"recordEnd");
                        headerObject.put("type", (Object)"DELAY_CHECK");
                        headerObject.put("status", 200);
                        jsonObject.put("header", (Object)headerObject);
                        AccompanyPlayHelper.this.sendWebSocketMessage(jsonObject.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, 500L);
        }
    }

    private void sendWebSocketMessage(String message) {
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                ALOG.i("\u53d1\u9001webSocket\u6d88\u606f:" + message);
                this.webSocketClient.send(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ALOG.i(TAG, "\u53d1\u9001webSocket\u6d88\u606f,\u4f46\u662fwebSocketClient\u672a\u5f00\u542f:" + message);
        }
    }

    private void initRecorder() {
        this.playDelayTime = 0;
        this.isSendRecordStartTime = true;
        if (this.wavRecorder != null) {
            this.wavRecorder.stopRecording();
            MyFileUtils.deleteFile(this.getVoicePath());
            this.wavRecorder.startRecording(this.mContext);
        } else {
            Observable.create(emitter -> {
                this.wavRecorder = MsRecorder.wav(new File(this.getVoicePath()), new AudioRecordConfig(), new PullTransport.Default().setOnAudioChunkPulledListener(new PullTransport.OnAudioChunkPulledListener(){

                    @Override
                    public void onAudioChunkPulled(AudioChunk audioChunk) {
                        if (AccompanyPlayHelper.this.webSocketClient != null && AccompanyPlayHelper.this.webSocketClient.isOpen()) {
                            AccompanyPlayHelper.this.webSocketClient.send(audioChunk.toBytes());
                            if (AccompanyPlayHelper.this.isSendAudioData) {
                                ALOG.i(AccompanyPlayHelper.TAG, "\u5f00\u59cbsend: " + audioChunk.toBytes());
                            }
                            if (AccompanyPlayHelper.this.isSendRecordStartTime) {
                                AccompanyPlayHelper.this.isSendRecordStartTime = false;
                                emitter.onNext((Object)"record_success");
                            }
                        } else {
                            emitter.onNext((Object)"record_error");
                        }
                    }
                }));
                if (this.wavRecorder != null) {
                    this.wavRecorder.startRecording(this.getContext());
                }
            }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

                public void onSubscribe(@NonNull Disposable d) {
                }

                public void onNext(@NonNull String recorder) {
                    ALOG.i(AccompanyPlayHelper.TAG, "startRecording_onNext: " + recorder);
                    if (TextUtils.equals((CharSequence)"record_success", (CharSequence)recorder)) {
                        long bufferDuration = AccompanyPlayHelper.this.wavRecorder != null ? (long)AccompanyPlayHelper.this.wavRecorder.getBufferDuration() : 0L;
                        long time = System.currentTimeMillis();
                        long result = time - bufferDuration;
                        AccompanyPlayHelper.this.toPlayTuneMusic(result);
                    } else {
                        ALOG.i(AccompanyPlayHelper.TAG, "startRecording_onNextonError: ");
                        AccompanyPlayHelper.this.sendAccompanyError(AccompanyError.SOCKETERROR);
                        if (AccompanyPlayHelper.this.wavRecorder != null) {
                            AccompanyPlayHelper.this.wavRecorder.stopRecording();
                        }
                    }
                }

                public void onError(@NonNull Throwable e) {
                    ALOG.i(AccompanyPlayHelper.TAG, "startRecording_onNextonError: " + e.getMessage());
                    AccompanyPlayHelper.this.sendAccompanyError(AccompanyError.RECORDERROR);
                    if (AccompanyPlayHelper.this.wavRecorder != null) {
                        AccompanyPlayHelper.this.wavRecorder.stopRecording();
                    }
                }

                public void onComplete() {
                }
            });
        }
    }

    private void toPlayTuneMusic(long startTime) {
        this.isTag = true;
        this.isStartTune = true;
        this.startPlayTime = startTime;
        ALOG.i(TAG, "\u6821\u97f3startTime:" + this.startPlayTime);
        this.loopHandler.removeCallbacks(this.mTuneRunnable);
        this.loopHandler.postDelayed(this.mTuneRunnable, 10L);
        this.getPlayer().stop();
        this.getPlayer().setPrepareSeekPosition(-1);
        this.getPlayer().play(false, 1.0f, this.tuneSrc);
    }

    public void onFinishTune(JSONObject jsonObject) {
        int availableCount = 0;
        int availableValueSum = 0;
        for (int i = this.delayCheckResults.size() - 1; i >= 0; --i) {
            Integer integer = this.delayCheckResults.get(i);
            boolean availableValue = DeviceDelayCheckHelper.isAvailableValue(integer);
            if (!availableValue) continue;
            ALOG.i(TAG, "\u8fbe\u6807\u6837\u672c\u503c:" + integer);
            ++availableCount;
            availableValueSum += integer.intValue();
        }
        ALOG.i(TAG, "\u5ef6\u8fdf\u7b26\u5408\u6807\u672c\u6837\u672c\u4e2a\u6570:" + availableCount);
        ALOG.i(TAG, "\u6837\u672c\u603b\u6570:" + this.delayCheckResults.size());
        boolean isSuccess = false;
        if (availableCount != 0 && availableCount >= this.delayCheckResults.size() / 2) {
            int countValue = availableValueSum / availableCount;
            CacheHelper.setCustomCache(BLANK_DEVICE_DELAY_CACHE_KEY, countValue);
            isSuccess = true;
        } else {
            CacheHelper.setCustomCache(BLANK_DEVICE_DELAY_CACHE_KEY, 0);
            isSuccess = false;
        }
        ALOG.i(TAG, "delayCheckResults.clear");
        this.delayCheckResults.clear();
        if (this.mCheckHelper != null) {
            this.mCheckHelper.setCheckResult(isSuccess);
        }
        try {
            if (jsonObject == null) {
                return;
            }
            JSONObject contentJson = jsonObject.optJSONObject("content");
            if (contentJson == null) {
                contentJson = new JSONObject();
            }
            contentJson.put("result", isSuccess ? 1 : 0);
            jsonObject.put("content", (Object)contentJson);
            this.onSendMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseServerMsg(String serverMsg) {
        try {
            JSONObject jsonObject = new JSONObject(serverMsg);
            JSONObject headerObject = jsonObject.optJSONObject("header");
            if (headerObject == null) {
                return;
            }
            String commond = headerObject.optString("commond", "");
            String type = headerObject.optString("type", "");
            if (TextUtils.equals((CharSequence)commond, (CharSequence)"recordEnd") && TextUtils.equals((CharSequence)type, (CharSequence)"DELAY_CHECK")) {
                JSONObject bodyJsonObject = jsonObject.optJSONObject("body");
                if (bodyJsonObject == null) {
                    return;
                }
                double allDelay = bodyJsonObject.optDouble("firstNoteDelayDuration", -1.0);
                ALOG.i(TAG, "receive allDelay:" + allDelay);
                if (allDelay != -1.0) {
                    int blankDeviceDelay = (int)allDelay - this.playDelayTime;
                    ALOG.i(TAG, "count blankDeviceDelay:" + blankDeviceDelay);
                    this.delayCheckResults.add(blankDeviceDelay);
                    ALOG.i(TAG, "delayCheckResults add");
                }
                if (this.mCheckHelper != null) {
                    this.mCheckHelper.parseServerMsg(serverMsg);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendPlayProgressMessage(long cu, long duration) {
        JSONObject jsonObject = new JSONObject();
        JSONObject contentObject = new JSONObject();
        try {
            jsonObject.put("api", (Object)"playProgress");
            contentObject.put("currentTime", cu);
            contentObject.put("totalDuration", duration);
            jsonObject.put("content", (Object)contentObject);
            this.onSendMessage(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendCheckEndMessage() {
        JSONObject jsonObject = new JSONObject();
        JSONObject contentObject = new JSONObject();
        try {
            jsonObject.put("api", (Object)"checkPlayEnd");
            jsonObject.put("content", (Object)contentObject);
            this.onSendMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendOffsetMessage(long delayTime) {
        int customCache = CacheHelper.getCustomCacheForInt(BLANK_DEVICE_DELAY_CACHE_KEY);
        int allDelay = (int)(delayTime + (long)customCache);
        CacheHelper.setCustomCache(DELAY_FOR_CURRENT_CACHE_KEY, allDelay);
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject headerObject = new JSONObject();
            JSONObject bodyObject = new JSONObject();
            headerObject.put("commond", (Object)"audioPlayStart");
            headerObject.put("type", (Object)"SOUND_COMPARE");
            bodyObject.put("offsetTime", delayTime);
            bodyObject.put("micDelay", customCache);
            headerObject.put("status", 200);
            jsonObject.put("header", (Object)headerObject);
            jsonObject.put("body", (Object)bodyObject);
            if (Constants.DEBUG) {
                ToastUtil.getInstance().showShort(jsonObject.toString());
            }
            this.sendWebSocketMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendAccompanyError(AccompanyError accompanyError) {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject contentJson = new JSONObject();
            jsonObject.put("api", (Object)"accompanyError");
            contentJson.put("type", (Object)accompanyError.getType());
            contentJson.put("reson", (Object)accompanyError.getReason());
            jsonObject.put("content", (Object)contentJson);
            this.onSendMessage(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void stopPlay() {
        if (this.getPlayer() != null) {
            this.getPlayer().stop();
            this.loopHandler.removeCallbacks(this.mTuneRunnable);
            this.loopHandler.removeCallbacks(this.mRunnable2);
        }
    }

    private void releaseRecorder() {
        if (this.wavRecorder == null) {
            return;
        }
        this.wavRecorder.stopRecording();
        this.wavRecorder = null;
    }

    private CustomExoPlayer getPlayer() {
        if (this.player == null) {
            this.player = new CustomExoPlayer((Context)Utils.getApp());
            this.player.setOnCompletionListener(this);
        }
        return this.player;
    }

    private Context getContext() {
        return this.mContext;
    }

    private String getVoicePath() {
        return MyFileUtils.getRecordFilePath();
    }

    public void onSendMessage(String message) {
        if (this.webView == null) {
            return;
        }
        ALOG.i("onSendMessage: " + message);
        this.webView.evaluateJavascript("postMessage('" + message + "')", (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String s) {
            }
        });
    }

    public void stop() {
        this.stopPlay();
        this.releaseRecorder();
    }

    public void release() {
        if (this.loopHandler != null) {
            this.loopHandler.removeCallbacksAndMessages(null);
        }
        if (this.mCheckHelper != null) {
            this.mCheckHelper.release();
        }
        if (this.player != null) {
            this.player.stop();
            this.player.release();
        }
    }

    public void toPlayMusic(long startTime, int firstNoteTime, boolean isMute) {
        this.toPlayMusic(startTime, firstNoteTime, 1.0f, isMute);
    }

    public void toPlayMusic(long startTime, int firstNoteTime, float speed, boolean isMute) {
        if (TextUtils.isEmpty((CharSequence)this.musicSrc)) {
            return;
        }
        realPlayStartTime = -1L;
        CacheHelper.setCustomCache(DELAY_FOR_CURRENT_CACHE_KEY, 0);
        this.isTag = true;
        this.isStartTune = false;
        this.startPlayTime = startTime;
        ALOG.i(TAG, "\u8bc4\u6d4b\u66f2\u5b50startTime:" + this.startPlayTime);
        this.loopHandler.removeCallbacksAndMessages(null);
        this.loopHandler.postDelayed(this.mRunnable2, 15L);
        this.getPlayer().stop();
        this.getPlayer().setPrepareSeekPosition(firstNoteTime);
        this.getPlayer().play(isMute, speed, this.musicSrc);
    }

    public void setPlaySpeed(float speed) {
        if (this.player != null) {
            this.player.setSpeed(speed);
        }
    }

    @Override
    public void onCompletion() {
        ALOG.i(TAG, "play onCompletion");
        if (this.loopHandler != null) {
            this.loopHandler.removeCallbacks(this.mRunnable2);
            this.loopHandler.removeCallbacks(this.mTuneRunnable);
            this.sendPlayProgressMessage(this.player.getT(), this.player.getT());
            if (this.isStartTune) {
                if (this.isAutoEnd) {
                    this.endTune(null);
                } else {
                    this.sendCheckEndMessage();
                }
            }
        }
    }

    public void showDelayView() {
        if (this.mCheckHelper != null) {
            this.mCheckHelper.showDelayView();
        }
    }

    public void notifyWebSocketConnected() {
        if (this.mCheckHelper != null) {
            this.mCheckHelper.notifyWebSocketConnected();
        }
    }

    public void hideDelayView() {
        this.stopPlay();
        if (this.mCheckHelper != null) {
            this.mCheckHelper.closeDelay();
        }
    }

    public static interface OnEventListener {
        public SocketStatus getWebSocketStatus();
    }
}

