/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.earmonitor;

import android.content.Context;
import android.media.AudioManager;
import cn.rongcloud.rtc.earmonitor.EarMonitor;
import cn.rongcloud.rtc.earmonitor.SilentPlayer;
import cn.rongcloud.rtc.earmonitor.VivoKTVHelper;

public class VivoEarMonitor
implements EarMonitor {
    private VivoKTVHelper ktvHelper;
    private SilentPlayer silentPlayer;
    private boolean enabled = false;
    private AudioManager audioManager;

    @Override
    public void init(Context context) {
        if (this.ktvHelper == null) {
            this.audioManager = (AudioManager)context.getSystemService("audio");
            this.ktvHelper = VivoKTVHelper.getInstance(context);
            this.silentPlayer = new SilentPlayer();
        }
    }

    @Override
    public void destroy() {
        this.disable();
        if (this.ktvHelper != null) {
            this.ktvHelper.closeKTVDevice();
            this.ktvHelper = null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int enable() {
        if (this.enabled || this.ktvHelper == null) {
            return -1;
        }
        if (!this.ktvHelper.isDeviceSupportKaraoke()) {
            return -1;
        }
        this.audioManager.setMode(0);
        this.ktvHelper.setCustomMode(7);
        this.ktvHelper.openKTVDevice();
        this.ktvHelper.setPlayFeedbackParam(1);
        this.silentPlayer.play();
        this.enabled = true;
        return 0;
    }

    @Override
    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.silentPlayer.stop();
            if (this.ktvHelper != null) {
                this.ktvHelper.setPlayFeedbackParam(0);
                this.ktvHelper.closeKTVDevice();
            }
        }
    }

    @Override
    public boolean isSupported() {
        return this.ktvHelper != null && this.ktvHelper.isDeviceSupportKaraoke();
    }

    @Override
    public void adjustVolume(int volume) {
        if (this.ktvHelper != null) {
            this.ktvHelper.setMicVolParam((int)((float)volume / 100.0f * 15.0f));
        }
    }

    @Override
    public void reclaim() {
        this.disable();
    }

    public String toString() {
        return "VivoEarMonitor";
    }
}

